/*
 * Decompiled with CFR 0.152.
 */
package com.shatteredpixel.shatteredpixeldungeon.actors.buffs;

import com.shatteredpixel.shatteredpixeldungeon.Dungeon;
import com.shatteredpixel.shatteredpixeldungeon.actors.Actor;
import com.shatteredpixel.shatteredpixeldungeon.actors.Char;
import com.shatteredpixel.shatteredpixeldungeon.actors.buffs.Buff;
import com.shatteredpixel.shatteredpixeldungeon.actors.buffs.Daze;
import com.shatteredpixel.shatteredpixeldungeon.actors.buffs.FlavourBuff;
import com.shatteredpixel.shatteredpixeldungeon.actors.buffs.Vulnerable;
import com.shatteredpixel.shatteredpixeldungeon.actors.buffs.Weakness;
import com.shatteredpixel.shatteredpixeldungeon.actors.hero.Hero;
import com.shatteredpixel.shatteredpixeldungeon.actors.hero.Talent;
import com.shatteredpixel.shatteredpixeldungeon.effects.CellEmitter;
import com.shatteredpixel.shatteredpixeldungeon.effects.particles.BlastParticle;
import com.shatteredpixel.shatteredpixeldungeon.effects.particles.SmokeParticle;
import com.shatteredpixel.shatteredpixeldungeon.items.BrokenSeal;
import com.shatteredpixel.shatteredpixeldungeon.items.wands.WandOfBlastWave;
import com.shatteredpixel.shatteredpixeldungeon.mechanics.Ballistica;
import com.shatteredpixel.shatteredpixeldungeon.messages.Messages;
import com.shatteredpixel.shatteredpixeldungeon.scenes.GameScene;
import com.shatteredpixel.shatteredpixeldungeon.ui.ActionIndicator;
import com.shatteredpixel.shatteredpixeldungeon.ui.AttackIndicator;
import com.watabou.noosa.audio.Sample;
import com.watabou.utils.Bundle;
import com.watabou.utils.Callback;
import com.watabou.utils.PathFinder;
import com.watabou.utils.Random;
import java.util.ArrayList;

public class Tackle
extends FlavourBuff
implements ActionIndicator.Action {
    public int object;
    private static final String OBJECT = "object";
    public static final float DURATION = 1.0f;

    public Tackle() {
        this.actPriority = 1;
        this.object = 0;
        this.type = Buff.buffType.POSITIVE;
    }

    public void set(int object) {
        this.object = object;
    }

    @Override
    public boolean attachTo(Char target) {
        ActionIndicator.setAction(this);
        return super.attachTo(target);
    }

    @Override
    public void detach() {
        super.detach();
        ActionIndicator.clearAction(this);
    }

    @Override
    public boolean act() {
        Char ch = (Char)Actor.findById(this.object);
        if (ch == null) {
            this.detach();
            this.spend(1.0f);
            return true;
        }
        if (ch.alignment != Char.Alignment.ENEMY) {
            this.detach();
            this.spend(1.0f);
            return true;
        }
        if (!Dungeon.level.adjacent(ch.pos, Dungeon.hero.pos)) {
            this.detach();
            this.spend(1.0f);
            return true;
        }
        this.spend(1.0f);
        return true;
    }

    @Override
    public void storeInBundle(Bundle bundle) {
        super.storeInBundle(bundle);
        bundle.put(OBJECT, this.object);
    }

    @Override
    public void restoreFromBundle(Bundle bundle) {
        super.restoreFromBundle(bundle);
        this.object = bundle.getInt(OBJECT);
    }

    @Override
    public String actionName() {
        return Messages.get(this, "tackle", new Object[0]);
    }

    @Override
    public int actionIcon() {
        return 114;
    }

    @Override
    public int indicatorColor() {
        return 16767845;
    }

    @Override
    public void doAction() {
        Dungeon.hero.busy();
        final Char ch = (Char)Actor.findById(this.object);
        final Hero hero = Dungeon.hero;
        if (ch == null || hero == null || !Dungeon.level.adjacent(ch.pos, hero.pos)) {
            hero.next();
            this.detach();
            return;
        }
        if (hero.hasTalent(Talent.SUPER_ARMOR)) {
            Buff.affect(hero, SuperArmorTracker.class, 1.0f);
        }
        if (hero.hasTalent(Talent.MYSTICAL_TACKLE)) {
            Buff.affect(hero, MysticalTackleTracker.class, 1.0f);
        }
        this.target.sprite.attack(ch.pos, new Callback(){

            @Override
            public void call() {
                AttackIndicator.target(ch);
                float damageMulti = 0.4f + 0.2f * (float)hero.pointsInTalent(Talent.POWERFUL_TACKLE);
                int damage = Math.round((float)hero.drRoll() * damageMulti);
                Buff.affect(hero, TackleTracker.class);
                if (hero.attack(ch, 0.0f, damage, Char.INFINITE_ACCURACY)) {
                    Sample.INSTANCE.play("sounds/hit_strong.mp3");
                }
                if (hero.buff(BrokenSeal.WarriorShield.class) != null) {
                    BrokenSeal.WarriorShield shield = hero.buff(BrokenSeal.WarriorShield.class);
                    int amount = shield.shielding() + 1;
                    if (hero.hasTalent(Talent.IMPROVED_TACKLE)) {
                        ++amount;
                    }
                    shield.supercharge(Math.min(shield.maxShield(), amount));
                }
                int pushedPos = -1;
                Ballistica trajectory = new Ballistica(Tackle.this.target.pos, ch.pos, 1);
                trajectory = new Ballistica(trajectory.collisionPos, trajectory.path.get(trajectory.path.size() - 1), 7);
                int dist = 1;
                if (hero.pointsInTalent(Talent.IMPROVED_TACKLE) > 1) {
                    ++dist;
                }
                if (!ch.isAlive() || !ch.flying && hero.pointsInTalent(Talent.IMPROVED_TACKLE) < 3) {
                    while (dist > trajectory.dist || dist > 0 && Dungeon.level.pit[trajectory.path.get(dist)]) {
                        --dist;
                    }
                }
                WandOfBlastWave.throwChar(ch, trajectory, dist, true, true, hero.getClass());
                pushedPos = trajectory.path.get(dist);
                if (Actor.findChar(pushedPos) != null) {
                    int findPos = Math.max(0, dist - 1);
                    pushedPos = trajectory.path.get(findPos);
                }
                if (ch.isAlive() && hero.hasTalent(Talent.INCAPACITATION)) {
                    switch (hero.pointsInTalent(Talent.INCAPACITATION)) {
                        case 3: {
                            Buff.affect(ch, Vulnerable.class, 2.0f);
                        }
                        case 2: {
                            Buff.affect(ch, Weakness.class, 2.0f);
                        }
                        case 1: {
                            Buff.affect(ch, Daze.class, 2.0f);
                        }
                    }
                }
                hero.spendAndNext(1.0f);
                hero.buff(TackleTracker.class).detach();
                if (!ch.isAlive() && hero.hasTalent(Talent.DELAYED_GRENADE) && pushedPos != -1) {
                    int minDamage = Math.round(2.5f + 2.5f * (float)hero.pointsInTalent(Talent.DELAYED_GRENADE));
                    int maxDamage = 10 * (1 + hero.pointsInTalent(Talent.DELAYED_GRENADE));
                    ArrayList<Char> affected = new ArrayList<Char>();
                    for (int n : PathFinder.NEIGHBOURS9) {
                        Char enemy;
                        int c = pushedPos + n;
                        if (c < 0 || c >= Dungeon.level.length()) continue;
                        if (Dungeon.level.heroFOV[c]) {
                            CellEmitter.get(c).burst(SmokeParticle.FACTORY, 4);
                            CellEmitter.center(pushedPos).burst(BlastParticle.FACTORY, 4);
                        }
                        if (Dungeon.level.flamable[c]) {
                            Dungeon.level.destroy(c);
                            GameScene.updateMap(c);
                        }
                        if ((enemy = Actor.findChar(c)) == null || enemy == hero || enemy.alignment == Char.Alignment.ALLY) continue;
                        affected.add(enemy);
                    }
                    Object object = affected.iterator();
                    while (object.hasNext()) {
                        Char enemy = (Char)object.next();
                        enemy.damage(Random.NormalIntRange(minDamage, maxDamage), hero);
                    }
                }
            }
        });
        this.detach();
    }

    public static class SuperArmorTracker
    extends FlavourBuff {
        public SuperArmorTracker() {
            this.actPriority = 1;
        }
    }

    public static class MysticalTackleTracker
    extends FlavourBuff {
        public MysticalTackleTracker() {
            this.actPriority = 1;
        }
    }

    public static class TackleTracker
    extends Buff {
    }
}

