/*
 * Decompiled with CFR 0.152.
 */
package com.shatteredpixel.shatteredpixeldungeon.actors.buffs;

import com.shatteredpixel.shatteredpixeldungeon.actors.buffs.Buff;
import com.shatteredpixel.shatteredpixeldungeon.items.Item;
import com.shatteredpixel.shatteredpixeldungeon.messages.Messages;
import com.watabou.noosa.Image;
import com.watabou.utils.Bundle;

public class UpgradeShare
extends Buff {
    private int level;
    private float duration;
    private float maxDuration;
    private static final String LEVEL = "level";
    private static final String DURATION = "duration";
    private static final String MAXDURATION = "maxDuration";

    public UpgradeShare() {
        this.type = Buff.buffType.POSITIVE;
        this.level = 0;
        this.duration = 0.0f;
        this.maxDuration = 0.0f;
    }

    @Override
    public void storeInBundle(Bundle bundle) {
        super.storeInBundle(bundle);
        bundle.put(LEVEL, this.level);
        bundle.put(DURATION, this.duration);
        bundle.put(MAXDURATION, this.maxDuration);
    }

    @Override
    public void restoreFromBundle(Bundle bundle) {
        super.restoreFromBundle(bundle);
        this.level = bundle.getInt(LEVEL);
        this.duration = bundle.getFloat(DURATION);
        this.maxDuration = bundle.getFloat(MAXDURATION);
    }

    public int level() {
        return this.level;
    }

    public void set(int upgrade, float time) {
        this.level = upgrade;
        this.maxDuration = this.duration = time;
    }

    @Override
    public int icon() {
        return 50;
    }

    @Override
    public void tintIcon(Image icon) {
        icon.hardlight(55296);
    }

    @Override
    public float iconFadePercent() {
        return Math.max(0.0f, (this.maxDuration - this.duration) / this.maxDuration);
    }

    public String toString() {
        return Messages.get(this, "name", new Object[0]);
    }

    @Override
    public String desc() {
        return Messages.get(this, "desc", this.level, this.level, Float.valueOf(this.duration));
    }

    @Override
    public boolean act() {
        this.duration -= 1.0f;
        this.spend(1.0f);
        if (this.duration <= 0.0f) {
            this.detach();
            Item.updateQuickslot();
        }
        return true;
    }
}

