/*
 * Decompiled with CFR 0.152.
 */
package com.shatteredpixel.shatteredpixeldungeon.actors.buffs;

import com.shatteredpixel.shatteredpixeldungeon.Dungeon;
import com.shatteredpixel.shatteredpixeldungeon.actors.Actor;
import com.shatteredpixel.shatteredpixeldungeon.actors.Char;
import com.shatteredpixel.shatteredpixeldungeon.actors.buffs.AllyBuff;
import com.shatteredpixel.shatteredpixeldungeon.actors.buffs.Buff;
import com.shatteredpixel.shatteredpixeldungeon.actors.buffs.Charm;
import com.shatteredpixel.shatteredpixeldungeon.actors.buffs.Terror;
import com.shatteredpixel.shatteredpixeldungeon.actors.hero.Talent;
import com.shatteredpixel.shatteredpixeldungeon.actors.mobs.Mob;
import com.shatteredpixel.shatteredpixeldungeon.actors.mobs.npcs.NPC;
import com.shatteredpixel.shatteredpixeldungeon.effects.Speck;
import com.shatteredpixel.shatteredpixeldungeon.items.scrolls.exotic.ScrollOfSirensSong;
import com.shatteredpixel.shatteredpixeldungeon.messages.Messages;
import com.shatteredpixel.shatteredpixeldungeon.scenes.CellSelector;
import com.shatteredpixel.shatteredpixeldungeon.scenes.GameScene;
import com.shatteredpixel.shatteredpixeldungeon.sprites.HeroSprite;
import com.shatteredpixel.shatteredpixeldungeon.ui.ActionIndicator;
import com.shatteredpixel.shatteredpixeldungeon.ui.BuffIndicator;
import com.shatteredpixel.shatteredpixeldungeon.utils.GLog;
import com.watabou.noosa.Image;
import com.watabou.noosa.audio.Sample;
import com.watabou.utils.Bundle;
import com.watabou.utils.Random;

public class WantedTracker
extends Buff
implements ActionIndicator.Action {
    private CellSelector.Listener wanted;

    public WantedTracker() {
        this.actPriority = -31;
        this.announced = false;
        this.wanted = new CellSelector.Listener(){

            @Override
            public void onSelect(Integer cell) {
                if (cell == null) {
                    return;
                }
                Char enemy = Actor.findChar(cell);
                if (enemy == null || enemy instanceof NPC || !Dungeon.level.heroFOV[cell] || enemy == Dungeon.hero || enemy.alignment == Char.Alignment.ALLY) {
                    GLog.w(Messages.get(WantedTracker.class, "no_target", new Object[0]), new Object[0]);
                } else {
                    WantedTracker buff = Dungeon.hero.buff(WantedTracker.class);
                    Buff.affect(enemy, Wanted.class);
                    if (Dungeon.hero.hasTalent(Talent.INTIMIDATION)) {
                        Buff.affect(enemy, Terror.class, 3 * Dungeon.hero.pointsInTalent(Talent.INTIMIDATION));
                    }
                    if (Dungeon.hero.pointsInTalent(Talent.SURRENDER) > 2 && Random.Int(10) < 1 && enemy instanceof Mob) {
                        if (!enemy.isImmune(ScrollOfSirensSong.Enthralled.class)) {
                            AllyBuff.affectAndLoot((Mob)enemy, Dungeon.hero, ScrollOfSirensSong.Enthralled.class);
                        } else {
                            Buff.affect((Char)enemy, Charm.class, (float)10.0f).object = Dungeon.hero.id();
                        }
                        enemy.sprite.centerEmitter().burst(Speck.factory(11), 10);
                        enemy.buff(Wanted.class).detach();
                    }
                    Buff.affect(Dungeon.hero, WantedCoolDown.class).set();
                    buff.clearAction();
                    Dungeon.hero.busy();
                    Sample.INSTANCE.play("sounds/read.mp3");
                    ((HeroSprite)Dungeon.hero.sprite).read();
                    Dungeon.hero.sprite.centerEmitter().start(Speck.factory(5), 0.3f, 3);
                    Dungeon.hero.next();
                }
            }

            @Override
            public String prompt() {
                return Messages.get(WantedTracker.class, "prompt", new Object[0]);
            }
        };
    }

    @Override
    public boolean act() {
        this.spend(1.0f);
        return true;
    }

    @Override
    public void detach() {
        super.detach();
        ActionIndicator.clearAction(this);
    }

    @Override
    public String actionName() {
        return Messages.get(this, "action_name", new Object[0]);
    }

    @Override
    public int actionIcon() {
        return 24;
    }

    @Override
    public int indicatorColor() {
        return 0xFFAA33;
    }

    @Override
    public void doAction() {
        if (Dungeon.hero.buff(WantedCoolDown.class) == null) {
            GameScene.selectCell(this.wanted);
        } else {
            ActionIndicator.clearAction(this);
        }
    }

    public void indicate() {
        ActionIndicator.setAction(this);
    }

    public void clearAction() {
        ActionIndicator.clearAction(this);
    }

    @Override
    public void restoreFromBundle(Bundle bundle) {
        super.restoreFromBundle(bundle);
        ActionIndicator.setAction(this);
    }

    public static class WantedCoolDown
    extends Buff {
        float duration;
        int maxDuration = 50;
        private static final String DURATION = "duration";
        private static final String MAX_DURATION = "maxDuration";

        public WantedCoolDown() {
            this.type = Buff.buffType.NEUTRAL;
        }

        public void set() {
            this.duration = this.maxDuration;
        }

        public void reduce() {
            this.duration -= (float)this.maxDuration / 3.0f * (float)Dungeon.hero.pointsInTalent(Talent.INVEST_END);
            if (this.duration <= 0.0f) {
                this.detach();
            }
            BuffIndicator.refreshHero();
        }

        @Override
        public boolean act() {
            this.duration -= 1.0f;
            this.spend(1.0f);
            if (this.duration <= 0.0f) {
                this.detach();
            }
            return true;
        }

        @Override
        public void storeInBundle(Bundle bundle) {
            super.storeInBundle(bundle);
            bundle.put(DURATION, this.duration);
            bundle.put(MAX_DURATION, this.maxDuration);
        }

        @Override
        public void restoreFromBundle(Bundle bundle) {
            super.restoreFromBundle(bundle);
            this.duration = bundle.getFloat(DURATION);
            this.maxDuration = bundle.getInt(MAX_DURATION);
        }

        @Override
        public int icon() {
            return 7;
        }

        @Override
        public void tintIcon(Image icon) {
            icon.hardlight(16722432);
        }

        @Override
        public float iconFadePercent() {
            return Math.max(0.0f, ((float)this.maxDuration - this.duration) / (float)this.maxDuration);
        }

        @Override
        public void detach() {
            WantedTracker buff = Dungeon.hero.buff(WantedTracker.class);
            buff.indicate();
            super.detach();
        }

        public String toString() {
            return Messages.get(this, "name", new Object[0]);
        }

        @Override
        public String desc() {
            return Messages.get(this, "desc", Float.valueOf(this.duration));
        }
    }

    public static class Wanted
    extends Buff {
        public Wanted() {
            this.type = Buff.buffType.NEUTRAL;
            this.announced = true;
        }

        @Override
        public int icon() {
            return 149;
        }

        @Override
        public boolean act() {
            this.spend(1.0f);
            return true;
        }

        @Override
        public String desc() {
            return Messages.get(this, "desc", 10 + 5 * Dungeon.hero.pointsInTalent(Talent.JUSTICE_BULLET));
        }
    }
}

