/*
 * Decompiled with CFR 0.152.
 */
package com.shatteredpixel.shatteredpixeldungeon.actors.hero;

import com.shatteredpixel.shatteredpixeldungeon.Dungeon;
import com.shatteredpixel.shatteredpixeldungeon.GamesInProgress;
import com.shatteredpixel.shatteredpixeldungeon.ShatteredPixelDungeon;
import com.shatteredpixel.shatteredpixeldungeon.actors.Actor;
import com.shatteredpixel.shatteredpixeldungeon.actors.Char;
import com.shatteredpixel.shatteredpixeldungeon.actors.buffs.Adrenaline;
import com.shatteredpixel.shatteredpixeldungeon.actors.buffs.AllyBuff;
import com.shatteredpixel.shatteredpixeldungeon.actors.buffs.ArmorEmpower;
import com.shatteredpixel.shatteredpixeldungeon.actors.buffs.ArtifactRecharge;
import com.shatteredpixel.shatteredpixeldungeon.actors.buffs.Barrier;
import com.shatteredpixel.shatteredpixeldungeon.actors.buffs.Buff;
import com.shatteredpixel.shatteredpixeldungeon.actors.buffs.CertainCrit;
import com.shatteredpixel.shatteredpixeldungeon.actors.buffs.CounterBuff;
import com.shatteredpixel.shatteredpixeldungeon.actors.buffs.EnhancedRings;
import com.shatteredpixel.shatteredpixeldungeon.actors.buffs.ExtraBullet;
import com.shatteredpixel.shatteredpixeldungeon.actors.buffs.FlavourBuff;
import com.shatteredpixel.shatteredpixeldungeon.actors.buffs.Haste;
import com.shatteredpixel.shatteredpixeldungeon.actors.buffs.HealingArea;
import com.shatteredpixel.shatteredpixeldungeon.actors.buffs.InfiniteBullet;
import com.shatteredpixel.shatteredpixeldungeon.actors.buffs.LostInventory;
import com.shatteredpixel.shatteredpixeldungeon.actors.buffs.Paralysis;
import com.shatteredpixel.shatteredpixeldungeon.actors.buffs.PhysicalEmpower;
import com.shatteredpixel.shatteredpixeldungeon.actors.buffs.Poison;
import com.shatteredpixel.shatteredpixeldungeon.actors.buffs.Recharging;
import com.shatteredpixel.shatteredpixeldungeon.actors.buffs.RevealedArea;
import com.shatteredpixel.shatteredpixeldungeon.actors.buffs.Roots;
import com.shatteredpixel.shatteredpixeldungeon.actors.buffs.Sheathing;
import com.shatteredpixel.shatteredpixeldungeon.actors.buffs.WandEmpower;
import com.shatteredpixel.shatteredpixeldungeon.actors.hero.Hero;
import com.shatteredpixel.shatteredpixeldungeon.actors.hero.HeroClass;
import com.shatteredpixel.shatteredpixeldungeon.actors.hero.HeroSubClass;
import com.shatteredpixel.shatteredpixeldungeon.actors.hero.abilities.ArmorAbility;
import com.shatteredpixel.shatteredpixeldungeon.actors.hero.abilities.Ratmogrify;
import com.shatteredpixel.shatteredpixeldungeon.actors.mobs.Mob;
import com.shatteredpixel.shatteredpixeldungeon.effects.CellEmitter;
import com.shatteredpixel.shatteredpixeldungeon.effects.Speck;
import com.shatteredpixel.shatteredpixeldungeon.effects.SpellSprite;
import com.shatteredpixel.shatteredpixeldungeon.effects.particles.LeafParticle;
import com.shatteredpixel.shatteredpixeldungeon.items.BrokenSeal;
import com.shatteredpixel.shatteredpixeldungeon.items.Item;
import com.shatteredpixel.shatteredpixeldungeon.items.armor.Armor;
import com.shatteredpixel.shatteredpixeldungeon.items.armor.ClothArmor;
import com.shatteredpixel.shatteredpixeldungeon.items.artifacts.CloakOfShadows;
import com.shatteredpixel.shatteredpixeldungeon.items.artifacts.HornOfPlenty;
import com.shatteredpixel.shatteredpixeldungeon.items.potions.Potion;
import com.shatteredpixel.shatteredpixeldungeon.items.potions.exotic.PotionOfCleansing;
import com.shatteredpixel.shatteredpixeldungeon.items.rings.Ring;
import com.shatteredpixel.shatteredpixeldungeon.items.scrolls.ScrollOfRecharging;
import com.shatteredpixel.shatteredpixeldungeon.items.scrolls.ScrollOfUpgrade;
import com.shatteredpixel.shatteredpixeldungeon.items.scrolls.exotic.ScrollOfEnchantment;
import com.shatteredpixel.shatteredpixeldungeon.items.stones.StoneOfEnchantment;
import com.shatteredpixel.shatteredpixeldungeon.items.wands.Wand;
import com.shatteredpixel.shatteredpixeldungeon.items.weapon.SpiritBow;
import com.shatteredpixel.shatteredpixeldungeon.items.weapon.Weapon;
import com.shatteredpixel.shatteredpixeldungeon.items.weapon.melee.Gloves;
import com.shatteredpixel.shatteredpixeldungeon.items.weapon.melee.MagesStaff;
import com.shatteredpixel.shatteredpixeldungeon.items.weapon.melee.MeleeWeapon;
import com.shatteredpixel.shatteredpixeldungeon.items.weapon.missiles.MissileWeapon;
import com.shatteredpixel.shatteredpixeldungeon.levels.Level;
import com.shatteredpixel.shatteredpixeldungeon.messages.Messages;
import com.shatteredpixel.shatteredpixeldungeon.scenes.GameScene;
import com.shatteredpixel.shatteredpixeldungeon.ui.AttackIndicator;
import com.shatteredpixel.shatteredpixeldungeon.utils.GLog;
import com.watabou.noosa.Image;
import com.watabou.noosa.audio.Sample;
import com.watabou.noosa.particles.Emitter;
import com.watabou.utils.Bundle;
import com.watabou.utils.Callback;
import com.watabou.utils.GameMath;
import com.watabou.utils.PathFinder;
import com.watabou.utils.Random;
import com.watabou.utils.Reflection;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;

public enum Talent {
    HEARTY_MEAL(0),
    VETERANS_INTUITION(1),
    TEST_SUBJECT(2),
    IRON_WILL(3),
    MAX_HEALTH(4),
    IRON_STOMACH(5),
    RESTORED_WILLPOWER(6),
    RUNIC_TRANSFERENCE(7),
    LETHAL_MOMENTUM(8),
    IMPROVISED_PROJECTILES(9),
    PARRY(10),
    HOLD_FAST(11, 3),
    STRONGMAN(12, 3),
    ENDLESS_RAGE(13, 3),
    DEATHLESS_FURY(14, 3),
    ENRAGED_CATALYST(15, 3),
    LETHAL_RAGE(16, 3),
    MAX_RAGE(17, 3),
    ENDURANCE(18, 3),
    CLEAVE(19, 3),
    LETHAL_DEFENSE(20, 3),
    ENHANCED_COMBO(21, 3),
    QUICK_SWAP(22, 3),
    OFFENSIVE_DEFENSE(23, 3),
    SKILL_ENHANCE(24, 3),
    POWERFUL_TACKLE(25, 3),
    MYSTICAL_TACKLE(26, 3),
    DELAYED_GRENADE(27, 3),
    INCAPACITATION(28, 3),
    SUPER_ARMOR(29, 3),
    IMPROVED_TACKLE(30, 3),
    BODY_SLAM(31, 4),
    IMPACT_WAVE(32, 4),
    DOUBLE_JUMP(33, 4),
    EXPANDING_WAVE(34, 4),
    STRIKING_WAVE(35, 4),
    SHOCK_FORCE(36, 4),
    SUSTAINED_RETRIBUTION(37, 4),
    SHRUG_IT_OFF(38, 4),
    EVEN_THE_ODDS(39, 4),
    EMPOWERING_MEAL(44),
    SCHOLARS_INTUITION(45),
    TESTED_HYPOTHESIS(46),
    BACKUP_BARRIER(47),
    CHARGE_PRESERVE(48),
    ENERGIZING_MEAL(49),
    ENERGIZING_UPGRADE(50),
    WAND_PRESERVATION(51),
    ARCANE_VISION(52),
    SHIELD_BATTERY(53),
    FASTER_CHARGER(54),
    EMPOWERING_SCROLLS(55, 3),
    ALLY_WARP(56, 3),
    EMPOWERED_STRIKE(57, 3),
    MYSTICAL_CHARGE(58, 3),
    EXCESS_CHARGE(59, 3),
    BATTLE_MAGIC(60, 3),
    MAGIC_RUSH(61, 3),
    MAGICAL_CIRCLE(62, 3),
    SOUL_EATER(63, 3),
    SOUL_SIPHON(64, 3),
    NECROMANCERS_MINIONS(65, 3),
    MADNESS(66, 3),
    ENHANCED_MARK(67, 3),
    MARK_OF_WEAKNESS(68, 3),
    SPELL_ENHANCE(69, 3),
    BRIG_BOOST(70, 3),
    ENERGY_REMAINS(71, 3),
    SOUL_OF_BATTLEMAGE(72, 3),
    SOUL_OF_WARLOCK(73, 3),
    LIFE_ENERGY(74, 3),
    BLAST_RADIUS(75, 4),
    ELEMENTAL_POWER(76, 4),
    REACTIVE_BARRIER(77, 4),
    WILD_POWER(78, 4),
    FIRE_EVERYTHING(79, 4),
    CONSERVED_MAGIC(80, 4),
    TELEFRAG(81, 4),
    REMOTE_BEACON(82, 4),
    LONGRANGE_WARP(83, 4),
    CACHED_RATIONS(88),
    THIEFS_INTUITION(89),
    SUCKER_PUNCH(90),
    PROTECTIVE_SHADOWS(91),
    EMERGENCY_ESCAPE(92),
    MYSTICAL_MEAL(93),
    MYSTICAL_UPGRADE(94),
    WIDE_SEARCH(95),
    SILENT_STEPS(96),
    ROGUES_FORESIGHT(97),
    MOVESPEED_ENHANCE(98),
    ENHANCED_RINGS(99, 3),
    LIGHT_CLOAK(100, 3),
    ENHANCED_LETHALITY(101, 3),
    ASSASSINS_REACH(102, 3),
    BOUNTY_HUNTER(103, 3),
    ENERGY_DRAW(104, 3),
    PERFECT_ASSASSIN(105, 3),
    CAUTIOUS_PREP(106, 3),
    EVASIVE_ARMOR(107, 3),
    PROJECTILE_MOMENTUM(108, 3),
    SPEEDY_STEALTH(109, 3),
    QUICK_PREP(110, 3),
    OVERCOMING(111, 3),
    MOMENTARY_FOCUSING(112, 3),
    POISONOUS_BLADE(113, 3),
    LETHAL_SURPRISE(114, 3),
    CHAIN_CLOCK(115, 3),
    SOUL_COLLECT(116, 3),
    TRAIL_TRACKING(117, 3),
    MASTER_OF_CLOAKING(118, 3),
    HASTY_RETREAT(119, 4),
    BODY_REPLACEMENT(120, 4),
    SHADOW_STEP(121, 4),
    FEAR_THE_REAPER(122, 4),
    DEATHLY_DURABILITY(123, 4),
    DOUBLE_MARK(124, 4),
    SHADOW_BLADE(125, 4),
    CLONED_ARMOR(126, 4),
    PERFECT_COPY(127, 4),
    NATURES_BOUNTY(132),
    SURVIVALISTS_INTUITION(133),
    FOLLOWUP_STRIKE(134),
    NATURES_AID(135),
    WATER_FRIENDLY(136),
    INVIGORATING_MEAL(137),
    RESTORED_NATURE(138),
    REJUVENATING_STEPS(139),
    HEIGHTENED_SENSES(140),
    DURABLE_PROJECTILES(141),
    ADDED_MEAL(142),
    POINT_BLANK(143, 3),
    SEER_SHOT(144, 3),
    FARSIGHT(145, 3),
    SHARED_ENCHANTMENT(146, 3),
    SHARED_UPGRADES(147, 3),
    KICK(148, 3),
    SHOOTING_EYES(149, 3),
    TARGET_SPOTTING(150, 3),
    DURABLE_TIPS(151, 3),
    BARKSKIN(152, 3),
    SHIELDING_DEW(153, 3),
    DENSE_GRASS(154, 3),
    ATTRACTION(155, 3),
    WITHDRAW_TRAP(156, 3),
    SWIFT_MOVEMENT(157, 3),
    LESS_RESIST(158, 3),
    RING_KNUCKLE(159, 3),
    MYSTICAL_PUNCH(160, 3),
    QUICK_STEP(161, 3),
    COUNTER_ATTACK(162, 3),
    FAN_OF_BLADES(163, 4),
    PROJECTING_BLADES(164, 4),
    SPIRIT_BLADES(165, 4),
    GROWING_POWER(166, 4),
    NATURES_WRATH(167, 4),
    WILD_MOMENTUM(168, 4),
    EAGLE_EYE(169, 4),
    GO_FOR_THE_EYES(170, 4),
    SWIFT_SPIRIT(171, 4),
    STRENGTHENING_MEAL(176),
    ADVENTURERS_INTUITION(177),
    PATIENT_STRIKE(178),
    AGGRESSIVE_BARRIER(179),
    SKILLED_HAND(180),
    FOCUSED_MEAL(181),
    RESTORED_AGILITY(182),
    WEAPON_RECHARGING(183),
    LETHAL_HASTE(184),
    SWIFT_EQUIP(185),
    ACCUMULATION(186),
    PRECISE_ASSAULT(187, 3),
    DEADLY_FOLLOWUP(188, 3),
    SECONDARY_CHARGE(189, 3),
    TWIN_UPGRADES(190, 3),
    COMBINED_LETHALITY(191, 3),
    FASTER_CHARGE(192, 3),
    QUICK_FOLLOWUP(193, 3),
    MOMENTARY_UPGRADE(194, 3),
    UNENCUMBERED_SPIRIT(195, 3),
    MONASTIC_VIGOR(196, 3),
    COMBINED_ENERGY(197, 3),
    RESTORED_ENERGY(198, 3),
    ENERGY_BARRIER(199, 3),
    IRON_PUNCH(200, 3),
    CLAM_STEPS(201, 3),
    CRITICAL_MOMENTUM(202, 3),
    KINETIC_MOVEMENT(203, 3),
    AGGRESSIVE_MOVEMENT(204, 3),
    UNENCUMBERED_MOVEMENT(205, 3),
    SOULIZE(206, 3),
    CLOSE_THE_GAP(207, 4),
    INVIGORATING_VICTORY(208, 4),
    ELIMINATION_MATCH(209, 4),
    ELEMENTAL_REACH(210, 4),
    STRIKING_FORCE(211, 4),
    DIRECTED_POWER(212, 4),
    FEIGNED_RETREAT(213, 4),
    EXPOSE_WEAKNESS(214, 4),
    COUNTER_ABILITY(215, 4),
    REARRANGE(264),
    GUNNERS_INTUITION(265),
    SPEEDY_MOVE(266),
    SAFE_RELOAD(267),
    MIND_VISION(268),
    IN_THE_GUNFIRE(269),
    ANOTHER_CHANCE(270),
    RELOAD_PRACTICE(271),
    CAMOUFLAGE(272),
    LARGER_MAGAZINE(273),
    TRANSMUTATION_CONTROL(274),
    STREET_BATTLE(275, 3),
    FAST_RELOAD(276, 3),
    JUSTICE_BULLET(277, 3),
    INTIMIDATION(278, 3),
    SEARCH(279, 3),
    COVER(280, 3),
    SURRENDER(281, 3),
    INVEST_END(282, 3),
    QUICK_RELOAD(283, 3),
    MOVING_SHOT(284, 3),
    ELEMENTAL_BULLET(285, 3),
    MYSTICAL_THROW(286, 3),
    SOUL_BULLET(287, 3),
    LIGHT_MOVEMENT(288, 3),
    SILENCER(289, 3),
    SKILLFUL_RUNNER(290, 3),
    STEALTH(291, 3),
    INTO_THE_SHADOW(292, 3),
    RANGED_SNIPING(293, 3),
    TELESCOPE(294, 3),
    HASTE_MOVE(295, 4),
    SHOT_CONCENTRATION(296, 4),
    ROUND_PRESERVE(297, 4),
    BAYONET(298, 4),
    TACTICAL_SIGHT(299, 4),
    PLATE_ADD(300, 4),
    ADDITIONAL_MEDS(301, 4),
    THERAPEUTIC_BANDAGE(302, 4),
    FASTER_HEALING(303, 4),
    SURPRISE_STAB(308),
    MASTERS_INTUITION(309),
    UNEXPECTED_SLASH(310),
    FLOW_AWAY(311),
    ADRENALINE_SURGE(312),
    FOCUSING_MEAL(313),
    CRITICAL_UPGRADE(314),
    MAGICAL_TRANSFERENCE(315),
    EYE_OF_DRAGON(316),
    DETECTION(317),
    CRITICAL_THROW(318),
    DEEP_SCAR(319, 3),
    FAST_LEAD(320, 3),
    CONTINUOUS_ATTACK(321, 3),
    SLASHING_PRACTICE(322, 3),
    SERIAL_MOMENTUM(323, 3),
    ARCANE_ATTACK(324, 3),
    SLASHING(325, 3),
    DETECTIVE_SLASHING(326, 3),
    DONG_MIND_EYES(327, 3),
    DONG_SHEATHING(328, 3),
    DONG_POLISHING(329, 3),
    JUNG_DETECTION(330, 3),
    JUNG_QUICK_DRAW(331, 3),
    JUNG_INCISIVE_BLADE(332, 3),
    AFTERIMAGE(333, 3),
    ENERGY_DRAIN(334, 3),
    FTL(335, 3),
    QUICK_RECOVER(336, 3),
    HASTE_RECOVER(337, 3),
    FLURRY(338, 3),
    AWAKE_LIMIT(339, 4),
    AWAKE_DURATION(340, 4),
    INSURANCE(341, 4),
    DOUBLE_BLADE_PRACTICE(342, 4),
    CRITICAL_SHADOW(343, 4),
    HERBAL_SHADOW(344, 4),
    KUNAI_OF_DOOM(345, 4),
    MYSTICAL_KUNAI(346, 4),
    CORROSIVE_KUNAI(347, 4),
    SUDDEN_GROWTH(352),
    SAFE_POTION(353),
    ROOT(354),
    PLANT_SHIELD(355),
    KNOWLEDGE_HERB(356),
    NATURAL_MEAL(357),
    HERBAL_DEW(358),
    SPROUT(359),
    FIREWATCH(360),
    FLOWER_BED(361),
    WEAK_POISON(362),
    BLOOMING_WEAPON(363, 3),
    FARMER(364, 3),
    TAKEDOWN(365, 3),
    DETECTOR(366, 3),
    GOLD_SHIELD(367, 3),
    GOLD_MINER(368, 3),
    FINDING_TREASURE(369, 3),
    HIDDEN_STASH(370, 3),
    JUNGLE_ADVENTURE(371, 3),
    SHADOW(372, 3),
    VINE_WHIP(373, 3),
    THORNY_VINE(374, 3),
    SNARE(375, 3),
    SHARP_INTUITION(376, 3),
    ALIVE_GRASS(377, 3),
    DEW_MAKING(378, 3),
    BIO_ENERGY(379, 3),
    ROOT_PLANT(380, 3),
    BIOLOGY_PROJECT(381, 3),
    CHEMICAL(382, 3),
    JUNGLE(383, 4),
    FOREST(384, 4),
    REGROWTH(385, 4),
    LONG_LUCK(386, 4),
    FORESIGHT(387, 4),
    GOLD_HUNTER(388, 4),
    POISONOUS_ROOT(389, 4),
    ROOT_SPREAD(390, 4),
    ROOT_ARMOR(391, 4),
    ON_ALERT(396),
    KNIGHTS_INTUITION(397),
    ARMOR_ENHANCE(398),
    ACTIVE_BARRIER(399),
    WAR_CRY(400),
    IMPREGNABLE_MEAL(401),
    SAFE_HEALING(402),
    DEFENSE_STANCE(403),
    FAITH(404),
    CHIVALRY(405),
    ARMOR_ADAPTION(406),
    CRAFTMANS_SKILLS(407, 3),
    TACKLE(408, 3),
    CLASH(409, 3),
    MYSTICAL_POWER(410, 3),
    ABSOLUTE_ZERO(411, 3),
    EARTHQUAKE(412, 3),
    SPEAR_N_SHIELD(413, 3),
    UPGRADE_SHARE(414, 3),
    IMPREGNABLE_WALL(415, 3),
    COUNTER_MOMENTUM(416, 3),
    SHIELD_SLAM(417, 3),
    PREPARATION(418, 3),
    FORTRESS(419, 3),
    MYSTICAL_COUNTER(420, 3),
    DIVINE_SHIELD(421, 3),
    DEADS_BLESS(422, 3),
    ARMOR_BLESSING(423, 3),
    BLESSED_TALENT(424, 3),
    MYSTICAL_VEIL(425, 3),
    SHIELD_OF_LIGHT(426, 3),
    BUFFER_BARRIER(427, 4),
    HOLY_LIGHT(428, 4),
    BLESS(429, 4),
    BURDEN_RELIEF(430, 4),
    LASTING_PACK(431, 4),
    TIME_STOP(432, 4),
    BLESSED_ANKH(433, 4),
    ANKH_ENHANCE(434, 4),
    COMPLETE_ANKH(435, 4),
    HEALING_MEAL(440),
    DOCTORS_INTUITION(441),
    PROTECTIVE_HEAL(442),
    CRITICAL_SHIELD(443),
    PROTECTIVE_CLOTHING(444),
    DISINFECTING_MEAL(445),
    POTION_SPREAD(446),
    HEALAREA(447),
    POISON_INJECT(448),
    CHEAT_THE_DEATH(449),
    WINNERS_FLAG(450),
    POWERFUL_BOND(451, 3),
    CHARISMA(452, 3),
    PROMOTION(453, 3),
    HEALING_SHIELD(454, 3),
    HEAL_ENHANCE(455, 3),
    COMP_RECOVER(456, 3),
    IMMUNE_SYSTEM(457, 3),
    HIGHER_HEAL(458, 3),
    APPEASE(459, 3),
    ANGEL_AND_DEVIL(460, 3),
    AREA_OF_LIGHT(461, 3),
    BLESS_ENHANCE(462, 3),
    PERSUASION(463, 3),
    HOLY_PROTECTION(464, 3),
    SCALPEL(465, 3),
    DEFIBRILLATOR(466, 3),
    DEATH_DIAGNOSIS(467, 3),
    FIRST_AID(468, 3),
    DISINFECTION(469, 3),
    HASTY_HANDS(470, 3),
    AREA_AMP(471, 4),
    SHIELD_GEN(472, 4),
    DURABLE_GEN(473, 4),
    LIGHT_LIKE_FEATHER(474, 4),
    ANGELS_BLESS(475, 4),
    HEALING_WING(476, 4),
    TRANSMOG_BIAS(477, 4),
    IMPRINTING_EFFECT(478, 4),
    SHEEP_TRANSMOG(479, 4),
    HEROIC_ENERGY(43, 4),
    RATSISTANCE(568, 4),
    RATLOMACY(569, 4),
    RATFORCEMENTS(570, 4),
    ATK_SPEED_ENHANCE(528, 4),
    ACC_ENHANCE(529, 4),
    EVA_ENHANCE(530, 4),
    BETTER_CHOICE(531, 3);

    int icon;
    int maxPoints;
    public static int[] tierLevelThresholds;
    private static int upgradeUsed;
    public static final int MAX_TALENT_TIERS = 4;
    private static final String TALENT_TIER = "talents_tier_";
    private static final HashSet<String> removedTalents;
    private static final HashMap<String, String> renamedTalents;

    private Talent(int icon) {
        this(icon, 2);
    }

    private Talent(int icon, int maxPoints) {
        this.icon = icon;
        this.maxPoints = maxPoints;
    }

    public int icon() {
        if (this == HEROIC_ENERGY) {
            if (Ratmogrify.useRatroicEnergy) {
                return 571;
            }
            HeroClass cls = Dungeon.hero != null ? Dungeon.hero.heroClass : GamesInProgress.selectedClass;
            switch (cls) {
                default: {
                    return 43;
                }
                case MAGE: {
                    return 87;
                }
                case ROGUE: {
                    return 131;
                }
                case HUNTRESS: {
                    return 175;
                }
                case DUELIST: {
                    return 219;
                }
                case GUNNER: {
                    return 307;
                }
                case SAMURAI: {
                    return 351;
                }
                case PLANTER: {
                    return 395;
                }
                case KNIGHT: {
                    return 439;
                }
                case NURSE: 
            }
            return 483;
        }
        return this.icon;
    }

    public int maxPoints() {
        return this.maxPoints;
    }

    public String title() {
        if (this == HEROIC_ENERGY && Ratmogrify.useRatroicEnergy) {
            return Messages.get((Object)this, this.name() + ".rat_title", new Object[0]);
        }
        return Messages.get((Object)this, this.name() + ".title", new Object[0]);
    }

    public final String desc() {
        return this.desc(false);
    }

    public String desc(boolean metamorphed) {
        String metaDesc;
        if (metamorphed && !(metaDesc = Messages.get((Object)this, this.name() + ".meta_desc", new Object[0])).equals("!!!NO TEXT FOUND!!!")) {
            return Messages.get((Object)this, this.name() + ".desc", new Object[0]) + "\n\n" + metaDesc;
        }
        return Messages.get((Object)this, this.name() + ".desc", new Object[0]);
    }

    public static void onTalentUpgraded(Hero hero, Talent talent) {
        HashSet<Class<? extends Potion>> potions;
        Potion p;
        if (talent == IRON_WILL && hero.heroClass != HeroClass.WARRIOR) {
            Buff.affect(hero, BrokenSeal.WarriorShield.class);
        }
        if (talent == MAX_HEALTH) {
            hero.updateHT(true);
        }
        if (talent == PARRY) {
            Buff.affect(hero, ParryTracker.class);
        }
        if (talent == NATURES_BOUNTY) {
            if (hero.pointsInTalent(NATURES_BOUNTY) == 1) {
                Buff.count(hero, NatureBerriesAvailable.class, 4.0f);
            } else {
                Buff.count(hero, NatureBerriesAvailable.class, 2.0f);
            }
        }
        if (talent == ACCUMULATION) {
            Item.updateQuickslot();
        }
        if (talent == LARGER_MAGAZINE) {
            Item.updateQuickslot();
        }
        if (talent == VETERANS_INTUITION && hero.pointsInTalent(VETERANS_INTUITION) == 2 && hero.belongings.armor() != null) {
            hero.belongings.armor.identify();
        }
        if (talent == THIEFS_INTUITION && hero.pointsInTalent(THIEFS_INTUITION) == 2) {
            if (hero.belongings.ring instanceof Ring) {
                hero.belongings.ring.identify();
            }
            if (hero.belongings.misc instanceof Ring) {
                hero.belongings.misc.identify();
            }
            for (Item item : Dungeon.hero.belongings) {
                if (!(item instanceof Ring)) continue;
                ((Ring)item).setKnown();
            }
        }
        if (talent == THIEFS_INTUITION && hero.pointsInTalent(THIEFS_INTUITION) == 1) {
            if (hero.belongings.ring instanceof Ring) {
                hero.belongings.ring.setKnown();
            }
            if (hero.belongings.misc instanceof Ring) {
                ((Ring)hero.belongings.misc).setKnown();
            }
        }
        if (talent == GUNNERS_INTUITION && hero.pointsInTalent(GUNNERS_INTUITION) == 2 && hero.belongings.weapon != null && hero.belongings.weapon.gun) {
            hero.belongings.weapon.identify();
        }
        if (talent == MASTERS_INTUITION && hero.pointsInTalent(MASTERS_INTUITION) == 1 && hero.belongings.weapon() != null) {
            hero.belongings.weapon().identify();
        }
        if (talent == KNIGHTS_INTUITION && hero.pointsInTalent(KNIGHTS_INTUITION) == 2 && hero.belongings.armor() != null) {
            hero.belongings.armor.identify();
        }
        if (talent == ADVENTURERS_INTUITION && hero.pointsInTalent(ADVENTURERS_INTUITION) == 2 && hero.belongings.weapon() != null) {
            hero.belongings.weapon().identify();
        }
        if (talent == PROTECTIVE_SHADOWS && hero.invisible > 0) {
            Buff.affect(hero, ProtectiveShadowsTracker.class);
        }
        if (talent == LIGHT_CLOAK && hero.heroClass == HeroClass.ROGUE) {
            for (Item item : Dungeon.hero.belongings.backpack) {
                if (!(item instanceof CloakOfShadows) || hero.buff(LostInventory.class) != null && !item.keptThoughLostInvent) continue;
                ((CloakOfShadows)item).activate(Dungeon.hero);
            }
        }
        if (talent == HEIGHTENED_SENSES || talent == FARSIGHT || talent == TELESCOPE || talent == JUNGLE_ADVENTURE) {
            Dungeon.observe();
        }
        if (talent == BETTER_CHOICE && hero.pointsInTalent(BETTER_CHOICE) == 1) {
            StoneOfEnchantment stone = new StoneOfEnchantment();
            if (stone.doPickUp(Dungeon.hero)) {
                GLog.i(Messages.get(Dungeon.hero, "you_now_have", stone.name()), new Object[0]);
                hero.spend(-1.0f);
            } else {
                Dungeon.level.drop((Item)stone, (int)Dungeon.hero.pos).sprite.drop();
            }
        }
        if (talent == BETTER_CHOICE && hero.pointsInTalent(BETTER_CHOICE) == 2) {
            ScrollOfEnchantment enchantment = new ScrollOfEnchantment();
            if (enchantment.doPickUp(Dungeon.hero)) {
                GLog.i(Messages.get(Dungeon.hero, "you_now_have", enchantment.name()), new Object[0]);
                hero.spend(-1.0f);
            } else {
                Dungeon.level.drop((Item)enchantment, (int)Dungeon.hero.pos).sprite.drop();
            }
        }
        if (talent == BETTER_CHOICE && hero.pointsInTalent(BETTER_CHOICE) == 3) {
            ScrollOfUpgrade scl = new ScrollOfUpgrade();
            if (scl.doPickUp(Dungeon.hero)) {
                GLog.i(Messages.get(Dungeon.hero, "you_now_have", scl.name()), new Object[0]);
                hero.spend(-1.0f);
            } else {
                Dungeon.level.drop((Item)scl, (int)Dungeon.hero.pos).sprite.drop();
            }
        }
        if (talent == COMP_RECOVER && hero.buff(HealingArea.class) != null) {
            hero.buff(HealingArea.class).attachTo(hero);
        }
        if (talent == DOCTORS_INTUITION && hero.pointsInTalent(DOCTORS_INTUITION) == 1) {
            for (int i = 0; i < 2 && (p = Reflection.newInstance(Random.element(potions = Potion.getUnknown()))) != null; ++i) {
                p.identify();
                potions.remove(p.getClass());
            }
        }
        if (talent == DOCTORS_INTUITION && hero.pointsInTalent(DOCTORS_INTUITION) == 2) {
            for (int i = 0; i < 3 && (p = Reflection.newInstance(Random.element(potions = Potion.getUnknown()))) != null; ++i) {
                p.identify();
                potions.remove(p.getClass());
            }
        }
        if (talent == SECONDARY_CHARGE || talent == TWIN_UPGRADES) {
            Item.updateQuickslot();
        }
        if (talent == UNENCUMBERED_SPIRIT && hero.pointsInTalent(talent) == 3) {
            Item toGive = new ClothArmor().identify();
            if (!toGive.collect()) {
                Dungeon.level.drop((Item)toGive, (int)hero.pos).sprite.drop();
            }
            if (!(toGive = new Gloves().identify()).collect()) {
                Dungeon.level.drop((Item)toGive, (int)hero.pos).sprite.drop();
            }
        }
    }

    public static void onFoodEaten(Hero hero, float foodVal, Item foodSource) {
        if (hero.hasTalent(HEARTY_MEAL)) {
            if (hero.HP <= hero.HT / 4) {
                hero.HP = Math.min(hero.HP + 1 + 2 * hero.pointsInTalent(HEARTY_MEAL), hero.HT);
                hero.sprite.emitter().burst(Speck.factory(0), 1 + hero.pointsInTalent(HEARTY_MEAL));
            } else if (hero.HP <= hero.HT / 2) {
                hero.HP = Math.min(hero.HP + 1 + hero.pointsInTalent(HEARTY_MEAL), hero.HT);
                hero.sprite.emitter().burst(Speck.factory(0), hero.pointsInTalent(HEARTY_MEAL));
            }
        }
        if (hero.hasTalent(IRON_STOMACH) && hero.cooldown() > 0.0f) {
            Buff.affect(hero, WarriorFoodImmunity.class, hero.cooldown());
        }
        if (hero.hasTalent(EMPOWERING_MEAL)) {
            Buff.affect(hero, WandEmpower.class).set(1 + hero.pointsInTalent(EMPOWERING_MEAL), 3);
            ScrollOfRecharging.charge(hero);
        }
        if (hero.hasTalent(ENERGIZING_MEAL)) {
            Buff.prolong(hero, Recharging.class, 2 + 3 * hero.pointsInTalent(ENERGIZING_MEAL));
            ScrollOfRecharging.charge(hero);
            SpellSprite.show(hero, 2);
        }
        if (hero.hasTalent(MYSTICAL_MEAL)) {
            ArtifactRecharge buff = Buff.affect(hero, ArtifactRecharge.class);
            if (buff.left() < (float)(1 + 2 * hero.pointsInTalent(MYSTICAL_MEAL))) {
                Buff.affect((Char)hero, ArtifactRecharge.class).set((float)((float)(1 + 2 * hero.pointsInTalent((Talent)Talent.MYSTICAL_MEAL)))).ignoreHornOfPlenty = foodSource instanceof HornOfPlenty;
            }
            ScrollOfRecharging.charge(hero);
            SpellSprite.show(hero, 2, 0.0f, 1.0f, 1.0f);
        }
        if (hero.hasTalent(INVIGORATING_MEAL)) {
            Buff.prolong(hero, Haste.class, 0.67f + (float)hero.pointsInTalent(INVIGORATING_MEAL));
        }
        if (hero.hasTalent(REARRANGE)) {
            Buff.prolong(hero, ExtraBullet.class, 5.0f * (float)hero.pointsInTalent(REARRANGE));
        }
        if (hero.hasTalent(IN_THE_GUNFIRE)) {
            Buff.prolong(hero, InfiniteBullet.class, 0.001f + (float)hero.pointsInTalent(IN_THE_GUNFIRE));
        }
        if (hero.hasTalent(FOCUSING_MEAL)) {
            Buff.prolong(hero, Adrenaline.class, 1.0f + 2.0f * (float)hero.pointsInTalent(FOCUSING_MEAL));
        }
        if (hero.hasTalent(NATURAL_MEAL)) {
            int c;
            if (hero.pointsInTalent(NATURAL_MEAL) == 1) {
                for (int i : PathFinder.NEIGHBOURS4) {
                    c = Dungeon.level.map[hero.pos + i];
                    if (c != 1 && c != 20 && c != 9 && c != 2) continue;
                    Level.set(hero.pos + i, 15);
                    GameScene.updateMap(hero.pos + i);
                    CellEmitter.get(hero.pos + i).burst(LeafParticle.LEVEL_SPECIFIC, 4);
                }
            } else {
                for (int i : PathFinder.NEIGHBOURS8) {
                    c = Dungeon.level.map[hero.pos + i];
                    if (c != 1 && c != 20 && c != 9 && c != 2) continue;
                    Level.set(hero.pos + i, 15);
                    GameScene.updateMap(hero.pos + i);
                    CellEmitter.get(hero.pos + i).burst(LeafParticle.LEVEL_SPECIFIC, 4);
                }
            }
        }
        if (hero.hasTalent(IMPREGNABLE_MEAL)) {
            Buff.affect(hero, ArmorEmpower.class).set(hero.pointsInTalent(IMPREGNABLE_MEAL), 10.0f);
        }
        if (hero.hasTalent(HEALING_MEAL)) {
            Buff.affect(hero, HealingArea.class).setup(hero.pos, 10 * hero.pointsInTalent(HEALING_MEAL), 1, true);
        }
        if (hero.hasTalent(DISINFECTING_MEAL)) {
            Object object = hero.buffs().iterator();
            while (object.hasNext()) {
                Buff b = (Buff)object.next();
                if (b.type != Buff.buffType.NEGATIVE || b instanceof AllyBuff || b instanceof LostInventory) continue;
                b.detach();
            }
            if (hero.pointsInTalent(DISINFECTING_MEAL) > 1) {
                Buff.affect(hero, PotionOfCleansing.Cleanse.class, 3.0f);
            }
        }
        if (hero.hasTalent(STRENGTHENING_MEAL)) {
            Buff.affect(hero, PhysicalEmpower.class).set(3, 1 + hero.pointsInTalent(STRENGTHENING_MEAL));
        }
        if (hero.hasTalent(FOCUSED_MEAL)) {
            if (hero.heroClass == HeroClass.DUELIST) {
                Buff.affect(hero, MeleeWeapon.Charger.class).gainCharge(0.5f * (float)(hero.pointsInTalent(FOCUSED_MEAL) + 1));
            } else {
                Buff.affect(hero, PhysicalEmpower.class).set(Math.round((float)hero.lvl / (4.0f - (float)hero.pointsInTalent(FOCUSED_MEAL))), 1);
            }
        }
    }

    public static float itemIDSpeedFactor(Hero hero, Item item) {
        float factor = 1.0f + 0.75f * (float)hero.pointsInTalent(SURVIVALISTS_INTUITION);
        if (item instanceof MeleeWeapon) {
            factor *= 1.0f + 1.5f * (float)hero.pointsInTalent(ADVENTURERS_INTUITION);
            factor *= 1.0f + 0.75f * (float)hero.pointsInTalent(VETERANS_INTUITION);
        }
        if (item instanceof Armor) {
            factor *= 1.0f + 0.75f * (float)hero.pointsInTalent(ADVENTURERS_INTUITION);
            factor *= 1.0f + (float)hero.pointsInTalent(VETERANS_INTUITION);
        }
        if (item instanceof Wand) {
            factor *= 1.0f + 2.0f * (float)hero.pointsInTalent(SCHOLARS_INTUITION);
        }
        if (item instanceof Ring) {
            factor *= 1.0f + (float)hero.pointsInTalent(THIEFS_INTUITION);
        }
        return factor;
    }

    public static void onHealingPotionUsed(Hero hero) {
        if (hero.hasTalent(RESTORED_WILLPOWER)) {
            if (hero.heroClass == HeroClass.WARRIOR) {
                BrokenSeal.WarriorShield shield = hero.buff(BrokenSeal.WarriorShield.class);
                if (shield != null) {
                    int shieldToGive = Math.round((float)shield.maxShield() * 0.33f * (float)(1 + hero.pointsInTalent(RESTORED_WILLPOWER)));
                    shield.supercharge(shieldToGive);
                }
            } else {
                int shieldToGive = Math.round((float)hero.HT * (0.025f * (float)(1 + hero.pointsInTalent(RESTORED_WILLPOWER))));
                Buff.affect(hero, Barrier.class).setShield(shieldToGive);
            }
        }
        if (hero.hasTalent(RESTORED_NATURE)) {
            int cell;
            ArrayList<Integer> grassCells = new ArrayList<Integer>();
            for (int i : PathFinder.NEIGHBOURS8) {
                grassCells.add(hero.pos + i);
            }
            Random.shuffle(grassCells);
            Object object = grassCells.iterator();
            while (object.hasNext()) {
                cell = (Integer)object.next();
                Char ch = Actor.findChar(cell);
                if (ch != null && ch.alignment == Char.Alignment.ENEMY) {
                    Buff.affect(ch, Roots.class, 1.0f + (float)hero.pointsInTalent(RESTORED_NATURE));
                }
                if (Dungeon.level.map[cell] == 1 || Dungeon.level.map[cell] == 9 || Dungeon.level.map[cell] == 20) {
                    Level.set(cell, 2);
                    GameScene.updateMap(cell);
                }
                CellEmitter.get(cell).burst(LeafParticle.LEVEL_SPECIFIC, 4);
            }
            if (hero.pointsInTalent(RESTORED_NATURE) == 1) {
                grassCells.remove(0);
                grassCells.remove(0);
                grassCells.remove(0);
            }
            object = grassCells.iterator();
            while (object.hasNext()) {
                cell = (Integer)object.next();
                int t = Dungeon.level.map[cell];
                if (t != 1 && t != 20 && t != 9 && t != 2 && t != 30 || Dungeon.level.plants.get(cell) != null) continue;
                Level.set(cell, 15);
                GameScene.updateMap(cell);
            }
            Dungeon.observe();
        }
        if (hero.hasTalent(SAFE_HEALING)) {
            Buff.affect(hero, Barrier.class).setShield(10 * hero.pointsInTalent(SAFE_HEALING));
        }
        if (hero.hasTalent(POTION_SPREAD) && !Dungeon.isChallenged(4)) {
            Buff.affect(hero, HealingArea.class).setup(hero.pos, Math.round((0.8f * (float)hero.HT + 14.0f) / 3.0f * (float)(1 + hero.pointsInTalent(POTION_SPREAD))), 2, true);
            if (hero.hasTalent(RESTORED_AGILITY)) {
                Buff.prolong(hero, RestoredAgilityTracker.class, hero.cooldown());
            }
        }
    }

    public static void onUpgradeScrollUsed(Hero hero) {
        if (hero.pointsInTalent(ANOTHER_CHANCE) == 2) {
            ++upgradeUsed;
        }
        if (hero.hasTalent(ENERGIZING_UPGRADE)) {
            if (hero.heroClass == HeroClass.MAGE) {
                MagesStaff staff = hero.belongings.getItem(MagesStaff.class);
                if (staff != null) {
                    staff.gainCharge(2 + 2 * hero.pointsInTalent(ENERGIZING_UPGRADE), true);
                    ScrollOfRecharging.charge(Dungeon.hero);
                    SpellSprite.show(hero, 2);
                }
            } else {
                Buff.affect(hero, Recharging.class, 4 + 8 * hero.pointsInTalent(ENERGIZING_UPGRADE));
            }
        }
        if (hero.hasTalent(MYSTICAL_UPGRADE)) {
            if (hero.heroClass == HeroClass.ROGUE) {
                CloakOfShadows cloak = hero.belongings.getItem(CloakOfShadows.class);
                if (cloak != null) {
                    cloak.overCharge(1 + hero.pointsInTalent(MYSTICAL_UPGRADE));
                    ScrollOfRecharging.charge(Dungeon.hero);
                    SpellSprite.show(hero, 2, 0.0f, 1.0f, 1.0f);
                }
            } else {
                Buff.affect((Char)hero, ArtifactRecharge.class).set((float)((float)(2 + 4 * hero.pointsInTalent((Talent)Talent.MYSTICAL_UPGRADE)))).ignoreHornOfPlenty = false;
                ScrollOfRecharging.charge(Dungeon.hero);
                SpellSprite.show(hero, 2, 0.0f, 1.0f, 1.0f);
            }
        }
        if (hero.hasTalent(ANOTHER_CHANCE)) {
            ScrollOfUpgrade scl = new ScrollOfUpgrade();
            StoneOfEnchantment enchantment = new StoneOfEnchantment();
            if (hero.pointsInTalent(ANOTHER_CHANCE) >= 1 && Random.Int(5) == 0) {
                if (enchantment.doPickUp(Dungeon.hero)) {
                    GLog.i(Messages.get(Dungeon.hero, "you_now_have", enchantment.name()), new Object[0]);
                } else {
                    Dungeon.level.drop((Item)enchantment, (int)Dungeon.hero.pos).sprite.drop();
                }
            }
            if (hero.pointsInTalent(ANOTHER_CHANCE) == 2 && (Random.Int(10) == 0 || upgradeUsed == 10)) {
                if (scl.doPickUp(Dungeon.hero)) {
                    GLog.i(Messages.get(Dungeon.hero, "you_now_have", scl.name()), new Object[0]);
                } else {
                    Dungeon.level.drop((Item)scl, (int)Dungeon.hero.pos).sprite.drop();
                }
                upgradeUsed = 0;
            }
        }
        if (hero.hasTalent(CRITICAL_UPGRADE)) {
            if (hero.heroClass == HeroClass.SAMURAI) {
                Buff.prolong(hero, CertainCrit.class, 5 * hero.pointsInTalent(CRITICAL_UPGRADE));
            } else {
                Buff.affect(hero, CriticalUpgradeTracker.class);
            }
        }
    }

    public static void onArtifactUsed(Hero hero) {
        if (hero.hasTalent(ENHANCED_RINGS)) {
            Buff.prolong(hero, EnhancedRings.class, 3.0f * (float)hero.pointsInTalent(ENHANCED_RINGS));
        }
    }

    public static void onItemEquipped(Hero hero, Item item) {
        if (hero.pointsInTalent(VETERANS_INTUITION) == 2 && item instanceof Armor) {
            item.identify();
        }
        if (hero.hasTalent(THIEFS_INTUITION) && item instanceof Ring) {
            if (hero.pointsInTalent(THIEFS_INTUITION) == 2) {
                item.identify();
            } else {
                ((Ring)item).setKnown();
            }
        }
        if (hero.hasTalent(GUNNERS_INTUITION) && item instanceof Weapon && ((Weapon)item).gun) {
            item.identify();
        }
        if (hero.hasTalent(MASTERS_INTUITION) && item instanceof Weapon) {
            item.identify();
        }
        if (hero.hasTalent(KNIGHTS_INTUITION) && item instanceof Armor) {
            item.identify();
        }
        if (hero.pointsInTalent(ADVENTURERS_INTUITION) == 2 && item instanceof Weapon) {
            item.identify();
        }
    }

    public static void onItemCollected(Hero hero, Item item) {
        if (hero.pointsInTalent(GUNNERS_INTUITION) == 2 && item instanceof Weapon && ((Weapon)item).gun) {
            item.identify();
        }
        if (hero.pointsInTalent(THIEFS_INTUITION) == 2 && item instanceof Ring) {
            ((Ring)item).setKnown();
        }
        if (hero.pointsInTalent(MASTERS_INTUITION) == 2 && item instanceof Weapon) {
            item.identify();
        }
        if (hero.pointsInTalent(KNIGHTS_INTUITION) == 2 && item instanceof Armor) {
            item.identify();
        }
    }

    public static void onItemIdentified(Hero hero, Item item) {
        if (hero.hasTalent(TEST_SUBJECT)) {
            Emitter e;
            hero.HP = Math.min(hero.HP + 1 + hero.pointsInTalent(TEST_SUBJECT), hero.HT);
            if (hero.sprite != null && (e = hero.sprite.emitter()) != null) {
                e.burst(Speck.factory(0), hero.pointsInTalent(TEST_SUBJECT));
            }
        }
        if (hero.hasTalent(TESTED_HYPOTHESIS)) {
            Buff.affect(hero, Recharging.class, 1.0f + (float)hero.pointsInTalent(TESTED_HYPOTHESIS));
            ScrollOfRecharging.charge(hero);
        }
    }

    public static int onAttackProc(Hero hero, Char enemy, int dmg) {
        if (hero.hasTalent(SUCKER_PUNCH) && enemy instanceof Mob && ((Mob)enemy).surprisedBy(hero) && enemy.buff(SuckerPunchTracker.class) == null) {
            dmg += Random.IntRange(hero.pointsInTalent(SUCKER_PUNCH), 2);
            Buff.affect(enemy, SuckerPunchTracker.class);
        }
        if (hero.hasTalent(POISONOUS_BLADE) && enemy instanceof Mob && ((Mob)enemy).surprisedBy(hero)) {
            Buff.affect(enemy, Poison.class).set(2 + hero.pointsInTalent(POISONOUS_BLADE));
        }
        if (hero.hasTalent(FOLLOWUP_STRIKE) && enemy.alignment == Char.Alignment.ENEMY) {
            if (hero.belongings.attackingWeapon() instanceof MissileWeapon) {
                Buff.prolong((Char)hero, FollowupStrikeTracker.class, (float)5.0f).object = enemy.id();
            } else if (hero.buff(FollowupStrikeTracker.class) != null && hero.buff(FollowupStrikeTracker.class).object == enemy.id()) {
                dmg += 1 + hero.pointsInTalent(FOLLOWUP_STRIKE);
                if (!(enemy instanceof Mob) || !((Mob)enemy).surprisedBy(hero)) {
                    Sample.INSTANCE.play("sounds/hit_strong.mp3", 0.75f, 1.2f);
                }
                if (hero.belongings.weapon == null && hero.subClass == HeroSubClass.FIGHTER) {
                    Buff.affect(enemy, Paralysis.class, 1.0f);
                }
                hero.buff(FollowupStrikeTracker.class).detach();
            }
        }
        if (hero.hasTalent(UNEXPECTED_SLASH) && hero.buff(Sheathing.class) != null) {
            dmg += hero.pointsInTalent(UNEXPECTED_SLASH);
        }
        if (hero.hasTalent(UNEXPECTED_SLASH) && hero.heroClass != HeroClass.SAMURAI) {
            dmg += hero.pointsInTalent(UNEXPECTED_SLASH);
        }
        if (hero.hasTalent(SPEEDY_MOVE) && enemy instanceof Mob && enemy.buff(ShootTheHeartTracker.class) == null) {
            Buff.affect(enemy, ShootTheHeartTracker.class);
            Buff.prolong(hero, Haste.class, 1.0f + (float)hero.pointsInTalent(SPEEDY_MOVE));
        }
        if (hero.hasTalent(WAR_CRY) && enemy instanceof Mob && enemy.buff(WarCryTracker.class) == null) {
            Buff.affect(enemy, WarCryTracker.class);
            Buff.prolong(hero, Adrenaline.class, 1 + hero.pointsInTalent(WAR_CRY));
        }
        if (hero.buff(SpiritBladesTracker.class) != null && Random.Int(10) < 3 * hero.pointsInTalent(SPIRIT_BLADES)) {
            SpiritBow bow = hero.belongings.getItem(SpiritBow.class);
            if (bow != null) {
                dmg = bow.proc(hero, enemy, dmg);
            }
            hero.buff(SpiritBladesTracker.class).detach();
        }
        if (hero.hasTalent(PATIENT_STRIKE) && hero.buff(PatientStrikeTracker.class) != null && !(hero.belongings.attackingWeapon() instanceof MissileWeapon)) {
            hero.buff(PatientStrikeTracker.class).detach();
            dmg += Random.IntRange(hero.pointsInTalent(PATIENT_STRIKE), 2);
        }
        if (hero.hasTalent(DEADLY_FOLLOWUP) && enemy.alignment == Char.Alignment.ENEMY) {
            if (hero.belongings.attackingWeapon() instanceof MissileWeapon) {
                if (!(hero.belongings.attackingWeapon() instanceof SpiritBow.SpiritArrow)) {
                    Buff.prolong((Char)hero, DeadlyFollowupTracker.class, (float)5.0f).object = enemy.id();
                }
            } else if (hero.buff(DeadlyFollowupTracker.class) != null && hero.buff(DeadlyFollowupTracker.class).object == enemy.id()) {
                dmg = Math.round((float)dmg * (1.0f + 0.08f * (float)hero.pointsInTalent(DEADLY_FOLLOWUP)));
            }
        }
        return dmg;
    }

    public static void initClassTalents(Hero hero) {
        Talent.initClassTalents(hero.heroClass, hero.talents, hero.metamorphedTalents);
    }

    public static void initClassTalents(HeroClass cls, ArrayList<LinkedHashMap<Talent, Integer>> talents) {
        Talent.initClassTalents(cls, talents, new LinkedHashMap<Talent, Talent>());
    }

    public static void initClassTalents(HeroClass cls, ArrayList<LinkedHashMap<Talent, Integer>> talents, LinkedHashMap<Talent, Talent> replacements) {
        while (talents.size() < 4) {
            talents.add(new LinkedHashMap());
        }
        ArrayList tierTalents = new ArrayList();
        switch (cls) {
            default: {
                Collections.addAll(tierTalents, HEARTY_MEAL, VETERANS_INTUITION, TEST_SUBJECT, IRON_WILL, MAX_HEALTH);
                break;
            }
            case MAGE: {
                Collections.addAll(tierTalents, EMPOWERING_MEAL, SCHOLARS_INTUITION, TESTED_HYPOTHESIS, BACKUP_BARRIER, CHARGE_PRESERVE);
                break;
            }
            case ROGUE: {
                Collections.addAll(tierTalents, CACHED_RATIONS, THIEFS_INTUITION, SUCKER_PUNCH, PROTECTIVE_SHADOWS, EMERGENCY_ESCAPE);
                break;
            }
            case HUNTRESS: {
                Collections.addAll(tierTalents, NATURES_BOUNTY, SURVIVALISTS_INTUITION, FOLLOWUP_STRIKE, NATURES_AID, WATER_FRIENDLY);
                break;
            }
            case GUNNER: {
                Collections.addAll(tierTalents, REARRANGE, GUNNERS_INTUITION, SPEEDY_MOVE, SAFE_RELOAD, MIND_VISION);
                break;
            }
            case SAMURAI: {
                Collections.addAll(tierTalents, SURPRISE_STAB, MASTERS_INTUITION, UNEXPECTED_SLASH, FLOW_AWAY, ADRENALINE_SURGE);
                break;
            }
            case PLANTER: {
                Collections.addAll(tierTalents, SUDDEN_GROWTH, SAFE_POTION, ROOT, KNOWLEDGE_HERB, PLANT_SHIELD);
                break;
            }
            case KNIGHT: {
                Collections.addAll(tierTalents, ON_ALERT, KNIGHTS_INTUITION, ARMOR_ENHANCE, ACTIVE_BARRIER, WAR_CRY);
                break;
            }
            case NURSE: {
                Collections.addAll(tierTalents, HEALING_MEAL, DOCTORS_INTUITION, PROTECTIVE_HEAL, CRITICAL_SHIELD, PROTECTIVE_CLOTHING);
                break;
            }
            case DUELIST: {
                Collections.addAll(tierTalents, STRENGTHENING_MEAL, ADVENTURERS_INTUITION, PATIENT_STRIKE, AGGRESSIVE_BARRIER, SKILLED_HAND);
            }
        }
        for (Talent talent : tierTalents) {
            if (replacements.containsKey((Object)talent)) {
                talent = replacements.get((Object)talent);
            }
            talents.get(0).put(talent, 0);
        }
        tierTalents.clear();
        switch (cls) {
            default: {
                Collections.addAll(tierTalents, IRON_STOMACH, RESTORED_WILLPOWER, RUNIC_TRANSFERENCE, LETHAL_MOMENTUM, IMPROVISED_PROJECTILES, PARRY);
                break;
            }
            case MAGE: {
                Collections.addAll(tierTalents, ENERGIZING_MEAL, ENERGIZING_UPGRADE, WAND_PRESERVATION, ARCANE_VISION, SHIELD_BATTERY, FASTER_CHARGER);
                break;
            }
            case ROGUE: {
                Collections.addAll(tierTalents, MYSTICAL_MEAL, MYSTICAL_UPGRADE, WIDE_SEARCH, SILENT_STEPS, ROGUES_FORESIGHT, MOVESPEED_ENHANCE);
                break;
            }
            case HUNTRESS: {
                Collections.addAll(tierTalents, INVIGORATING_MEAL, RESTORED_NATURE, REJUVENATING_STEPS, HEIGHTENED_SENSES, DURABLE_PROJECTILES, ADDED_MEAL);
                break;
            }
            case DUELIST: {
                Collections.addAll(tierTalents, FOCUSED_MEAL, RESTORED_AGILITY, WEAPON_RECHARGING, LETHAL_HASTE, SWIFT_EQUIP, ACCUMULATION);
                break;
            }
            case GUNNER: {
                Collections.addAll(tierTalents, IN_THE_GUNFIRE, ANOTHER_CHANCE, RELOAD_PRACTICE, CAMOUFLAGE, LARGER_MAGAZINE, TRANSMUTATION_CONTROL);
                break;
            }
            case SAMURAI: {
                Collections.addAll(tierTalents, FOCUSING_MEAL, CRITICAL_UPGRADE, MAGICAL_TRANSFERENCE, EYE_OF_DRAGON, DETECTION, CRITICAL_THROW);
                break;
            }
            case PLANTER: {
                Collections.addAll(tierTalents, NATURAL_MEAL, HERBAL_DEW, SPROUT, FIREWATCH, FLOWER_BED, WEAK_POISON);
                break;
            }
            case KNIGHT: {
                Collections.addAll(tierTalents, IMPREGNABLE_MEAL, SAFE_HEALING, DEFENSE_STANCE, FAITH, CHIVALRY, ARMOR_ADAPTION);
                break;
            }
            case NURSE: {
                Collections.addAll(tierTalents, DISINFECTING_MEAL, POTION_SPREAD, HEALAREA, POISON_INJECT, CHEAT_THE_DEATH, WINNERS_FLAG);
            }
        }
        for (Talent talent : tierTalents) {
            if (replacements.containsKey((Object)talent)) {
                talent = replacements.get((Object)talent);
            }
            talents.get(1).put(talent, 0);
        }
        tierTalents.clear();
        switch (cls) {
            default: {
                Collections.addAll(tierTalents, HOLD_FAST, STRONGMAN);
                break;
            }
            case MAGE: {
                Collections.addAll(tierTalents, EMPOWERING_SCROLLS, ALLY_WARP);
                break;
            }
            case ROGUE: {
                Collections.addAll(tierTalents, ENHANCED_RINGS, LIGHT_CLOAK);
                break;
            }
            case HUNTRESS: {
                Collections.addAll(tierTalents, POINT_BLANK, SEER_SHOT);
                break;
            }
            case DUELIST: {
                Collections.addAll(tierTalents, PRECISE_ASSAULT, DEADLY_FOLLOWUP);
                break;
            }
            case GUNNER: {
                Collections.addAll(tierTalents, STREET_BATTLE, FAST_RELOAD);
                break;
            }
            case SAMURAI: {
                Collections.addAll(tierTalents, DEEP_SCAR, FAST_LEAD);
                break;
            }
            case PLANTER: {
                Collections.addAll(tierTalents, BLOOMING_WEAPON, FARMER);
                break;
            }
            case KNIGHT: {
                Collections.addAll(tierTalents, CRAFTMANS_SKILLS, TACKLE);
                break;
            }
            case NURSE: {
                Collections.addAll(tierTalents, POWERFUL_BOND, CHARISMA);
            }
        }
        for (Talent talent : tierTalents) {
            if (replacements.containsKey((Object)talent)) {
                talent = replacements.get((Object)talent);
            }
            talents.get(2).put(talent, 0);
        }
        tierTalents.clear();
    }

    public static void initSubclassTalents(Hero hero) {
        Talent.initSubclassTalents(hero.subClass, hero.talents);
    }

    public static void initSubclassTalents(HeroSubClass cls, ArrayList<LinkedHashMap<Talent, Integer>> talents) {
        ArrayList tierTalents = new ArrayList();
        if (cls == HeroSubClass.NONE) {
            return;
        }
        while (talents.size() < 4) {
            talents.add(new LinkedHashMap());
        }
        switch (cls) {
            default: {
                Collections.addAll(tierTalents, ATK_SPEED_ENHANCE, ACC_ENHANCE, EVA_ENHANCE, BETTER_CHOICE, ENDLESS_RAGE, DEATHLESS_FURY, ENRAGED_CATALYST, LETHAL_RAGE, MAX_RAGE, ENDURANCE);
                break;
            }
            case GLADIATOR: {
                Collections.addAll(tierTalents, ATK_SPEED_ENHANCE, ACC_ENHANCE, EVA_ENHANCE, BETTER_CHOICE, CLEAVE, LETHAL_DEFENSE, ENHANCED_COMBO, QUICK_SWAP, OFFENSIVE_DEFENSE, SKILL_ENHANCE);
                break;
            }
            case VETERAN: {
                Collections.addAll(tierTalents, ATK_SPEED_ENHANCE, ACC_ENHANCE, EVA_ENHANCE, BETTER_CHOICE, POWERFUL_TACKLE, MYSTICAL_TACKLE, DELAYED_GRENADE, INCAPACITATION, SUPER_ARMOR, IMPROVED_TACKLE);
                break;
            }
            case BATTLEMAGE: {
                Collections.addAll(tierTalents, ATK_SPEED_ENHANCE, ACC_ENHANCE, EVA_ENHANCE, BETTER_CHOICE, EMPOWERED_STRIKE, MYSTICAL_CHARGE, EXCESS_CHARGE, BATTLE_MAGIC, MAGIC_RUSH, MAGICAL_CIRCLE);
                break;
            }
            case WARLOCK: {
                Collections.addAll(tierTalents, ATK_SPEED_ENHANCE, ACC_ENHANCE, EVA_ENHANCE, BETTER_CHOICE, SOUL_EATER, SOUL_SIPHON, NECROMANCERS_MINIONS, MADNESS, ENHANCED_MARK, MARK_OF_WEAKNESS);
                break;
            }
            case WIZARD: {
                Collections.addAll(tierTalents, ATK_SPEED_ENHANCE, ACC_ENHANCE, EVA_ENHANCE, BETTER_CHOICE, SPELL_ENHANCE, BRIG_BOOST, ENERGY_REMAINS, SOUL_OF_BATTLEMAGE, SOUL_OF_WARLOCK, LIFE_ENERGY);
                break;
            }
            case ASSASSIN: {
                Collections.addAll(tierTalents, ATK_SPEED_ENHANCE, ACC_ENHANCE, EVA_ENHANCE, BETTER_CHOICE, ENHANCED_LETHALITY, ASSASSINS_REACH, BOUNTY_HUNTER, ENERGY_DRAW, PERFECT_ASSASSIN, CAUTIOUS_PREP);
                break;
            }
            case FREERUNNER: {
                Collections.addAll(tierTalents, ATK_SPEED_ENHANCE, ACC_ENHANCE, EVA_ENHANCE, BETTER_CHOICE, EVASIVE_ARMOR, PROJECTILE_MOMENTUM, SPEEDY_STEALTH, QUICK_PREP, OVERCOMING, MOMENTARY_FOCUSING);
                break;
            }
            case CHASER: {
                Collections.addAll(tierTalents, ATK_SPEED_ENHANCE, ACC_ENHANCE, EVA_ENHANCE, BETTER_CHOICE, POISONOUS_BLADE, LETHAL_SURPRISE, CHAIN_CLOCK, SOUL_COLLECT, TRAIL_TRACKING, MASTER_OF_CLOAKING);
                break;
            }
            case SNIPER: {
                Collections.addAll(tierTalents, ATK_SPEED_ENHANCE, ACC_ENHANCE, EVA_ENHANCE, BETTER_CHOICE, FARSIGHT, SHARED_ENCHANTMENT, SHARED_UPGRADES, KICK, SHOOTING_EYES, TARGET_SPOTTING);
                break;
            }
            case WARDEN: {
                Collections.addAll(tierTalents, ATK_SPEED_ENHANCE, ACC_ENHANCE, EVA_ENHANCE, BETTER_CHOICE, DURABLE_TIPS, BARKSKIN, SHIELDING_DEW, DENSE_GRASS, ATTRACTION, WITHDRAW_TRAP);
                break;
            }
            case FIGHTER: {
                Collections.addAll(tierTalents, ATK_SPEED_ENHANCE, ACC_ENHANCE, EVA_ENHANCE, BETTER_CHOICE, SWIFT_MOVEMENT, LESS_RESIST, RING_KNUCKLE, MYSTICAL_PUNCH, QUICK_STEP, COUNTER_ATTACK);
                break;
            }
            case CHAMPION: {
                Collections.addAll(tierTalents, ATK_SPEED_ENHANCE, ACC_ENHANCE, EVA_ENHANCE, BETTER_CHOICE, SECONDARY_CHARGE, TWIN_UPGRADES, COMBINED_LETHALITY, FASTER_CHARGE, QUICK_FOLLOWUP, MOMENTARY_UPGRADE);
                break;
            }
            case MONK: {
                Collections.addAll(tierTalents, ATK_SPEED_ENHANCE, ACC_ENHANCE, EVA_ENHANCE, BETTER_CHOICE, UNENCUMBERED_SPIRIT, MONASTIC_VIGOR, COMBINED_ENERGY, RESTORED_ENERGY, ENERGY_BARRIER, IRON_PUNCH);
                break;
            }
            case FENCER: {
                Collections.addAll(tierTalents, ATK_SPEED_ENHANCE, ACC_ENHANCE, EVA_ENHANCE, BETTER_CHOICE, CLAM_STEPS, CRITICAL_MOMENTUM, KINETIC_MOVEMENT, AGGRESSIVE_MOVEMENT, UNENCUMBERED_MOVEMENT, SOULIZE);
                break;
            }
            case MARSHAL: {
                Collections.addAll(tierTalents, ATK_SPEED_ENHANCE, ACC_ENHANCE, EVA_ENHANCE, BETTER_CHOICE, JUSTICE_BULLET, INTIMIDATION, SEARCH, COVER, SURRENDER, INVEST_END);
                break;
            }
            case GUNSLINGER: {
                Collections.addAll(tierTalents, ATK_SPEED_ENHANCE, ACC_ENHANCE, EVA_ENHANCE, BETTER_CHOICE, QUICK_RELOAD, MOVING_SHOT, ELEMENTAL_BULLET, MYSTICAL_THROW, SOUL_BULLET, LIGHT_MOVEMENT);
                break;
            }
            case SPECIALIST: {
                Collections.addAll(tierTalents, ATK_SPEED_ENHANCE, ACC_ENHANCE, EVA_ENHANCE, BETTER_CHOICE, SILENCER, SKILLFUL_RUNNER, STEALTH, INTO_THE_SHADOW, RANGED_SNIPING, TELESCOPE);
                break;
            }
            case SLASHER: {
                Collections.addAll(tierTalents, ATK_SPEED_ENHANCE, ACC_ENHANCE, EVA_ENHANCE, BETTER_CHOICE, CONTINUOUS_ATTACK, SLASHING_PRACTICE, SERIAL_MOMENTUM, ARCANE_ATTACK, SLASHING, DETECTIVE_SLASHING);
                break;
            }
            case MASTER: {
                Collections.addAll(tierTalents, ATK_SPEED_ENHANCE, ACC_ENHANCE, EVA_ENHANCE, BETTER_CHOICE, DONG_MIND_EYES, DONG_SHEATHING, DONG_POLISHING, JUNG_DETECTION, JUNG_QUICK_DRAW, JUNG_INCISIVE_BLADE);
                break;
            }
            case SLAYER: {
                Collections.addAll(tierTalents, ATK_SPEED_ENHANCE, ACC_ENHANCE, EVA_ENHANCE, BETTER_CHOICE, AFTERIMAGE, ENERGY_DRAIN, FTL, QUICK_RECOVER, HASTE_RECOVER, FLURRY);
                break;
            }
            case TREASUREHUNTER: {
                Collections.addAll(tierTalents, ATK_SPEED_ENHANCE, ACC_ENHANCE, EVA_ENHANCE, BETTER_CHOICE, TAKEDOWN, DETECTOR, GOLD_SHIELD, GOLD_MINER, FINDING_TREASURE, HIDDEN_STASH);
                break;
            }
            case ADVENTURER: {
                Collections.addAll(tierTalents, ATK_SPEED_ENHANCE, ACC_ENHANCE, EVA_ENHANCE, BETTER_CHOICE, JUNGLE_ADVENTURE, SHADOW, VINE_WHIP, THORNY_VINE, SNARE, SHARP_INTUITION);
                break;
            }
            case RESEARCHER: {
                Collections.addAll(tierTalents, ATK_SPEED_ENHANCE, ACC_ENHANCE, EVA_ENHANCE, BETTER_CHOICE, ALIVE_GRASS, DEW_MAKING, BIO_ENERGY, ROOT_PLANT, BIOLOGY_PROJECT, CHEMICAL);
                break;
            }
            case WEAPONMASTER: {
                Collections.addAll(tierTalents, ATK_SPEED_ENHANCE, ACC_ENHANCE, EVA_ENHANCE, BETTER_CHOICE, CLASH, MYSTICAL_POWER, ABSOLUTE_ZERO, EARTHQUAKE, SPEAR_N_SHIELD, UPGRADE_SHARE);
                break;
            }
            case FORTRESS: {
                Collections.addAll(tierTalents, ATK_SPEED_ENHANCE, ACC_ENHANCE, EVA_ENHANCE, BETTER_CHOICE, IMPREGNABLE_WALL, COUNTER_MOMENTUM, SHIELD_SLAM, PREPARATION, FORTRESS, MYSTICAL_COUNTER);
                break;
            }
            case CRUSADER: {
                Collections.addAll(tierTalents, ATK_SPEED_ENHANCE, ACC_ENHANCE, EVA_ENHANCE, BETTER_CHOICE, DIVINE_SHIELD, DEADS_BLESS, ARMOR_BLESSING, BLESSED_TALENT, MYSTICAL_VEIL, SHIELD_OF_LIGHT);
                break;
            }
            case MEDIC: {
                Collections.addAll(tierTalents, ATK_SPEED_ENHANCE, ACC_ENHANCE, EVA_ENHANCE, BETTER_CHOICE, PROMOTION, HEALING_SHIELD, HEAL_ENHANCE, COMP_RECOVER, IMMUNE_SYSTEM, HIGHER_HEAL);
                break;
            }
            case ANGEL: {
                Collections.addAll(tierTalents, ATK_SPEED_ENHANCE, ACC_ENHANCE, EVA_ENHANCE, BETTER_CHOICE, APPEASE, ANGEL_AND_DEVIL, AREA_OF_LIGHT, BLESS_ENHANCE, PERSUASION, HOLY_PROTECTION);
                break;
            }
            case SURGEON: {
                Collections.addAll(tierTalents, ATK_SPEED_ENHANCE, ACC_ENHANCE, EVA_ENHANCE, BETTER_CHOICE, SCALPEL, DEFIBRILLATOR, DEATH_DIAGNOSIS, FIRST_AID, DISINFECTION, HASTY_HANDS);
            }
        }
        for (Talent talent : tierTalents) {
            talents.get(2).put(talent, 0);
        }
        tierTalents.clear();
    }

    public static void initArmorTalents(Hero hero) {
        Talent.initArmorTalents(hero.armorAbility, hero.talents);
    }

    public static void initArmorTalents(ArmorAbility abil, ArrayList<LinkedHashMap<Talent, Integer>> talents) {
        if (abil == null) {
            return;
        }
        while (talents.size() < 4) {
            talents.add(new LinkedHashMap());
        }
        for (Talent t : abil.talents()) {
            talents.get(3).put(t, 0);
        }
    }

    public static void storeTalentsInBundle(Bundle bundle, Hero hero) {
        for (int i = 0; i < 4; ++i) {
            LinkedHashMap<Talent, Integer> tier = hero.talents.get(i);
            Bundle tierBundle = new Bundle();
            for (Talent talent : tier.keySet()) {
                if (tier.get((Object)talent) > 0) {
                    tierBundle.put(talent.name(), tier.get((Object)talent));
                }
                if (!tierBundle.contains(talent.name())) continue;
                tier.put(talent, Math.min(tierBundle.getInt(talent.name()), talent.maxPoints()));
            }
            bundle.put(TALENT_TIER + (i + 1), tierBundle);
        }
        Bundle replacementsBundle = new Bundle();
        for (Talent t : hero.metamorphedTalents.keySet()) {
            replacementsBundle.put(t.name(), hero.metamorphedTalents.get((Object)t));
        }
        bundle.put("replacements", replacementsBundle);
    }

    public static void restoreTalentsFromBundle(Bundle bundle, Hero hero) {
        if (bundle.contains("replacements")) {
            Bundle replacements = bundle.getBundle("replacements");
            for (String key : replacements.getKeys()) {
                String value = replacements.getString(key);
                if (renamedTalents.containsKey(key)) {
                    key = renamedTalents.get(key);
                }
                if (renamedTalents.containsKey(value)) {
                    value = renamedTalents.get(value);
                }
                if (removedTalents.contains(key) || removedTalents.contains(value)) continue;
                try {
                    hero.metamorphedTalents.put(Talent.valueOf(key), Talent.valueOf(value));
                }
                catch (Exception e) {
                    ShatteredPixelDungeon.reportException(e);
                }
            }
        }
        if (hero.heroClass != null) {
            Talent.initClassTalents(hero);
        }
        if (hero.subClass != null) {
            Talent.initSubclassTalents(hero);
        }
        if (hero.armorAbility != null) {
            Talent.initArmorTalents(hero);
        }
        for (int i = 0; i < 4; ++i) {
            Bundle tierBundle;
            LinkedHashMap<Talent, Integer> tier = hero.talents.get(i);
            Bundle bundle2 = tierBundle = bundle.contains(TALENT_TIER + (i + 1)) ? bundle.getBundle(TALENT_TIER + (i + 1)) : null;
            if (tierBundle == null) continue;
            for (String tName : tierBundle.getKeys()) {
                int points = tierBundle.getInt(tName);
                if (renamedTalents.containsKey(tName)) {
                    tName = renamedTalents.get(tName);
                }
                if (removedTalents.contains(tName)) continue;
                try {
                    Talent talent = Talent.valueOf(tName);
                    if (!tier.containsKey((Object)talent)) continue;
                    tier.put(talent, Math.min(points, talent.maxPoints()));
                }
                catch (Exception e) {
                    ShatteredPixelDungeon.reportException(e);
                }
            }
        }
    }

    static {
        tierLevelThresholds = new int[]{0, 2, 7, 13, 21, 31};
        upgradeUsed = 0;
        removedTalents = new HashSet();
        removedTalents.add("BERSERKING_STAMINA");
        renamedTalents = new HashMap();
        renamedTalents.put("ARMSMASTERS_INTUITION", "VETERANS_INTUITION");
        renamedTalents.put("LIGHTLY_ARMED", "UNENCUMBERED_SPIRIT");
        renamedTalents.put("LIGHTWEIGHT_CHARGE", "PRECISE_ASSAULT");
    }

    public static class ParryTracker
    extends Buff {
        public ParryTracker() {
            this.actPriority = 1;
            this.type = Buff.buffType.NEUTRAL;
            this.announced = true;
        }

        @Override
        public int icon() {
            return 158;
        }

        @Override
        public boolean act() {
            if (!Dungeon.hero.hasTalent(PARRY)) {
                this.detach();
            }
            this.spend(1.0f);
            return true;
        }

        @Override
        public void detach() {
            super.detach();
            Buff.affect(this.target, ParryCooldown.class).set();
        }
    }

    public static class NatureBerriesAvailable
    extends CounterBuff {
        public NatureBerriesAvailable() {
            this.revivePersists = true;
        }
    }

    public static class ProtectiveShadowsTracker
    extends Buff {
        float barrierInc = 0.5f;
        private static final String BARRIER_INC = "barrier_inc";

        @Override
        public boolean act() {
            if (((Hero)this.target).hasTalent(PROTECTIVE_SHADOWS) && this.target.invisible > 0) {
                Barrier barrier = Buff.affect(this.target, Barrier.class);
                if (barrier.shielding() < 1 + 2 * ((Hero)this.target).pointsInTalent(PROTECTIVE_SHADOWS)) {
                    this.barrierInc += 0.5f * (float)((Hero)this.target).pointsInTalent(PROTECTIVE_SHADOWS);
                }
                if (this.barrierInc >= 1.0f) {
                    this.barrierInc = 0.0f;
                    barrier.incShield(1);
                } else {
                    barrier.incShield(0);
                }
            } else {
                this.detach();
            }
            this.spend(1.0f);
            return true;
        }

        @Override
        public void storeInBundle(Bundle bundle) {
            super.storeInBundle(bundle);
            bundle.put(BARRIER_INC, this.barrierInc);
        }

        @Override
        public void restoreFromBundle(Bundle bundle) {
            super.restoreFromBundle(bundle);
            this.barrierInc = bundle.getFloat(BARRIER_INC);
        }
    }

    public static class WarriorFoodImmunity
    extends FlavourBuff {
        public WarriorFoodImmunity() {
            this.actPriority = 1;
        }
    }

    public static class RestoredAgilityTracker
    extends FlavourBuff {
    }

    public static class CriticalUpgradeTracker
    extends Buff {
    }

    public static class SuckerPunchTracker
    extends Buff {
    }

    public static class FollowupStrikeTracker
    extends FlavourBuff {
        public int object;
        private static final String OBJECT = "object";

        public FollowupStrikeTracker() {
            this.type = Buff.buffType.POSITIVE;
        }

        @Override
        public int icon() {
            return 57;
        }

        @Override
        public void tintIcon(Image icon) {
            icon.hardlight(0.0f, 0.75f, 1.0f);
        }

        @Override
        public float iconFadePercent() {
            return Math.max(0.0f, 1.0f - this.visualcooldown() / 5.0f);
        }

        @Override
        public void storeInBundle(Bundle bundle) {
            super.storeInBundle(bundle);
            bundle.put(OBJECT, this.object);
        }

        @Override
        public void restoreFromBundle(Bundle bundle) {
            super.restoreFromBundle(bundle);
            this.object = bundle.getInt(OBJECT);
        }
    }

    public static class ShootTheHeartTracker
    extends Buff {
    }

    public static class WarCryTracker
    extends Buff {
    }

    public static class SpiritBladesTracker
    extends FlavourBuff {
    }

    public static class PatientStrikeTracker
    extends Buff {
        public int pos;
        private static final String POS = "pos";

        public PatientStrikeTracker() {
            this.type = Buff.buffType.POSITIVE;
        }

        @Override
        public int icon() {
            return 7;
        }

        @Override
        public void tintIcon(Image icon) {
            icon.hardlight(0.5f, 0.0f, 1.0f);
        }

        @Override
        public boolean act() {
            if (this.pos != this.target.pos) {
                this.detach();
            } else {
                this.spend(1.0f);
            }
            return true;
        }

        @Override
        public void storeInBundle(Bundle bundle) {
            super.storeInBundle(bundle);
            bundle.put(POS, this.pos);
        }

        @Override
        public void restoreFromBundle(Bundle bundle) {
            super.restoreFromBundle(bundle);
            this.pos = bundle.getInt(POS);
        }
    }

    public static class DeadlyFollowupTracker
    extends FlavourBuff {
        public int object;
        private static final String OBJECT = "object";

        public DeadlyFollowupTracker() {
            this.type = Buff.buffType.POSITIVE;
        }

        @Override
        public int icon() {
            return 57;
        }

        @Override
        public void tintIcon(Image icon) {
            icon.hardlight(0.5f, 0.0f, 1.0f);
        }

        @Override
        public float iconFadePercent() {
            return Math.max(0.0f, 1.0f - this.visualcooldown() / 5.0f);
        }

        @Override
        public void storeInBundle(Bundle bundle) {
            super.storeInBundle(bundle);
            bundle.put(OBJECT, this.object);
        }

        @Override
        public void restoreFromBundle(Bundle bundle) {
            super.restoreFromBundle(bundle);
            this.object = bundle.getInt(OBJECT);
        }
    }

    public static class RiposteTracker
    extends Buff {
        public Char enemy;

        public RiposteTracker() {
            this.actPriority = 100;
        }

        @Override
        public boolean act() {
            this.target.sprite.attack(this.enemy.pos, new Callback(){

                @Override
                public void call() {
                    AttackIndicator.target(enemy);
                    if (Dungeon.hero.attack(enemy, 1.0f, 0.0f, 1.0f)) {
                        Sample.INSTANCE.play("sounds/hit_strong.mp3");
                    }
                    this.next();
                }
            });
            this.detach();
            return false;
        }
    }

    public static class ParryCooldown
    extends Buff {
        float cooldown;

        public void set() {
            this.cooldown = 90 - 20 * Dungeon.hero.pointsInTalent(PARRY) + 1;
        }

        @Override
        public boolean act() {
            this.cooldown -= 1.0f;
            if (this.cooldown <= 0.0f) {
                Buff.affect(this.target, ParryTracker.class);
                this.detach();
            }
            if (!Dungeon.hero.hasTalent(PARRY)) {
                this.detach();
            }
            this.spend(1.0f);
            return true;
        }
    }

    public static class NatureBerriesDropped
    extends CounterBuff {
        public NatureBerriesDropped() {
            this.revivePersists = true;
        }
    }

    public static class CachedRationsDropped
    extends CounterBuff {
        public CachedRationsDropped() {
            this.revivePersists = true;
        }
    }

    public static class CounterAbilityTracker
    extends FlavourBuff {
    }

    public static class AgressiveMovementAbilityTracker
    extends FlavourBuff {
        public boolean wepAbilUsed = false;
    }

    public static class CombinedEnergyAbilityTracker
    extends FlavourBuff {
        public int energySpent = -1;
        public boolean wepAbilUsed = false;
    }

    public static class CombinedLethalityTriggerTracker
    extends FlavourBuff {
        public CombinedLethalityTriggerTracker() {
            this.type = Buff.buffType.POSITIVE;
        }

        @Override
        public int icon() {
            return 36;
        }

        @Override
        public void tintIcon(Image icon) {
            icon.hardlight(0.6f, 0.15f, 0.6f);
        }

        @Override
        public float iconFadePercent() {
            return Math.max(0.0f, 1.0f - this.visualcooldown() / 5.0f);
        }
    }

    public static class CombinedLethalityAbilityTracker
    extends FlavourBuff {
        public MeleeWeapon weapon;
    }

    public static class PreciseAssaultTracker
    extends FlavourBuff {
        public PreciseAssaultTracker() {
            this.type = Buff.buffType.POSITIVE;
        }

        @Override
        public int icon() {
            return 57;
        }

        @Override
        public void tintIcon(Image icon) {
            icon.hardlight(1.0f, 1.0f, 0.0f);
        }

        @Override
        public float iconFadePercent() {
            return Math.max(0.0f, 1.0f - this.visualcooldown() / 5.0f);
        }
    }

    public static class SwiftEquipCooldown
    extends FlavourBuff {
        public boolean secondUse;
        private static final String SECOND_USE = "second_use";

        public boolean hasSecondUse() {
            return this.secondUse && this.cooldown() > 14.0f;
        }

        @Override
        public int icon() {
            return 7;
        }

        @Override
        public void tintIcon(Image icon) {
            if (this.hasSecondUse()) {
                icon.hardlight(0.85f, 0.0f, 1.0f);
            } else {
                icon.hardlight(0.35f, 0.0f, 0.7f);
            }
        }

        @Override
        public float iconFadePercent() {
            return GameMath.gate(0.0f, this.visualcooldown() / 20.0f, 1.0f);
        }

        @Override
        public void storeInBundle(Bundle bundle) {
            super.storeInBundle(bundle);
            bundle.put(SECOND_USE, this.secondUse);
        }

        @Override
        public void restoreFromBundle(Bundle bundle) {
            super.restoreFromBundle(bundle);
            this.secondUse = bundle.getBoolean(SECOND_USE);
        }
    }

    public static class LethalHasteCooldown
    extends FlavourBuff {
        @Override
        public int icon() {
            return 7;
        }

        @Override
        public void tintIcon(Image icon) {
            icon.hardlight(0.35f, 0.0f, 0.7f);
        }

        @Override
        public float iconFadePercent() {
            return Math.max(0.0f, this.visualcooldown() / 100.0f);
        }
    }

    public static class AggressiveBarrierCooldown
    extends FlavourBuff {
        @Override
        public int icon() {
            return 7;
        }

        @Override
        public void tintIcon(Image icon) {
            icon.hardlight(0.35f, 0.0f, 0.7f);
        }

        @Override
        public float iconFadePercent() {
            return Math.max(0.0f, this.visualcooldown() / 50.0f);
        }
    }

    public static class CheatTheDeathCooldown
    extends FlavourBuff {
        @Override
        public int icon() {
            return 7;
        }

        @Override
        public void tintIcon(Image icon) {
            icon.hardlight(0x525252);
        }

        @Override
        public float iconFadePercent() {
            return Math.max(0.0f, this.visualcooldown() / 1000.0f);
        }

        public String toString() {
            return Messages.get(this, "name", new Object[0]);
        }

        @Override
        public String desc() {
            return Messages.get(this, "desc", this.dispTurns(this.visualcooldown()));
        }
    }

    public static class FlowAwayCooldown
    extends FlavourBuff {
        @Override
        public int icon() {
            return 7;
        }

        @Override
        public void tintIcon(Image icon) {
            icon.hardlight(15889176);
        }

        @Override
        public float iconFadePercent() {
            return Math.max(0.0f, this.visualcooldown() / (float)(70 - 20 * Dungeon.hero.pointsInTalent(FLOW_AWAY)));
        }

        public String toString() {
            return Messages.get(this, "name", new Object[0]);
        }

        @Override
        public String desc() {
            return Messages.get(this, "desc", this.dispTurns(this.visualcooldown()));
        }
    }

    public static class UpgradeShareCooldown
    extends FlavourBuff {
        @Override
        public int icon() {
            return 7;
        }

        @Override
        public void tintIcon(Image icon) {
            icon.hardlight(55296);
        }

        @Override
        public float iconFadePercent() {
            return Math.max(0.0f, this.visualcooldown() / (float)(3 * Dungeon.hero.pointsInTalent(UPGRADE_SHARE)));
        }

        public String toString() {
            return Messages.get(this, "name", new Object[0]);
        }

        @Override
        public String desc() {
            return Messages.get(this, "desc", this.dispTurns(this.visualcooldown()));
        }
    }

    public static class SnareCooldown
    extends FlavourBuff {
        @Override
        public int icon() {
            return 7;
        }

        @Override
        public void tintIcon(Image icon) {
            icon.hardlight(8535);
        }

        @Override
        public float iconFadePercent() {
            return Math.max(0.0f, this.visualcooldown() / 10.0f * (float)(4 - Dungeon.hero.pointsInTalent(SNARE)));
        }

        public String toString() {
            return Messages.get(this, "name", new Object[0]);
        }

        @Override
        public String desc() {
            return Messages.get(this, "desc", this.dispTurns(this.visualcooldown()));
        }
    }

    public static class DetectiveSlashingCooldown
    extends FlavourBuff {
        @Override
        public int icon() {
            return 7;
        }

        @Override
        public void tintIcon(Image icon) {
            icon.hardlight(8535);
        }

        @Override
        public float iconFadePercent() {
            return Math.max(0.0f, this.visualcooldown() / 5.0f);
        }

        public String toString() {
            return Messages.get(this, "name", new Object[0]);
        }

        @Override
        public String desc() {
            return Messages.get(this, "desc", this.dispTurns(this.visualcooldown()));
        }
    }

    public static class MaxRageCooldown
    extends FlavourBuff {
        @Override
        public int icon() {
            return 7;
        }

        @Override
        public void tintIcon(Image icon) {
            icon.hardlight(0xFF3333);
        }

        @Override
        public float iconFadePercent() {
            return Math.max(0.0f, this.visualcooldown() / 50.0f);
        }

        public String toString() {
            return Messages.get(this, "name", new Object[0]);
        }

        @Override
        public String desc() {
            return Messages.get(this, "desc", this.dispTurns(this.visualcooldown()));
        }
    }

    public static class QuickFollowupTracker
    extends FlavourBuff {
    }

    public static class QuickFollowupCooldown
    extends FlavourBuff {
        @Override
        public int icon() {
            return 7;
        }

        @Override
        public void tintIcon(Image icon) {
            icon.hardlight(6627174);
        }

        @Override
        public float iconFadePercent() {
            return Math.max(0.0f, this.visualcooldown() / 10.0f);
        }

        public String toString() {
            return Messages.get(this, "name", new Object[0]);
        }

        @Override
        public String desc() {
            return Messages.get(this, "desc", this.dispTurns(this.visualcooldown()));
        }
    }

    public static class KickCooldown
    extends FlavourBuff {
        @Override
        public int icon() {
            return 7;
        }

        @Override
        public void tintIcon(Image icon) {
            icon.hardlight(15889176);
        }

        @Override
        public float iconFadePercent() {
            return Math.max(0.0f, this.visualcooldown() / 10.0f);
        }

        public String toString() {
            return Messages.get(this, "name", new Object[0]);
        }

        @Override
        public String desc() {
            return Messages.get(this, "desc", this.dispTurns(this.visualcooldown()));
        }
    }

    public static class QuickSwapCooldown
    extends FlavourBuff {
        @Override
        public int icon() {
            return 7;
        }

        @Override
        public void tintIcon(Image icon) {
            icon.hardlight(0xB3B3B3);
        }

        @Override
        public float iconFadePercent() {
            return Math.max(0.0f, this.visualcooldown() / 5.0f);
        }

        public String toString() {
            return Messages.get(this, "name", new Object[0]);
        }

        @Override
        public String desc() {
            return Messages.get(this, "desc", this.dispTurns(this.visualcooldown()));
        }
    }

    public static class IntoTheShadowCooldown
    extends FlavourBuff {
        @Override
        public int icon() {
            return 7;
        }

        @Override
        public void tintIcon(Image icon) {
            icon.hardlight(8366546);
        }

        @Override
        public float iconFadePercent() {
            return Math.max(0.0f, 1.0f - this.visualcooldown() / 15.0f);
        }

        public String toString() {
            return Messages.get(this, "name", new Object[0]);
        }

        @Override
        public String desc() {
            return Messages.get(this, "desc", this.dispTurns(this.visualcooldown()));
        }
    }

    public static class SkillfulRunnerCooldown
    extends FlavourBuff {
        @Override
        public int icon() {
            return 7;
        }

        @Override
        public void tintIcon(Image icon) {
            icon.hardlight(0xFFFF00);
        }

        @Override
        public float iconFadePercent() {
            return Math.max(0.0f, 1.0f - this.visualcooldown() / 30.0f);
        }

        public String toString() {
            return Messages.get(this, "name", new Object[0]);
        }

        @Override
        public String desc() {
            return Messages.get(this, "desc", this.dispTurns(this.visualcooldown()));
        }
    }

    public static class StreetBattleCooldown
    extends FlavourBuff {
        @Override
        public int icon() {
            return 7;
        }

        @Override
        public void tintIcon(Image icon) {
            icon.hardlight(0xB3B3B3);
        }

        @Override
        public float iconFadePercent() {
            return Math.max(0.0f, 1.0f - this.visualcooldown() / (float)(40 - 10 * Dungeon.hero.pointsInTalent(STREET_BATTLE)));
        }

        public String toString() {
            return Messages.get(this, "name", new Object[0]);
        }

        @Override
        public String desc() {
            return Messages.get(this, "desc", this.dispTurns(this.visualcooldown()));
        }
    }

    public static class TakeDownCooldown
    extends FlavourBuff {
        @Override
        public int icon() {
            return 7;
        }

        @Override
        public void tintIcon(Image icon) {
            icon.hardlight(1.0f, 2.0f, 0.25f);
        }

        @Override
        public float iconFadePercent() {
            return Math.max(0.0f, this.visualcooldown() / 15.0f);
        }

        public String toString() {
            return Messages.get(this, "name", new Object[0]);
        }

        @Override
        public String desc() {
            return Messages.get(this, "desc", this.dispTurns(this.visualcooldown()));
        }
    }

    public static class ReloadCooldown
    extends FlavourBuff {
        @Override
        public int icon() {
            return 7;
        }

        @Override
        public void tintIcon(Image icon) {
            icon.hardlight(0.3f, 0.3f, 0.3f);
        }

        @Override
        public float iconFadePercent() {
            return Math.max(0.0f, this.visualcooldown() / 6.0f);
        }

        public String toString() {
            return Messages.get(this, "name", new Object[0]);
        }

        @Override
        public String desc() {
            return Messages.get(this, "desc", this.dispTurns(this.visualcooldown()));
        }
    }

    public static class LethalCooldown
    extends FlavourBuff {
        @Override
        public int icon() {
            return 7;
        }

        @Override
        public void tintIcon(Image icon) {
            icon.hardlight(0.8f, 0.1f, 0.1f);
        }

        @Override
        public float iconFadePercent() {
            return Math.max(0.0f, this.visualcooldown() / 5.0f);
        }

        public String toString() {
            return Messages.get(this, "name", new Object[0]);
        }

        @Override
        public String desc() {
            return Messages.get(this, "desc", this.dispTurns(this.visualcooldown()));
        }

        public void spendTime() {
            this.spend(-1.0f);
        }
    }

    public static class ChainCooldown
    extends FlavourBuff {
        @Override
        public int icon() {
            return 7;
        }

        @Override
        public void tintIcon(Image icon) {
            icon.hardlight(0.2f, 0.5f, 0.8f);
        }

        @Override
        public float iconFadePercent() {
            return Math.max(0.0f, this.visualcooldown() / 10.0f);
        }

        public String toString() {
            return Messages.get(this, "name", new Object[0]);
        }

        @Override
        public String desc() {
            return Messages.get(this, "desc", this.dispTurns(this.visualcooldown()));
        }

        public void spendTime() {
            this.spend(-1.0f);
        }
    }

    public static class ChaseCooldown
    extends FlavourBuff {
        @Override
        public int icon() {
            return 7;
        }

        @Override
        public void tintIcon(Image icon) {
            icon.hardlight(0.4f, 0.4f, 0.8f);
        }

        @Override
        public float iconFadePercent() {
            return Math.max(0.0f, this.visualcooldown() / 15.0f);
        }

        public String toString() {
            return Messages.get(this, "name", new Object[0]);
        }

        @Override
        public String desc() {
            return Messages.get(this, "desc", this.dispTurns(this.visualcooldown()));
        }

        public void spendTime() {
            this.spend(-1.0f);
        }
    }

    public static class SeerShotCooldown
    extends FlavourBuff {
        @Override
        public int icon() {
            return this.target.buff(RevealedArea.class) != null ? 127 : 7;
        }

        @Override
        public void tintIcon(Image icon) {
            icon.hardlight(0.7f, 0.4f, 0.7f);
        }

        @Override
        public float iconFadePercent() {
            return Math.max(0.0f, this.visualcooldown() / 20.0f);
        }
    }

    public static class RejuvenatingStepsFurrow
    extends CounterBuff {
        public RejuvenatingStepsFurrow() {
            this.revivePersists = true;
        }
    }

    public static class RejuvenatingStepsCooldown
    extends FlavourBuff {
        @Override
        public int icon() {
            return 7;
        }

        @Override
        public void tintIcon(Image icon) {
            icon.hardlight(0.0f, 0.35f, 0.15f);
        }

        @Override
        public float iconFadePercent() {
            return GameMath.gate(0.0f, this.visualcooldown() / (float)(15 - 5 * Dungeon.hero.pointsInTalent(REJUVENATING_STEPS)), 1.0f);
        }
    }

    public static class JungQuickDrawTracker
    extends Buff {
    }

    public static class SurpriseStabTracker
    extends Buff {
    }

    public static class ActiveBarrierTracker
    extends Buff {
    }

    public static class IncisiveBladeTracker
    extends Buff {
    }

    public static class DetactiveSlashingTracker
    extends Buff {
    }

    public static class CounterAttackTracker
    extends Buff {
    }

    public static class MysticalPunchTracker
    extends Buff {
    }

    public static class ShootingEyesTracker
    extends Buff {
    }

    public static class BountyHunterTracker
    extends FlavourBuff {
    }

    public static class SkilledHandTracker
    extends Buff {
    }

    public static class EmpoweredStrikeTracker
    extends FlavourBuff {
    }

    public static class WandPreservationCounter
    extends CounterBuff {
        public WandPreservationCounter() {
            this.revivePersists = true;
        }
    }

    public static class StrikingWaveTracker
    extends FlavourBuff {
    }

    public static class LethalMomentumTracker
    extends FlavourBuff {
    }

    public static class ImprovisedProjectileCooldown
    extends FlavourBuff {
        @Override
        public int icon() {
            return 7;
        }

        @Override
        public void tintIcon(Image icon) {
            icon.hardlight(0.15f, 0.2f, 0.5f);
        }

        @Override
        public float iconFadePercent() {
            return Math.max(0.0f, this.visualcooldown() / 50.0f);
        }
    }
}

