/*
 * Decompiled with CFR 0.152.
 */
package com.shatteredpixel.shatteredpixeldungeon.actors.hero.abilities.knight;

import com.shatteredpixel.shatteredpixeldungeon.actors.buffs.Barrier;
import com.shatteredpixel.shatteredpixeldungeon.actors.buffs.Bless;
import com.shatteredpixel.shatteredpixeldungeon.actors.buffs.Buff;
import com.shatteredpixel.shatteredpixeldungeon.actors.buffs.Light;
import com.shatteredpixel.shatteredpixeldungeon.actors.hero.Hero;
import com.shatteredpixel.shatteredpixeldungeon.actors.hero.Talent;
import com.shatteredpixel.shatteredpixeldungeon.actors.hero.abilities.ArmorAbility;
import com.shatteredpixel.shatteredpixeldungeon.effects.particles.EnergyParticle;
import com.shatteredpixel.shatteredpixeldungeon.items.armor.ClassArmor;
import com.watabou.noosa.audio.Sample;
import com.watabou.noosa.particles.Emitter;

public class HolyShield
extends ArmorAbility {
    public HolyShield() {
        this.baseChargeUse = 35.0f;
    }

    @Override
    protected void activate(ClassArmor armor, Hero hero, Integer target) {
        int shieldAmount = 25;
        if (hero.hasTalent(Talent.BUFFER_BARRIER)) {
            shieldAmount += 5 * hero.pointsInTalent(Talent.BUFFER_BARRIER);
        }
        Buff.affect(hero, Barrier.class).setShield(shieldAmount);
        if (hero.hasTalent(Talent.HOLY_LIGHT)) {
            Buff.affect(hero, Light.class, 25 * hero.pointsInTalent(Talent.HOLY_LIGHT));
        }
        if (hero.hasTalent(Talent.BLESS)) {
            Buff.affect(hero, Bless.class, 5 * hero.pointsInTalent(Talent.BLESS));
        }
        hero.sprite.operate(hero.pos);
        Sample.INSTANCE.play("sounds/chargeup.mp3");
        Emitter e = hero.sprite.centerEmitter();
        if (e != null) {
            e.burst(EnergyParticle.FACTORY, 15);
        }
        armor.charge -= this.chargeUse(hero);
        armor.updateQuickslot();
        hero.spendAndNext(1.0f);
    }

    @Override
    public int icon() {
        return 84;
    }

    @Override
    public Talent[] talents() {
        return new Talent[]{Talent.BUFFER_BARRIER, Talent.HOLY_LIGHT, Talent.BLESS, Talent.HEROIC_ENERGY};
    }
}

