/*
 * Decompiled with CFR 0.152.
 */
package com.shatteredpixel.shatteredpixeldungeon.actors.hero.abilities.knight;

import com.shatteredpixel.shatteredpixeldungeon.Dungeon;
import com.shatteredpixel.shatteredpixeldungeon.actors.buffs.AnkhInvulnerability;
import com.shatteredpixel.shatteredpixeldungeon.actors.buffs.Buff;
import com.shatteredpixel.shatteredpixeldungeon.actors.buffs.Invisibility;
import com.shatteredpixel.shatteredpixeldungeon.actors.hero.Hero;
import com.shatteredpixel.shatteredpixeldungeon.actors.hero.Talent;
import com.shatteredpixel.shatteredpixeldungeon.actors.hero.abilities.ArmorAbility;
import com.shatteredpixel.shatteredpixeldungeon.effects.Flare;
import com.shatteredpixel.shatteredpixeldungeon.items.Ankh;
import com.shatteredpixel.shatteredpixeldungeon.items.Item;
import com.shatteredpixel.shatteredpixeldungeon.items.armor.ClassArmor;
import com.shatteredpixel.shatteredpixeldungeon.messages.Messages;
import com.shatteredpixel.shatteredpixeldungeon.utils.GLog;
import com.watabou.noosa.audio.Sample;
import com.watabou.utils.Random;

public class UnstableAnkh
extends ArmorAbility {
    public UnstableAnkh() {
        this.baseChargeUse = 100.0f;
    }

    @Override
    protected void activate(ClassArmor armor, Hero hero, Integer target) {
        int duration = 1;
        if (hero.hasTalent(Talent.ANKH_ENHANCE)) {
            int points = hero.pointsInTalent(Talent.ANKH_ENHANCE);
            if (points == 1) {
                int n = duration = Random.Int(2) == 0 ? 1 : 2;
            }
            if (points == 2) {
                duration = 2;
            }
            if (points == 3) {
                int n = duration = Random.Int(2) == 0 ? 2 : 3;
            }
            if (points == 4) {
                duration = 3;
            }
        }
        Buff.affect(hero, AnkhInvulnerability.class, duration);
        if (hero.hasTalent(Talent.COMPLETE_ANKH) && Random.Int(100) < hero.pointsInTalent(Talent.COMPLETE_ANKH)) {
            Ankh ankh = new Ankh();
            Dungeon.level.drop((Item)ankh, (int)Dungeon.hero.pos).sprite.drop();
            new Flare(6, 32.0f).color(0xFFAA00, true).show(hero.sprite, 4.0f);
            GLog.p(Messages.get(this, "ankh_dropped", new Object[0]), new Object[0]);
        }
        if (hero.hasTalent(Talent.BLESSED_ANKH)) {
            int healAmt = 5 * hero.pointsInTalent(Talent.BLESSED_ANKH);
            hero.heal(healAmt);
        }
        hero.sprite.operate(hero.pos);
        Sample.INSTANCE.play("sounds/teleport.mp3");
        armor.charge -= this.chargeUse(hero);
        armor.updateQuickslot();
        Invisibility.dispel();
        hero.spendAndNext(1.0f);
    }

    @Override
    public int icon() {
        return 86;
    }

    @Override
    public Talent[] talents() {
        return new Talent[]{Talent.BLESSED_ANKH, Talent.ANKH_ENHANCE, Talent.COMPLETE_ANKH, Talent.HEROIC_ENERGY};
    }
}

