/*
 * Decompiled with CFR 0.152.
 */
package com.shatteredpixel.shatteredpixeldungeon.actors.hero.abilities.planter;

import com.shatteredpixel.shatteredpixeldungeon.Dungeon;
import com.shatteredpixel.shatteredpixeldungeon.actors.buffs.Invisibility;
import com.shatteredpixel.shatteredpixeldungeon.actors.hero.Hero;
import com.shatteredpixel.shatteredpixeldungeon.actors.hero.Talent;
import com.shatteredpixel.shatteredpixeldungeon.actors.hero.abilities.ArmorAbility;
import com.shatteredpixel.shatteredpixeldungeon.effects.CellEmitter;
import com.shatteredpixel.shatteredpixeldungeon.effects.particles.LeafParticle;
import com.shatteredpixel.shatteredpixeldungeon.items.Generator;
import com.shatteredpixel.shatteredpixeldungeon.items.armor.ClassArmor;
import com.shatteredpixel.shatteredpixeldungeon.levels.Level;
import com.shatteredpixel.shatteredpixeldungeon.mechanics.Ballistica;
import com.shatteredpixel.shatteredpixeldungeon.mechanics.ConeAOE;
import com.shatteredpixel.shatteredpixeldungeon.plants.Plant;
import com.shatteredpixel.shatteredpixeldungeon.scenes.GameScene;
import com.watabou.noosa.audio.Sample;
import com.watabou.utils.Random;
import java.util.ArrayList;

public class Sprout
extends ArmorAbility {
    public Sprout() {
        this.baseChargeUse = 35.0f;
    }

    @Override
    protected void activate(ClassArmor armor, Hero hero, Integer target) {
        ArrayList plantCandidates = new ArrayList();
        Ballistica aim = hero.pos % Dungeon.level.width() > 10 ? new Ballistica(hero.pos, hero.pos - 1, 0) : new Ballistica(hero.pos, hero.pos + 1, 0);
        int aoeSize = 4 + hero.pointsInTalent(Talent.FOREST);
        int projectileProps = 5;
        ConeAOE aoe = new ConeAOE(aim, aoeSize, 360.0f, projectileProps);
        float effectMulti = 0.1f * (float)hero.pointsInTalent(Talent.JUNGLE);
        for (int cell : aoe.cells) {
            int t = Dungeon.level.map[cell];
            if (Random.Float() < 0.2f + effectMulti && (t == 1 || t == 20 || t == 9 || t == 2 || t == 30) && Dungeon.level.plants.get(cell) == null) {
                if (hero.hasTalent(Talent.REGROWTH) && Random.Int(20) < hero.pointsInTalent(Talent.REGROWTH)) {
                    Dungeon.level.plant((Plant.Seed)Generator.randomUsingDefaults(Generator.Category.SEED), cell);
                    CellEmitter.get(cell).burst(LeafParticle.LEVEL_SPECIFIC, 8);
                } else {
                    Level.set(cell, 15);
                    CellEmitter.get(cell).burst(LeafParticle.LEVEL_SPECIFIC, 4);
                }
                GameScene.updateMap(cell);
            }
            if (!hero.hasTalent(Talent.REGROWTH)) continue;
            int plants = hero.pointsInTalent(Talent.REGROWTH);
            for (int i = 0; i < plants; ++i) {
                Integer plantPos = (Integer)Random.element(plantCandidates);
                if (plantPos == null) continue;
                Dungeon.level.plant((Plant.Seed)Generator.randomUsingDefaults(Generator.Category.SEED), plantPos);
                plantCandidates.remove(plantPos);
            }
        }
        hero.spendAndNext(1.0f);
        hero.sprite.operate(hero.pos);
        Invisibility.dispel();
        hero.busy();
        armor.charge -= this.chargeUse(hero);
        armor.updateQuickslot();
        Sample.INSTANCE.play("sounds/trample.mp3");
    }

    @Override
    public int icon() {
        return 80;
    }

    @Override
    public Talent[] talents() {
        return new Talent[]{Talent.JUNGLE, Talent.FOREST, Talent.REGROWTH, Talent.HEROIC_ENERGY};
    }
}

