/*
 * Decompiled with CFR 0.152.
 */
package com.shatteredpixel.shatteredpixeldungeon.actors.hero.abilities.planter;

import com.shatteredpixel.shatteredpixeldungeon.Dungeon;
import com.shatteredpixel.shatteredpixeldungeon.actors.buffs.Awareness;
import com.shatteredpixel.shatteredpixeldungeon.actors.buffs.Buff;
import com.shatteredpixel.shatteredpixeldungeon.actors.buffs.FlavourBuff;
import com.shatteredpixel.shatteredpixeldungeon.actors.buffs.Foresight;
import com.shatteredpixel.shatteredpixeldungeon.actors.buffs.Invisibility;
import com.shatteredpixel.shatteredpixeldungeon.actors.hero.Hero;
import com.shatteredpixel.shatteredpixeldungeon.actors.hero.Talent;
import com.shatteredpixel.shatteredpixeldungeon.actors.hero.abilities.ArmorAbility;
import com.shatteredpixel.shatteredpixeldungeon.effects.Identification;
import com.shatteredpixel.shatteredpixeldungeon.items.armor.ClassArmor;
import com.shatteredpixel.shatteredpixeldungeon.messages.Messages;
import com.shatteredpixel.shatteredpixeldungeon.sprites.HeroSprite;
import com.watabou.noosa.audio.Sample;

public class TreasureMap
extends ArmorAbility {
    public TreasureMap() {
        this.baseChargeUse = 50.0f;
    }

    @Override
    protected void activate(ClassArmor armor, Hero hero, Integer target) {
        Sample.INSTANCE.play("sounds/read.mp3");
        Buff.prolong(hero, Awareness.class, 2.0f);
        Buff.prolong(hero, LuckTracker.class, 20.0f * (1.0f + 0.2f * (float)hero.pointsInTalent(Talent.LONG_LUCK)));
        if (hero.hasTalent(Talent.FORESIGHT)) {
            Buff.prolong(hero, Foresight.class, 5.0f * (float)hero.pointsInTalent(Talent.FORESIGHT));
        }
        Dungeon.observe();
        hero.sprite.parent.add(new Identification(hero.sprite.center().offset(0.0f, -16.0f)));
        hero.busy();
        ((HeroSprite)hero.sprite).read();
        armor.charge -= this.chargeUse(hero);
        armor.updateQuickslot();
        Invisibility.dispel();
        hero.spendAndNext(1.0f);
    }

    @Override
    public int icon() {
        return 81;
    }

    @Override
    public Talent[] talents() {
        return new Talent[]{Talent.LONG_LUCK, Talent.FORESIGHT, Talent.GOLD_HUNTER, Talent.HEROIC_ENERGY};
    }

    public static class LuckTracker
    extends FlavourBuff {
        public static final float DURATION = 20.0f;

        @Override
        public int icon() {
            return 142;
        }

        @Override
        public float iconFadePercent() {
            return Math.max(0.0f, (20.0f - this.visualcooldown()) / 20.0f);
        }

        public String toString() {
            return Messages.get(this, "name", new Object[0]);
        }

        @Override
        public String desc() {
            return Messages.get(this, "desc", this.dispTurns());
        }
    }

    public static class GoldTracker
    extends FlavourBuff {
        public static final float DURATION = 1.0001f;
    }
}

