/*
 * Decompiled with CFR 0.152.
 */
package com.shatteredpixel.shatteredpixeldungeon.actors.hero.abilities.samurai;

import com.shatteredpixel.shatteredpixeldungeon.Dungeon;
import com.shatteredpixel.shatteredpixeldungeon.actors.Actor;
import com.shatteredpixel.shatteredpixeldungeon.actors.Char;
import com.shatteredpixel.shatteredpixeldungeon.actors.buffs.Buff;
import com.shatteredpixel.shatteredpixeldungeon.actors.buffs.Corrosion;
import com.shatteredpixel.shatteredpixeldungeon.actors.buffs.Doom;
import com.shatteredpixel.shatteredpixeldungeon.actors.buffs.Invisibility;
import com.shatteredpixel.shatteredpixeldungeon.actors.buffs.Vulnerable;
import com.shatteredpixel.shatteredpixeldungeon.actors.hero.Hero;
import com.shatteredpixel.shatteredpixeldungeon.actors.hero.Talent;
import com.shatteredpixel.shatteredpixeldungeon.actors.hero.abilities.ArmorAbility;
import com.shatteredpixel.shatteredpixeldungeon.items.Item;
import com.shatteredpixel.shatteredpixeldungeon.items.armor.ClassArmor;
import com.shatteredpixel.shatteredpixeldungeon.items.artifacts.TalismanOfForesight;
import com.shatteredpixel.shatteredpixeldungeon.items.weapon.missiles.Kunai;
import com.shatteredpixel.shatteredpixeldungeon.mechanics.Ballistica;
import com.shatteredpixel.shatteredpixeldungeon.messages.Messages;
import com.shatteredpixel.shatteredpixeldungeon.sprites.MissileSprite;
import com.shatteredpixel.shatteredpixeldungeon.utils.GLog;
import com.watabou.noosa.Visual;
import com.watabou.utils.Callback;
import com.watabou.utils.Random;
import java.util.HashSet;

public class Abil_Kunai
extends ArmorAbility {
    public Abil_Kunai() {
        this.baseChargeUse = 75.0f;
    }

    @Override
    public String targetingPrompt() {
        return Messages.get(this, "prompt", new Object[0]);
    }

    @Override
    protected void activate(ClassArmor armor, final Hero hero, Integer target) {
        HashSet<Char> targets;
        if (target == null) {
            return;
        }
        if (Actor.findChar(target) == hero) {
            GLog.w(Messages.get(this, "self_target", new Object[0]), new Object[0]);
            return;
        }
        Ballistica b = new Ballistica(hero.pos, target, 4);
        final Char enemy = this.findChar(b, hero, -1, targets = new HashSet<Char>());
        if (enemy == null) {
            GLog.w(Messages.get(this, "no_target", new Object[0]), new Object[0]);
            return;
        }
        targets.add(enemy);
        while (targets.size() > 1) {
            Char furthest = null;
            for (Char ch : targets) {
                if (furthest == null) {
                    furthest = ch;
                    continue;
                }
                if (!(Dungeon.level.trueDistance(enemy.pos, ch.pos) > Dungeon.level.trueDistance(enemy.pos, furthest.pos))) continue;
                furthest = ch;
            }
            targets.remove(furthest);
        }
        armor.charge -= this.chargeUse(hero);
        Item.updateQuickslot();
        Kunai proto = new Kunai();
        final HashSet<1> callbacks = new HashSet<1>();
        for (final Char ch : targets) {
            Callback callback = new Callback(){

                @Override
                public void call() {
                    float dmgMulti = ch == enemy ? 1.0f : 0.5f;
                    float accmulti = 1.0f + 0.25f * (float)hero.pointsInTalent(Talent.MYSTICAL_KUNAI);
                    hero.attack(ch, dmgMulti, 0.0f, accmulti);
                    Buff.affect(enemy, Vulnerable.class, 20.0f);
                    if (hero.hasTalent(Talent.KUNAI_OF_DOOM) && Random.Int(20) < hero.pointsInTalent(Talent.KUNAI_OF_DOOM)) {
                        Buff.affect(enemy, Doom.class);
                    }
                    if (hero.hasTalent(Talent.CORROSIVE_KUNAI)) {
                        if (enemy.properties().contains((Object)Char.Property.BOSS) || enemy.properties().contains((Object)Char.Property.MINIBOSS)) {
                            Buff.affect(enemy, Corrosion.class).set(3.0f, 2 * hero.pointsInTalent(Talent.CORROSIVE_KUNAI));
                        } else {
                            Buff.affect(enemy, Corrosion.class).set(5.0f, 2 * hero.pointsInTalent(Talent.CORROSIVE_KUNAI));
                        }
                    }
                    if (hero.hasTalent(Talent.MYSTICAL_KUNAI)) {
                        int dur = 5 + 5 * Dungeon.hero.pointsInTalent(Talent.MYSTICAL_KUNAI);
                        Buff.append((Char)Dungeon.hero, TalismanOfForesight.CharAwareness.class, (float)((float)dur)).charID = ch.id();
                    }
                    callbacks.remove(this);
                    if (callbacks.isEmpty()) {
                        Invisibility.dispel();
                        hero.spendAndNext(hero.attackDelay());
                    }
                }
            };
            MissileSprite m = (MissileSprite)hero.sprite.parent.recycle(MissileSprite.class);
            m.reset((Visual)hero.sprite, ch.pos, (Item)proto, callback);
            m.hardlight(0.6f, 1.0f, 1.0f);
            m.alpha(0.8f);
            callbacks.add(callback);
        }
        hero.sprite.zap(enemy.pos);
        hero.busy();
    }

    private Char findChar(Ballistica path, Hero hero, int wallPenetration, HashSet<Char> existingTargets) {
        for (int cell : path.path) {
            Char ch = Actor.findChar(cell);
            if (ch != null) {
                if (ch == hero || existingTargets.contains(ch) || ch.alignment == Char.Alignment.ALLY) continue;
                return ch;
            }
            if (!Dungeon.level.solid[cell] || --wallPenetration >= 0) continue;
            return null;
        }
        return null;
    }

    @Override
    public int icon() {
        return 78;
    }

    @Override
    public Talent[] talents() {
        return new Talent[]{Talent.KUNAI_OF_DOOM, Talent.MYSTICAL_KUNAI, Talent.CORROSIVE_KUNAI, Talent.HEROIC_ENERGY};
    }
}

