/*
 * Decompiled with CFR 0.152.
 */
package com.shatteredpixel.shatteredpixeldungeon.actors.hero.abilities.samurai;

import com.shatteredpixel.shatteredpixeldungeon.actors.buffs.Buff;
import com.shatteredpixel.shatteredpixeldungeon.actors.buffs.FlavourBuff;
import com.shatteredpixel.shatteredpixeldungeon.actors.buffs.Invisibility;
import com.shatteredpixel.shatteredpixeldungeon.actors.hero.Hero;
import com.shatteredpixel.shatteredpixeldungeon.actors.hero.Talent;
import com.shatteredpixel.shatteredpixeldungeon.actors.hero.abilities.ArmorAbility;
import com.shatteredpixel.shatteredpixeldungeon.effects.particles.ShadowParticle;
import com.shatteredpixel.shatteredpixeldungeon.items.armor.ClassArmor;
import com.shatteredpixel.shatteredpixeldungeon.messages.Messages;
import com.watabou.noosa.audio.Sample;

public class ShadowBlade
extends ArmorAbility {
    public ShadowBlade() {
        this.baseChargeUse = 25.0f;
    }

    @Override
    protected void activate(ClassArmor armor, Hero hero, Integer target) {
        Buff.prolong(hero, shadowBladeTracker.class, 10.0f);
        hero.sprite.operate(hero.pos);
        Sample.INSTANCE.play("sounds/miss.mp3");
        hero.sprite.emitter().burst(ShadowParticle.UP, 10);
        armor.charge -= this.chargeUse(hero);
        armor.updateQuickslot();
        Invisibility.dispel();
        hero.spendAndNext(1.0f);
    }

    @Override
    public int icon() {
        return 77;
    }

    @Override
    public Talent[] talents() {
        return new Talent[]{Talent.DOUBLE_BLADE_PRACTICE, Talent.CRITICAL_SHADOW, Talent.HERBAL_SHADOW, Talent.HEROIC_ENERGY};
    }

    public static class shadowBladeTracker
    extends FlavourBuff {
        public static final float DURATION = 10.0f;

        @Override
        public int icon() {
            return 140;
        }

        @Override
        public float iconFadePercent() {
            return Math.max(0.0f, (10.0f - this.visualcooldown()) / 10.0f);
        }

        public String toString() {
            return Messages.get(this, "name", new Object[0]);
        }

        @Override
        public String desc() {
            return Messages.get(this, "desc", this.dispTurns());
        }
    }
}

