/*
 * Decompiled with CFR 0.152.
 */
package com.shatteredpixel.shatteredpixeldungeon.actors.mobs;

import com.shatteredpixel.shatteredpixeldungeon.Dungeon;
import com.shatteredpixel.shatteredpixeldungeon.actors.Char;
import com.shatteredpixel.shatteredpixeldungeon.actors.buffs.Buff;
import com.shatteredpixel.shatteredpixeldungeon.actors.buffs.Ooze;
import com.shatteredpixel.shatteredpixeldungeon.actors.mobs.Mob;
import com.shatteredpixel.shatteredpixeldungeon.items.Generator;
import com.shatteredpixel.shatteredpixeldungeon.items.Item;
import com.shatteredpixel.shatteredpixeldungeon.items.potions.PotionOfHealing;
import com.shatteredpixel.shatteredpixeldungeon.items.potions.PotionOfStrength;
import com.shatteredpixel.shatteredpixeldungeon.sprites.ResearcherSprite;
import com.watabou.utils.Random;
import com.watabou.utils.Reflection;

public class Researcher
extends Mob {
    public Researcher() {
        this.spriteClass = ResearcherSprite.class;
        this.HT = 120;
        this.HP = 120;
        this.defenseSkill = 25;
        this.viewDistance = 6;
        this.EXP = 14;
        this.maxLvl = 30;
        this.loot = Generator.Category.POTION;
        this.lootChance = 0.5f;
    }

    @Override
    public int damageRoll() {
        return Random.NormalIntRange(30, 50);
    }

    @Override
    public int attackProc(Char enemy, int damage) {
        damage = super.attackProc(enemy, damage);
        if (Random.Int(4) == 0) {
            Buff.affect(enemy, Ooze.class).set(20.0f);
        }
        return damage;
    }

    @Override
    public Item createLoot() {
        Class<?> loot;
        if (Dungeon.depth == 30) {
            return null;
        }
        while ((loot = Random.oneOf(Generator.Category.POTION.classes)) == PotionOfHealing.class || loot == PotionOfStrength.class) {
        }
        return (Item)Reflection.newInstance(loot);
    }

    @Override
    public int attackSkill(Char target) {
        return 40;
    }

    @Override
    public int drRoll() {
        return Random.NormalIntRange(0, 20);
    }
}

