/*
 * Decompiled with CFR 0.152.
 */
package com.shatteredpixel.shatteredpixeldungeon.actors.mobs;

import com.shatteredpixel.shatteredpixeldungeon.Dungeon;
import com.shatteredpixel.shatteredpixeldungeon.actors.Char;
import com.shatteredpixel.shatteredpixeldungeon.actors.mobs.Mob;
import com.shatteredpixel.shatteredpixeldungeon.items.Generator;
import com.shatteredpixel.shatteredpixeldungeon.items.Item;
import com.shatteredpixel.shatteredpixeldungeon.items.weapon.melee.AssultRifle;
import com.shatteredpixel.shatteredpixeldungeon.items.weapon.melee.Handgun;
import com.shatteredpixel.shatteredpixeldungeon.items.weapon.melee.HeavyMachinegun;
import com.shatteredpixel.shatteredpixeldungeon.items.weapon.melee.Magnum;
import com.shatteredpixel.shatteredpixeldungeon.items.weapon.melee.RocketLauncher;
import com.shatteredpixel.shatteredpixeldungeon.items.weapon.melee.ShotGun;
import com.shatteredpixel.shatteredpixeldungeon.items.weapon.melee.SniperRifle;
import com.shatteredpixel.shatteredpixeldungeon.mechanics.Ballistica;
import com.shatteredpixel.shatteredpixeldungeon.sprites.SoldierSprite;
import com.watabou.utils.Random;
import com.watabou.utils.Reflection;

public class Soldier
extends Mob {
    public Soldier() {
        this.spriteClass = SoldierSprite.class;
        this.HT = 150;
        this.HP = 150;
        this.defenseSkill = 20;
        this.viewDistance = 6;
        this.EXP = 15;
        this.maxLvl = 30;
        this.loot = Generator.Category.WEAPON;
        this.lootChance = 0.1667f;
    }

    @Override
    public int damageRoll() {
        return Random.NormalIntRange(40, 50);
    }

    @Override
    public int attackSkill(Char target) {
        return 45;
    }

    @Override
    public int drRoll() {
        return Random.NormalIntRange(5, 20);
    }

    @Override
    protected boolean canAttack(Char enemy) {
        Ballistica attack = new Ballistica(this.pos, enemy.pos, 7);
        return !Dungeon.level.adjacent(this.pos, enemy.pos) && attack.collisionPos == enemy.pos;
    }

    @Override
    public int attackProc(Char enemy, int damage) {
        damage = super.attackProc(enemy, damage);
        return damage;
    }

    @Override
    protected boolean getCloser(int target) {
        if (this.state == this.HUNTING) {
            return this.enemySeen && this.getFurther(target);
        }
        return super.getCloser(target);
    }

    @Override
    public float speed() {
        return super.speed() * 0.8333333f;
    }

    @Override
    public void aggro(Char ch) {
        if (ch == null || this.fieldOfView == null || this.fieldOfView[ch.pos]) {
            super.aggro(ch);
        }
    }

    @Override
    public void rollToDropLoot() {
        this.lootChance = (float)((double)this.lootChance * Math.pow(0.5, Dungeon.LimitedDrops.SOLDIER_WEP.count));
        super.rollToDropLoot();
    }

    @Override
    public Item createLoot() {
        if (Dungeon.depth == 30) {
            return null;
        }
        ++Dungeon.LimitedDrops.SOLDIER_WEP.count;
        Class loot = Random.oneOf(Handgun.class, Magnum.class, AssultRifle.class, HeavyMachinegun.class, SniperRifle.class, RocketLauncher.class, ShotGun.class);
        return (Item)Reflection.newInstance(loot);
    }
}

