/*
 * Decompiled with CFR 0.152.
 */
package com.shatteredpixel.shatteredpixeldungeon.actors.mobs;

import com.shatteredpixel.shatteredpixeldungeon.Dungeon;
import com.shatteredpixel.shatteredpixeldungeon.actors.Actor;
import com.shatteredpixel.shatteredpixeldungeon.actors.Char;
import com.shatteredpixel.shatteredpixeldungeon.actors.buffs.AllyBuff;
import com.shatteredpixel.shatteredpixeldungeon.actors.buffs.Buff;
import com.shatteredpixel.shatteredpixeldungeon.actors.buffs.ChampionEnemy;
import com.shatteredpixel.shatteredpixeldungeon.actors.mobs.DwarfKing;
import com.shatteredpixel.shatteredpixeldungeon.actors.mobs.Mob;
import com.shatteredpixel.shatteredpixeldungeon.effects.Pushing;
import com.shatteredpixel.shatteredpixeldungeon.items.EnergyCrystal;
import com.shatteredpixel.shatteredpixeldungeon.items.Item;
import com.shatteredpixel.shatteredpixeldungeon.scenes.GameScene;
import com.shatteredpixel.shatteredpixeldungeon.sprites.SupressionSprite;
import com.watabou.utils.Bundle;
import com.watabou.utils.Random;
import java.util.ArrayList;

public class Supression
extends Mob {
    private int timesDowned;
    protected int partnerID;
    private static final String PARTNER_ID = "partner_id";
    private static final String TIMES_DOWNED = "times_downed";
    private boolean beingLifeLinked;

    public Supression() {
        this.spriteClass = SupressionSprite.class;
        this.HT = 150;
        this.HP = 150;
        this.defenseSkill = 15;
        this.EXP = 5;
        this.maxLvl = 20;
        this.SLEEPING = new Sleeping();
        this.WANDERING = new Wandering();
        this.state = this.SLEEPING;
        this.lootChance = 0.2f;
        this.timesDowned = 0;
        this.partnerID = -1;
        this.beingLifeLinked = false;
    }

    @Override
    public int damageRoll() {
        return Random.NormalIntRange(20, 40);
    }

    @Override
    public int attackSkill(Char target) {
        return 30;
    }

    @Override
    public int drRoll() {
        return Random.NormalIntRange(5, 30);
    }

    @Override
    public float spawningWeight() {
        return 0.5f;
    }

    @Override
    public void storeInBundle(Bundle bundle) {
        super.storeInBundle(bundle);
        bundle.put(PARTNER_ID, this.partnerID);
        bundle.put(TIMES_DOWNED, this.timesDowned);
    }

    @Override
    public void restoreFromBundle(Bundle bundle) {
        super.restoreFromBundle(bundle);
        this.partnerID = bundle.getInt(PARTNER_ID);
        this.timesDowned = bundle.getInt(TIMES_DOWNED);
    }

    @Override
    public Item createLoot() {
        return new EnergyCrystal().quantity(Random.NormalIntRange(1, 6));
    }

    /*
     * WARNING - void declaration
     */
    @Override
    protected boolean act() {
        if (this.partnerID == -1) {
            void var5_7;
            int[] neighbours;
            ArrayList<Integer> candidates = new ArrayList<Integer>();
            int[] nArray = neighbours = new int[]{this.pos + 1, this.pos - 1, this.pos + Dungeon.level.width(), this.pos - Dungeon.level.width()};
            int n = nArray.length;
            boolean bl = false;
            while (var5_7 < n) {
                int n2 = nArray[var5_7];
                if (Dungeon.level.passable[n2] && Actor.findChar(n2) == null) {
                    candidates.add(n2);
                }
                ++var5_7;
            }
            if (!candidates.isEmpty()) {
                Supression child = new Supression();
                child.partnerID = this.id();
                this.partnerID = child.id();
                if (this.state != this.SLEEPING) {
                    child.state = child.WANDERING;
                }
                child.pos = (Integer)Random.element(candidates);
                GameScene.add(child);
                Dungeon.level.occupyCell(child);
                if (this.sprite.visible) {
                    Actor.addDelayed(new Pushing(child, this.pos, child.pos), -1.0f);
                }
                for (Buff buff : this.buffs(ChampionEnemy.class)) {
                    Buff.affect(child, buff.getClass());
                }
            }
        }
        return super.act();
    }

    @Override
    public void die(Object cause) {
        super.die(cause);
    }

    @Override
    protected synchronized void onRemove() {
        if (this.beingLifeLinked) {
            for (Buff buff : this.buffs()) {
                if (buff instanceof AllyBuff || buff instanceof ChampionEnemy || buff instanceof DwarfKing.KingDamager) continue;
                buff.detach();
            }
        } else {
            super.onRemove();
        }
    }

    private class Sleeping
    extends Mob.Sleeping {
        private Sleeping() {
        }

        @Override
        public boolean act(boolean enemyInFOV, boolean justAlerted) {
            Supression partner = (Supression)Actor.findById(Supression.this.partnerID);
            if (partner != null && partner.state != partner.SLEEPING) {
                Supression.this.state = Supression.this.WANDERING;
                Supression.this.target = partner.pos;
                return true;
            }
            return super.act(enemyInFOV, justAlerted);
        }
    }

    private class Wandering
    extends Mob.Wandering {
        private Wandering() {
        }

        @Override
        protected boolean continueWandering() {
            Supression.this.enemySeen = false;
            Supression partner = (Supression)Actor.findById(Supression.this.partnerID);
            if (partner != null && (partner.state != partner.WANDERING || Dungeon.level.distance(Supression.this.pos, partner.target) > 1)) {
                Supression.this.target = partner.pos;
                int oldPos = Supression.this.pos;
                if (Supression.this.getCloser(Supression.this.target)) {
                    Supression.this.spend(1.0f / Supression.this.speed());
                    return Supression.this.moveSprite(oldPos, Supression.this.pos);
                }
                Supression.this.spend(1.0f);
                return true;
            }
            return super.continueWandering();
        }
    }
}

