/*
 * Decompiled with CFR 0.152.
 */
package com.shatteredpixel.shatteredpixeldungeon.actors.mobs;

import com.shatteredpixel.shatteredpixeldungeon.Dungeon;
import com.shatteredpixel.shatteredpixeldungeon.actors.Char;
import com.shatteredpixel.shatteredpixeldungeon.actors.mobs.Mob;
import com.shatteredpixel.shatteredpixeldungeon.items.Item;
import com.shatteredpixel.shatteredpixeldungeon.items.spells.StableAPBullet;
import com.shatteredpixel.shatteredpixeldungeon.items.spells.StableHPBullet;
import com.shatteredpixel.shatteredpixeldungeon.messages.Messages;
import com.shatteredpixel.shatteredpixeldungeon.sprites.TankSprite;
import com.shatteredpixel.shatteredpixeldungeon.utils.GLog;
import com.watabou.noosa.audio.Sample;
import com.watabou.utils.Bundle;
import com.watabou.utils.Random;

public class Tank
extends Mob {
    private int cannonCooldown;
    private static final String CANNON_COOLDOWN = "cannon_cooldown";

    public Tank() {
        this.spriteClass = TankSprite.class;
        this.HT = 300;
        this.HP = 300;
        this.defenseSkill = 10;
        this.EXP = 20;
        this.maxLvl = 30;
        this.lootChance = 0.1f;
        this.properties.add(Char.Property.INORGANIC);
        this.properties.add(Char.Property.LARGE);
        this.HUNTING = new Hunting();
        this.cannonCooldown = 0;
    }

    @Override
    public void storeInBundle(Bundle bundle) {
        super.storeInBundle(bundle);
        bundle.put(CANNON_COOLDOWN, this.cannonCooldown);
    }

    @Override
    public void restoreFromBundle(Bundle bundle) {
        super.restoreFromBundle(bundle);
        this.cannonCooldown = bundle.getInt(CANNON_COOLDOWN);
    }

    @Override
    protected boolean act() {
        --this.cannonCooldown;
        return super.act();
    }

    @Override
    public void onAttackComplete() {
        Sample.INSTANCE.play("sounds/hit_crush.mp3", 1.5f, Random.Float(0.33f, 0.66f));
        super.onAttackComplete();
    }

    @Override
    public int damageRoll() {
        int dmg = Random.NormalIntRange(20, 40);
        if (this.enemy != null && !Dungeon.level.adjacent(this.pos, this.enemy.pos)) {
            dmg *= 2;
        }
        return dmg;
    }

    @Override
    public int attackSkill(Char target) {
        return 40;
    }

    @Override
    public int drRoll() {
        return Random.NormalIntRange(10, 50);
    }

    private void zap() {
        this.spend(1.0f);
        Sample.INSTANCE.play("sounds/hit_crush.mp3", 1.0f, Random.Float(0.33f, 0.66f));
        if (Tank.hit(this, this.enemy, true)) {
            if (this.enemy == Dungeon.hero && !this.enemy.isAlive()) {
                Dungeon.fail(this.getClass());
                GLog.n(Messages.get(this, "cannon_kill", new Object[0]), new Object[0]);
            }
        } else {
            this.enemy.sprite.showStatus(0xFFFF00, this.enemy.defenseVerb(), new Object[0]);
        }
    }

    @Override
    public Item createLoot() {
        return Random.oneOf(new StableAPBullet(), new StableHPBullet());
    }

    private class Hunting
    extends Mob.Hunting {
        private Hunting() {
        }

        @Override
        public boolean act(boolean enemyInFOV, boolean justAlerted) {
            if (!enemyInFOV || Tank.this.canAttack(Tank.this.enemy)) {
                return super.act(enemyInFOV, justAlerted);
            }
            Tank.this.enemySeen = true;
            Tank.this.target = Tank.this.enemy.pos;
            int oldPos = Tank.this.pos;
            if (Tank.this.cannonCooldown <= 0 && Tank.this.distance(Tank.this.enemy) >= 2 && Random.Int(100 / Tank.this.distance(Tank.this.enemy)) == 0) {
                if (Tank.this.sprite != null && (Tank.this.sprite.visible || Tank.this.enemy.sprite.visible)) {
                    Tank.this.sprite.zap(Tank.this.enemy.pos);
                    return false;
                }
                Tank.this.zap();
                return true;
            }
            if (Tank.this.getCloser(Tank.this.target)) {
                Tank.this.spend(1.0f / Tank.this.speed());
                return Tank.this.moveSprite(oldPos, Tank.this.pos);
            }
            Tank.this.spend(1.0f);
            return true;
        }
    }

    public static class Cannon {
    }
}

