/*
 * Decompiled with CFR 0.152.
 */
package com.shatteredpixel.shatteredpixeldungeon.items;

import com.shatteredpixel.shatteredpixeldungeon.Dungeon;
import com.shatteredpixel.shatteredpixeldungeon.actors.buffs.Buff;
import com.shatteredpixel.shatteredpixeldungeon.actors.buffs.GunEmpower;
import com.shatteredpixel.shatteredpixeldungeon.actors.hero.Hero;
import com.shatteredpixel.shatteredpixeldungeon.items.Item;
import com.shatteredpixel.shatteredpixeldungeon.messages.Messages;
import com.shatteredpixel.shatteredpixeldungeon.sprites.ItemSpriteSheet;
import com.shatteredpixel.shatteredpixeldungeon.utils.GLog;
import com.watabou.noosa.Image;
import com.watabou.utils.Bundle;
import java.text.DecimalFormat;
import java.util.ArrayList;

public class AmmoBelt
extends Item {
    private static final String AC_USE = "USE";

    public AmmoBelt() {
        this.image = ItemSpriteSheet.CARTRIDGE_BELT;
        this.defaultAction = AC_USE;
        this.usesTargeting = true;
        this.bones = false;
        this.unique = true;
    }

    @Override
    public ArrayList<String> actions(Hero hero) {
        ArrayList<String> actions = super.actions(hero);
        actions.add(AC_USE);
        return actions;
    }

    @Override
    public void execute(Hero hero, String action) {
        super.execute(hero, action);
        if (action.equals(AC_USE)) {
            curUser = hero;
            curItem = this;
            hero.busy();
            hero.sprite.operate(hero.pos);
            GLog.p(Messages.get(this, "empower", new Object[0]), new Object[0]);
            hero.spend(1.0f);
            GunEmpower buff = hero.buff(GunEmpower.class);
            if (buff != null) {
                Buff.affect(curUser, GunEmpower.class).levelUp();
            } else {
                Buff.affect(curUser, GunEmpower.class).reset(1, GunEmpower.DURATION);
            }
            OverHeat overHeat = hero.buff(OverHeat.class);
            if (buff != null) {
                Buff.affect(curUser, OverHeat.class).levelUp();
            } else {
                Buff.affect(curUser, OverHeat.class).reset(1, OverHeat.DURATION);
            }
            Item.updateQuickslot();
        }
    }

    @Override
    public boolean isUpgradable() {
        return false;
    }

    @Override
    public boolean isIdentified() {
        return true;
    }

    @Override
    public int value() {
        return -1;
    }

    public static class OverHeat
    extends Buff {
        public static float DURATION = 200.0f;
        private int heat;
        public static float chance;
        private float interval;
        private static final String HEAT = "heat";
        private static final String CHANCE = "chance";
        private static final String INTERVAL = "interval";

        public OverHeat() {
            this.type = Buff.buffType.POSITIVE;
        }

        public void reset(int heat, float interval) {
            this.heat = heat;
            this.interval = interval;
            switch (heat) {
                default: {
                    chance = 0.01f;
                    break;
                }
                case 2: {
                    chance = 0.1f;
                    break;
                }
                case 3: {
                    chance = 0.33333334f;
                    break;
                }
                case 4: {
                    chance = 0.5f;
                    break;
                }
                case 5: {
                    chance = 0.75f;
                    break;
                }
                case 6: {
                    chance = 0.9f;
                }
            }
            this.spend(interval - this.cooldown());
        }

        public void levelUp() {
            if (Math.ceil((float)Dungeon.hero.lvl / 5.0f) > (double)this.heat) {
                ++this.heat;
            }
            this.interval = DURATION;
            switch (this.heat) {
                default: {
                    chance = 0.01f;
                    break;
                }
                case 2: {
                    chance = 0.1f;
                    break;
                }
                case 3: {
                    chance = 0.33333334f;
                    break;
                }
                case 4: {
                    chance = 0.5f;
                    break;
                }
                case 5: {
                    chance = 0.75f;
                    break;
                }
                case 6: {
                    chance = 0.9f;
                }
            }
            this.spend(this.interval - this.cooldown());
        }

        public int boost() {
            return this.heat;
        }

        @Override
        public boolean act() {
            --this.heat;
            if (this.heat > 0) {
                this.spend(this.interval);
            } else {
                this.detach();
            }
            switch (this.heat) {
                default: {
                    chance = 0.01f;
                    break;
                }
                case 2: {
                    chance = 0.1f;
                    break;
                }
                case 3: {
                    chance = 0.33333334f;
                    break;
                }
                case 4: {
                    chance = 0.5f;
                    break;
                }
                case 5: {
                    chance = 0.75f;
                    break;
                }
                case 6: {
                    chance = 0.9f;
                }
            }
            Item.updateQuickslot();
            return true;
        }

        @Override
        public int icon() {
            return 7;
        }

        @Override
        public void tintIcon(Image icon) {
            icon.hardlight(1.0f, 0.0f, 0.0f);
        }

        @Override
        public float iconFadePercent() {
            return Math.max(0.0f, (DURATION - this.visualcooldown()) / DURATION);
        }

        @Override
        public String iconTextDisplay() {
            return Integer.toString((int)this.visualcooldown());
        }

        public String toString() {
            return Messages.get(this, "name", new Object[0]);
        }

        @Override
        public String desc() {
            return Messages.get(this, "desc", this.heat, new DecimalFormat("#.#").format(chance * 100.0f), this.dispTurns(this.visualcooldown()));
        }

        @Override
        public void storeInBundle(Bundle bundle) {
            super.storeInBundle(bundle);
            bundle.put(HEAT, this.heat);
            bundle.put(CHANCE, chance);
            bundle.put(INTERVAL, this.interval);
        }

        @Override
        public void restoreFromBundle(Bundle bundle) {
            super.restoreFromBundle(bundle);
            this.heat = bundle.getInt(HEAT);
            chance = bundle.getFloat(CHANCE);
            this.interval = bundle.getFloat(INTERVAL);
        }
    }
}

