/*
 * Decompiled with CFR 0.152.
 */
package com.shatteredpixel.shatteredpixeldungeon.items;

import com.shatteredpixel.shatteredpixeldungeon.Dungeon;
import com.shatteredpixel.shatteredpixeldungeon.actors.buffs.Barrier;
import com.shatteredpixel.shatteredpixeldungeon.actors.buffs.Buff;
import com.shatteredpixel.shatteredpixeldungeon.actors.hero.Hero;
import com.shatteredpixel.shatteredpixeldungeon.actors.hero.Talent;
import com.shatteredpixel.shatteredpixeldungeon.effects.Speck;
import com.shatteredpixel.shatteredpixeldungeon.items.Item;
import com.shatteredpixel.shatteredpixeldungeon.items.Waterskin;
import com.shatteredpixel.shatteredpixeldungeon.messages.Messages;
import com.shatteredpixel.shatteredpixeldungeon.scenes.GameScene;
import com.shatteredpixel.shatteredpixeldungeon.sprites.ItemSpriteSheet;
import com.shatteredpixel.shatteredpixeldungeon.utils.GLog;
import com.watabou.noosa.audio.Sample;

public class Dewdrop
extends Item {
    public Dewdrop() {
        this.image = ItemSpriteSheet.DEWDROP;
        this.stackable = true;
        this.dropsDownHeap = true;
    }

    @Override
    public boolean doPickUp(Hero hero, int pos) {
        Waterskin flask = hero.belongings.getItem(Waterskin.class);
        if (flask != null && !flask.isFull()) {
            flask.collectDew(this);
            GameScene.pickUp(this, pos);
        } else {
            int terr = Dungeon.level.map[pos];
            if (!Dewdrop.consumeDew(1, hero, terr == 7 || terr == 8 || terr == 22)) {
                return false;
            }
        }
        Sample.INSTANCE.play("sounds/dewdrop.mp3");
        hero.spendAndNext(1.0f);
        return true;
    }

    public static boolean consumeDew(int quantity, Hero hero, boolean force) {
        int heal = Math.round((float)hero.HT * 0.05f * (float)quantity);
        int effect = Math.min(hero.HT - hero.HP, heal);
        int shield = 0;
        if (hero.hasTalent(Talent.SHIELDING_DEW)) {
            shield = heal - effect;
            int maxShield = Math.round((float)hero.HT * 0.2f * (float)hero.pointsInTalent(Talent.SHIELDING_DEW));
            int curShield = 0;
            if (hero.buff(Barrier.class) != null) {
                curShield = hero.buff(Barrier.class).shielding();
            }
            shield = Math.min(shield, maxShield - curShield);
        }
        if (effect > 0 || shield > 0) {
            hero.HP += effect;
            if (shield > 0) {
                Buff.affect(hero, Barrier.class).incShield(shield);
            }
            hero.sprite.emitter().burst(Speck.factory(0), 1);
            if (effect > 0 && shield > 0) {
                hero.sprite.showStatus(65280, Messages.get(Dewdrop.class, "both", effect, shield), new Object[0]);
            } else if (effect > 0) {
                hero.sprite.showStatus(65280, Messages.get(Dewdrop.class, "heal", effect), new Object[0]);
            } else {
                hero.sprite.showStatus(65280, Messages.get(Dewdrop.class, "shield", shield), new Object[0]);
            }
        } else if (!force) {
            GLog.i(Messages.get(Dewdrop.class, "already_full", new Object[0]), new Object[0]);
            return false;
        }
        return true;
    }

    @Override
    public boolean isUpgradable() {
        return false;
    }

    @Override
    public boolean isIdentified() {
        return true;
    }

    @Override
    public Item merge(Item other) {
        if (this.isSimilar(other)) {
            this.quantity = 1;
            other.quantity = 0;
        }
        return this;
    }

    @Override
    public Item quantity(int value) {
        this.quantity = Math.min(value, 1);
        return this;
    }
}

