/*
 * Decompiled with CFR 0.152.
 */
package com.shatteredpixel.shatteredpixeldungeon.items;

import com.shatteredpixel.shatteredpixeldungeon.Dungeon;
import com.shatteredpixel.shatteredpixeldungeon.actors.Actor;
import com.shatteredpixel.shatteredpixeldungeon.actors.Char;
import com.shatteredpixel.shatteredpixeldungeon.actors.buffs.Buff;
import com.shatteredpixel.shatteredpixeldungeon.actors.buffs.Charm;
import com.shatteredpixel.shatteredpixeldungeon.actors.buffs.HealingArea;
import com.shatteredpixel.shatteredpixeldungeon.actors.buffs.Poison;
import com.shatteredpixel.shatteredpixeldungeon.actors.hero.Hero;
import com.shatteredpixel.shatteredpixeldungeon.actors.hero.HeroSubClass;
import com.shatteredpixel.shatteredpixeldungeon.actors.hero.Talent;
import com.shatteredpixel.shatteredpixeldungeon.effects.Beam;
import com.shatteredpixel.shatteredpixeldungeon.effects.CellEmitter;
import com.shatteredpixel.shatteredpixeldungeon.effects.Speck;
import com.shatteredpixel.shatteredpixeldungeon.effects.particles.PoisonParticle;
import com.shatteredpixel.shatteredpixeldungeon.items.Item;
import com.shatteredpixel.shatteredpixeldungeon.items.weapon.SpiritBow;
import com.shatteredpixel.shatteredpixeldungeon.mechanics.Ballistica;
import com.shatteredpixel.shatteredpixeldungeon.messages.Messages;
import com.shatteredpixel.shatteredpixeldungeon.scenes.CellSelector;
import com.shatteredpixel.shatteredpixeldungeon.scenes.GameScene;
import com.shatteredpixel.shatteredpixeldungeon.sprites.ItemSpriteSheet;
import com.shatteredpixel.shatteredpixeldungeon.tiles.DungeonTilemap;
import com.shatteredpixel.shatteredpixeldungeon.ui.BuffIndicator;
import com.watabou.utils.Bundle;
import com.watabou.utils.Random;
import java.util.ArrayList;

public class GammaRayGun
extends Item {
    private static final String AC_SHOOT = "SHOOT";
    private CellSelector.Listener shooter;

    public GammaRayGun() {
        this.image = ItemSpriteSheet.GAMMA_RAY_GUN;
        this.defaultAction = AC_SHOOT;
        this.usesTargeting = true;
        this.bones = false;
        this.unique = true;
        this.shooter = new CellSelector.Listener(){

            @Override
            public void onSelect(Integer target) {
                if (target != null) {
                    if (target == Item.curUser.pos) {
                        Buff.affect(Item.curUser, HealingArea.class).setup(Item.curUser.pos, Math.round((float)Item.curUser.HT * 0.3f), 1, true);
                        Dungeon.hero.sprite.operate(Item.curUser.pos);
                    } else {
                        Ballistica beam = new Ballistica(Item.curUser.pos, target, 7);
                        Char ch = Actor.findChar(beam.collisionPos);
                        if (ch != null) {
                            if (ch.alignment == Char.Alignment.ENEMY) {
                                if (Dungeon.hero.subClass == HeroSubClass.ANGEL) {
                                    Buff.affect((Char)ch, Charm.class, (float)5.0f).object = Item.curUser.id();
                                    ch.sprite.centerEmitter().start(Speck.factory(11), 0.2f, 3);
                                } else {
                                    Buff.affect(ch, Poison.class).set(3 + Math.round((float)(2 * Dungeon.depth) / 3.0f));
                                    if (Dungeon.level.heroFOV[ch.pos]) {
                                        CellEmitter.center(ch.pos).burst(PoisonParticle.SPLASH, 3);
                                    }
                                }
                            }
                            if (ch.alignment == Char.Alignment.ALLY && ch != Item.curUser) {
                                int healAmt = 5 + Math.round((float)Item.curUser.lvl / 2.0f);
                                if (Dungeon.hero.hasTalent(Talent.HIGHER_HEAL)) {
                                    healAmt = (int)((double)healAmt * Math.pow(1.15f, Dungeon.hero.pointsInTalent(Talent.HIGHER_HEAL)));
                                }
                                ch.heal(healAmt);
                            }
                        }
                        Item.curUser.sprite.zap(target);
                        Item.curUser.sprite.parent.add(new Beam.GreenRay(Item.curUser.sprite.center(), DungeonTilemap.raisedTileCenterToWorld(beam.collisionPos)));
                    }
                    if (Item.curUser.buff(GammaRayCooldown.class) != null) {
                        if (Item.curUser.buff(Poison.class) != null) {
                            Buff.affect(Item.curUser, Poison.class).extend(5 + Math.round((float)Item.curUser.lvl / 2.0f));
                        } else {
                            Buff.affect(Item.curUser, Poison.class).set(5 + Math.round((float)Item.curUser.lvl / 2.0f));
                        }
                        BuffIndicator.refreshHero();
                        CellEmitter.center(Item.curUser.pos).burst(PoisonParticle.SPLASH, 3);
                    }
                    if (Random.Int(3) == 0) {
                        Buff.affect(Dungeon.hero, GammaRayCooldown.class).set(Random.NormalIntRange(3, 5));
                    }
                    Dungeon.hero.spendAndNext(1.0f);
                }
            }

            @Override
            public String prompt() {
                return Messages.get(SpiritBow.class, "prompt", new Object[0]);
            }
        };
    }

    @Override
    public ArrayList<String> actions(Hero hero) {
        ArrayList<String> actions = super.actions(hero);
        actions.add(AC_SHOOT);
        return actions;
    }

    @Override
    public void execute(Hero hero, String action) {
        super.execute(hero, action);
        if (action.equals(AC_SHOOT)) {
            this.usesTargeting = true;
            curUser = hero;
            curItem = this;
            GameScene.selectCell(this.shooter);
        }
    }

    @Override
    public boolean isUpgradable() {
        return false;
    }

    @Override
    public boolean isIdentified() {
        return true;
    }

    @Override
    public int value() {
        return -1;
    }

    public static class GammaRayCooldown
    extends Buff {
        int duration;
        private static final String DURATION = "duration";

        public GammaRayCooldown() {
            this.type = Buff.buffType.NEUTRAL;
        }

        public void set(int time) {
            this.duration = time;
        }

        @Override
        public boolean act() {
            this.duration = (int)((float)this.duration - 1.0f);
            this.spend(1.0f);
            if (this.duration <= 0) {
                this.detach();
            }
            return true;
        }

        @Override
        public void storeInBundle(Bundle bundle) {
            super.storeInBundle(bundle);
            bundle.put(DURATION, this.duration);
        }

        @Override
        public void restoreFromBundle(Bundle bundle) {
            super.restoreFromBundle(bundle);
            this.duration = bundle.getInt(DURATION);
        }
    }
}

