/*
 * Decompiled with CFR 0.152.
 */
package com.shatteredpixel.shatteredpixeldungeon.items;

import com.shatteredpixel.shatteredpixeldungeon.Dungeon;
import com.shatteredpixel.shatteredpixeldungeon.actors.Actor;
import com.shatteredpixel.shatteredpixeldungeon.actors.buffs.Barkskin;
import com.shatteredpixel.shatteredpixeldungeon.actors.buffs.Buff;
import com.shatteredpixel.shatteredpixeldungeon.actors.buffs.EvasiveMove;
import com.shatteredpixel.shatteredpixeldungeon.actors.buffs.FlavourBuff;
import com.shatteredpixel.shatteredpixeldungeon.actors.buffs.Haste;
import com.shatteredpixel.shatteredpixeldungeon.actors.buffs.PrismaticGuard;
import com.shatteredpixel.shatteredpixeldungeon.actors.hero.Hero;
import com.shatteredpixel.shatteredpixeldungeon.actors.mobs.Mob;
import com.shatteredpixel.shatteredpixeldungeon.actors.mobs.npcs.MirrorImage;
import com.shatteredpixel.shatteredpixeldungeon.actors.mobs.npcs.PrismaticImage;
import com.shatteredpixel.shatteredpixeldungeon.effects.Speck;
import com.shatteredpixel.shatteredpixeldungeon.items.Item;
import com.shatteredpixel.shatteredpixeldungeon.items.scrolls.ScrollOfTeleportation;
import com.shatteredpixel.shatteredpixeldungeon.messages.Messages;
import com.shatteredpixel.shatteredpixeldungeon.scenes.GameScene;
import com.shatteredpixel.shatteredpixeldungeon.sprites.ItemSpriteSheet;
import com.shatteredpixel.shatteredpixeldungeon.utils.GLog;
import com.watabou.noosa.Image;
import com.watabou.noosa.audio.Sample;
import com.watabou.utils.PathFinder;
import com.watabou.utils.Random;
import java.util.ArrayList;

public class HandMirror
extends Item {
    private static final String AC_USE = "USE";

    public HandMirror() {
        this.image = ItemSpriteSheet.HAND_MIRROR;
        this.defaultAction = AC_USE;
        this.usesTargeting = false;
        this.bones = false;
        this.unique = true;
    }

    @Override
    public ArrayList<String> actions(Hero hero) {
        ArrayList<String> actions = super.actions(hero);
        actions.add(AC_USE);
        return actions;
    }

    @Override
    public void execute(Hero hero, String action) {
        super.execute(hero, action);
        if (action.equals(AC_USE)) {
            curUser = hero;
            curItem = this;
            if (hero.buff(HandMirrorCooldown.class) != null) {
                GLog.w(Messages.get(this, "cooldown", new Object[0]), new Object[0]);
            } else {
                boolean found = false;
                for (Mob m : Dungeon.level.mobs.toArray(new Mob[0])) {
                    if (!(m instanceof PrismaticImage)) continue;
                    found = true;
                    m.HP = Math.min(m.HP + m.HT / 10, m.HT);
                    m.sprite.emitter().burst(Speck.factory(0), 2);
                }
                if (!found) {
                    PrismaticGuard pg = hero.buff(PrismaticGuard.class);
                    if (pg != null) {
                        if (pg.HP() == pg.maxHP()) {
                            this.spawnImages(curUser, 1);
                        } else {
                            int healAmt = pg.maxHP() / 10;
                            healAmt = Math.min(healAmt, pg.maxHP() - pg.HP());
                            Buff.affect(hero, PrismaticGuard.class).extend(healAmt);
                        }
                    } else {
                        Buff.affect(hero, PrismaticGuard.class).set((10 + (int)Math.floor((float)hero.lvl * 2.5f)) / 10);
                    }
                }
                HandMirror.curUser.sprite.operate(HandMirror.curUser.pos);
                Sample.INSTANCE.play("sounds/teleport.mp3");
                curUser.spendAndNext(1.0f);
                Buff.affect(curUser, HandMirrorCooldown.class, 100.0f);
            }
        }
    }

    public void spawnImages(Hero hero, int nImages) {
        ArrayList<Integer> respawnPoints = new ArrayList<Integer>();
        for (int i = 0; i < PathFinder.NEIGHBOURS8.length; ++i) {
            int p = hero.pos + PathFinder.NEIGHBOURS8[i];
            if (Actor.findChar(p) != null || !Dungeon.level.passable[p]) continue;
            respawnPoints.add(p);
        }
        while (nImages > 0 && respawnPoints.size() > 0) {
            int index = Random.index(respawnPoints);
            MirrorImage mob = new MirrorImage();
            mob.duplicate(hero);
            Buff.affect(mob, EvasiveMove.class, this.buffedLvl() >= 10 ? 4.0f : 3.0f);
            Buff.affect(mob, Haste.class, this.buffedLvl() >= 10 ? 4.0f : 3.0f);
            if (this.buffedLvl() >= 10) {
                Buff.affect(mob, Barkskin.class).set(this.buffedLvl(), 1);
            }
            GameScene.add(mob);
            ScrollOfTeleportation.appear(mob, (Integer)respawnPoints.get(index));
            respawnPoints.remove(index);
            --nImages;
        }
    }

    @Override
    public boolean isUpgradable() {
        return false;
    }

    @Override
    public boolean isIdentified() {
        return true;
    }

    @Override
    public int value() {
        return -1;
    }

    public static class HandMirrorCooldown
    extends FlavourBuff {
        public static final float DURATION = 100.0f;

        public HandMirrorCooldown() {
            this.type = Buff.buffType.NEUTRAL;
            this.announced = false;
        }

        @Override
        public int icon() {
            return 7;
        }

        @Override
        public void tintIcon(Image icon) {
            icon.hardlight(14679872);
        }

        @Override
        public float iconFadePercent() {
            return Math.max(0.0f, (100.0f - this.visualcooldown()) / 100.0f);
        }

        public String toString() {
            return Messages.get(this, "name", new Object[0]);
        }

        @Override
        public String desc() {
            return Messages.get(this, "desc", this.dispTurns());
        }
    }
}

