/*
 * Decompiled with CFR 0.152.
 */
package com.shatteredpixel.shatteredpixeldungeon.items;

import com.shatteredpixel.shatteredpixeldungeon.actors.buffs.Barrier;
import com.shatteredpixel.shatteredpixeldungeon.actors.buffs.Buff;
import com.shatteredpixel.shatteredpixeldungeon.actors.buffs.KnightsBlocking;
import com.shatteredpixel.shatteredpixeldungeon.actors.buffs.ParalysisTracker;
import com.shatteredpixel.shatteredpixeldungeon.actors.buffs.ShieldCoolDown;
import com.shatteredpixel.shatteredpixeldungeon.actors.hero.Hero;
import com.shatteredpixel.shatteredpixeldungeon.actors.hero.Talent;
import com.shatteredpixel.shatteredpixeldungeon.items.Item;
import com.shatteredpixel.shatteredpixeldungeon.messages.Messages;
import com.shatteredpixel.shatteredpixeldungeon.sprites.ItemSpriteSheet;
import com.shatteredpixel.shatteredpixeldungeon.utils.GLog;
import com.watabou.noosa.audio.Sample;
import com.watabou.utils.Random;
import java.util.ArrayList;

public class KnightsShield
extends Item {
    private static final String AC_SHIELD = "SHIELD";

    public KnightsShield() {
        this.image = ItemSpriteSheet.KNIGHT_SHIELD;
        this.defaultAction = AC_SHIELD;
        this.bones = false;
        this.unique = true;
    }

    @Override
    public ArrayList<String> actions(Hero hero) {
        ArrayList<String> actions = super.actions(hero);
        actions.add(AC_SHIELD);
        return actions;
    }

    @Override
    public void execute(Hero hero, String action) {
        super.execute(hero, action);
        if (action.equals(AC_SHIELD)) {
            if (hero.buff(ShieldCoolDown.class) != null) {
                GLog.w(Messages.get(this, "cooldown", new Object[0]), new Object[0]);
            } else if (hero.belongings.armor == null) {
                GLog.w(Messages.get(this, "no_armor", new Object[0]), new Object[0]);
            } else {
                int blocking = 5 + hero.lvl / 2 + hero.belongings.armor.buffedLvl();
                if (hero.hasTalent(Talent.FAITH)) {
                    blocking += 2 + 3 * hero.pointsInTalent(Talent.FAITH);
                }
                int interval = (int)Math.ceil((float)hero.lvl / 6.0f);
                hero.sprite.operate(hero.pos);
                hero.spendAndNext(1.0f);
                Sample.INSTANCE.play("sounds/miss.mp3");
                Buff.affect(hero, KnightsBlocking.class).set(blocking, interval, blocking);
                Buff.affect(hero, ShieldCoolDown.class).set();
                if (hero.hasTalent(Talent.IMPREGNABLE_WALL)) {
                    Buff.affect(hero, Barrier.class).setShield(Math.round((float)(hero.lvl + hero.belongings.armor.buffedLvl()) / 3.0f * (float)hero.pointsInTalent(Talent.IMPREGNABLE_WALL)));
                }
                if (hero.hasTalent(Talent.SHIELD_SLAM) && Random.Int(3) < hero.pointsInTalent(Talent.SHIELD_SLAM)) {
                    Buff.affect(hero, ParalysisTracker.class);
                }
                GLog.p(Messages.get(this, "shield", new Object[0]), new Object[0]);
            }
        }
    }

    @Override
    public boolean isUpgradable() {
        return false;
    }

    @Override
    public boolean isIdentified() {
        return true;
    }

    @Override
    public int value() {
        return -1;
    }
}

