/*
 * Decompiled with CFR 0.152.
 */
package com.shatteredpixel.shatteredpixeldungeon.items;

import com.shatteredpixel.shatteredpixeldungeon.Dungeon;
import com.shatteredpixel.shatteredpixeldungeon.actors.buffs.Buff;
import com.shatteredpixel.shatteredpixeldungeon.actors.buffs.FlavourBuff;
import com.shatteredpixel.shatteredpixeldungeon.actors.hero.Hero;
import com.shatteredpixel.shatteredpixeldungeon.effects.particles.SparkParticle;
import com.shatteredpixel.shatteredpixeldungeon.items.Item;
import com.shatteredpixel.shatteredpixeldungeon.items.StunGun;
import com.shatteredpixel.shatteredpixeldungeon.messages.Messages;
import com.shatteredpixel.shatteredpixeldungeon.sprites.ItemSpriteSheet;
import com.shatteredpixel.shatteredpixeldungeon.utils.GLog;
import com.watabou.noosa.audio.Sample;
import java.util.ArrayList;

public class StunGunAP
extends Item {
    private static final String AC_USE = "USE";

    public StunGunAP() {
        this.image = ItemSpriteSheet.STUN_GUN_AP;
        this.defaultAction = AC_USE;
        this.usesTargeting = false;
        this.bones = false;
        this.unique = true;
    }

    @Override
    public ArrayList<String> actions(Hero hero) {
        ArrayList<String> actions = super.actions(hero);
        actions.add(AC_USE);
        return actions;
    }

    @Override
    public void execute(Hero hero, String action) {
        super.execute(hero, action);
        if (action.equals(AC_USE)) {
            if (hero.buff(StunGun.StunGunCooldown.class) == null) {
                Buff.affect(curUser, ShockingTracker.class, Dungeon.hero.lvl == 30 ? 12.0f : (float)(5 + Dungeon.hero.lvl / 5));
                Buff.affect(curUser, StunGun.StunGunCooldown.class, 150.0f);
                GLog.p(Messages.get(StunGun.class, "stun", new Object[0]), new Object[0]);
                StunGunAP.curUser.sprite.operate(StunGunAP.curUser.pos);
                curUser.spendAndNext(1.0f);
                StunGunAP.curUser.sprite.centerEmitter().burst(SparkParticle.FACTORY, 3);
                Sample.INSTANCE.play("sounds/lightning.mp3");
            } else {
                GLog.w(Messages.get(StunGun.class, "cooldown", new Object[0]), new Object[0]);
            }
        }
    }

    @Override
    public boolean isUpgradable() {
        return false;
    }

    @Override
    public boolean isIdentified() {
        return true;
    }

    @Override
    public int value() {
        return -1;
    }

    @Override
    public String info() {
        return Messages.get(this, "desc", Dungeon.hero.lvl == 30 ? 12 : 5 + Dungeon.hero.lvl / 5);
    }

    public static class ShockingTracker
    extends FlavourBuff {
        public static final float DURATION = 10.0f;

        public ShockingTracker() {
            this.type = Buff.buffType.POSITIVE;
            this.announced = true;
        }

        @Override
        public int icon() {
            return 147;
        }

        @Override
        public float iconFadePercent() {
            return Math.max(0.0f, (10.0f - this.visualcooldown()) / 10.0f);
        }

        public String toString() {
            return Messages.get(this, "name", new Object[0]);
        }

        @Override
        public String desc() {
            return Messages.get(this, "desc", this.dispTurns());
        }
    }
}

