/*
 * Decompiled with CFR 0.152.
 */
package com.shatteredpixel.shatteredpixeldungeon.items;

import com.shatteredpixel.shatteredpixeldungeon.Dungeon;
import com.shatteredpixel.shatteredpixeldungeon.actors.buffs.AdrenalineSurge;
import com.shatteredpixel.shatteredpixeldungeon.actors.buffs.Barkskin;
import com.shatteredpixel.shatteredpixeldungeon.actors.buffs.Barrier;
import com.shatteredpixel.shatteredpixeldungeon.actors.buffs.Bless;
import com.shatteredpixel.shatteredpixeldungeon.actors.buffs.BlobImmunity;
import com.shatteredpixel.shatteredpixeldungeon.actors.buffs.Buff;
import com.shatteredpixel.shatteredpixeldungeon.actors.buffs.FireImbue;
import com.shatteredpixel.shatteredpixeldungeon.actors.buffs.FrostImbue;
import com.shatteredpixel.shatteredpixeldungeon.actors.buffs.Haste;
import com.shatteredpixel.shatteredpixeldungeon.actors.buffs.Healing;
import com.shatteredpixel.shatteredpixeldungeon.actors.buffs.Invisibility;
import com.shatteredpixel.shatteredpixeldungeon.actors.buffs.Levitation;
import com.shatteredpixel.shatteredpixeldungeon.actors.buffs.MindVision;
import com.shatteredpixel.shatteredpixeldungeon.actors.buffs.ToxicImbue;
import com.shatteredpixel.shatteredpixeldungeon.actors.hero.Hero;
import com.shatteredpixel.shatteredpixeldungeon.actors.hero.Talent;
import com.shatteredpixel.shatteredpixeldungeon.items.Dewdrop;
import com.shatteredpixel.shatteredpixeldungeon.items.Item;
import com.shatteredpixel.shatteredpixeldungeon.items.bags.Bag;
import com.shatteredpixel.shatteredpixeldungeon.items.bags.VelvetPouch;
import com.shatteredpixel.shatteredpixeldungeon.messages.Messages;
import com.shatteredpixel.shatteredpixeldungeon.plants.Blindweed;
import com.shatteredpixel.shatteredpixeldungeon.plants.Earthroot;
import com.shatteredpixel.shatteredpixeldungeon.plants.Fadeleaf;
import com.shatteredpixel.shatteredpixeldungeon.plants.Firebloom;
import com.shatteredpixel.shatteredpixeldungeon.plants.Icecap;
import com.shatteredpixel.shatteredpixeldungeon.plants.Mageroyal;
import com.shatteredpixel.shatteredpixeldungeon.plants.Plant;
import com.shatteredpixel.shatteredpixeldungeon.plants.Rotberry;
import com.shatteredpixel.shatteredpixeldungeon.plants.Sorrowmoss;
import com.shatteredpixel.shatteredpixeldungeon.plants.Starflower;
import com.shatteredpixel.shatteredpixeldungeon.plants.Stormvine;
import com.shatteredpixel.shatteredpixeldungeon.plants.Sungrass;
import com.shatteredpixel.shatteredpixeldungeon.plants.Swiftthistle;
import com.shatteredpixel.shatteredpixeldungeon.scenes.GameScene;
import com.shatteredpixel.shatteredpixeldungeon.sprites.ItemSpriteSheet;
import com.shatteredpixel.shatteredpixeldungeon.utils.GLog;
import com.shatteredpixel.shatteredpixeldungeon.windows.WndBag;
import com.watabou.noosa.audio.Sample;
import com.watabou.utils.Bundle;
import com.watabou.utils.GameMath;
import com.watabou.utils.Random;
import java.util.ArrayList;

public class Waterskin
extends Item {
    private static final int MAX_VOLUME = 20;
    private static final String AC_DRINK = "DRINK";
    private static final float TIME_TO_DRINK = 1.0f;
    private static final String TXT_STATUS = "%d/%d";
    private int volume;
    private static final String VOLUME = "volume";
    protected WndBag.ItemSelector itemSelector;

    public Waterskin() {
        this.image = ItemSpriteSheet.WATERSKIN;
        this.defaultAction = AC_DRINK;
        this.unique = true;
        this.volume = 0;
        this.itemSelector = new WndBag.ItemSelector(){

            @Override
            public String textPrompt() {
                return Messages.get(Waterskin.class, "seed", new Object[0]);
            }

            @Override
            public Class<? extends Bag> preferredBag() {
                return VelvetPouch.class;
            }

            @Override
            public boolean itemSelectable(Item item) {
                return Waterskin.this.canUseSeed(item);
            }

            @Override
            public void onSelect(Item item) {
                boolean isMastered;
                boolean bl = isMastered = Dungeon.hero.pointsInTalent(Talent.HERBAL_DEW) == 2;
                if (item != null && item instanceof Plant.Seed) {
                    if (item instanceof Blindweed.Seed) {
                        Buff.affect(Item.curUser, Invisibility.class, Waterskin.this.volume * 2);
                        if (!isMastered || Random.Int(2) >= 1) {
                            item.detach(Dungeon.hero.belongings.backpack);
                        }
                    }
                    if (item instanceof Earthroot.Seed) {
                        Buff.affect(Item.curUser, Barkskin.class).set(Math.round((float)(Dungeon.hero.lvl * Waterskin.this.volume) / 20.0f + (float)(Dungeon.depth * Waterskin.this.volume) / 4.0f), 1);
                        if (!isMastered || Random.Int(2) >= 1) {
                            item.detach(Dungeon.hero.belongings.backpack);
                        }
                    }
                    if (item instanceof Fadeleaf.Seed) {
                        Buff.affect(Item.curUser, MindVision.class, Waterskin.this.volume);
                        if (!isMastered || Random.Int(2) >= 1) {
                            item.detach(Dungeon.hero.belongings.backpack);
                        }
                    }
                    if (item instanceof Firebloom.Seed) {
                        Buff.affect(Item.curUser, FireImbue.class).set((float)Waterskin.this.volume / 4.0f);
                        if (!isMastered || Random.Int(2) >= 1) {
                            item.detach(Dungeon.hero.belongings.backpack);
                        }
                    }
                    if (item instanceof Icecap.Seed) {
                        Buff.affect(Item.curUser, FrostImbue.class, Math.round((float)Waterskin.this.volume / 2.0f));
                        if (!isMastered || Random.Int(2) >= 1) {
                            item.detach(Dungeon.hero.belongings.backpack);
                        }
                    }
                    if (item instanceof Mageroyal.Seed) {
                        Buff.affect(Item.curUser, BlobImmunity.class, Waterskin.this.volume * 2);
                        if (!isMastered || Random.Int(2) >= 1) {
                            item.detach(Dungeon.hero.belongings.backpack);
                        }
                    }
                    if (item instanceof Rotberry.Seed) {
                        Buff.affect(Item.curUser, AdrenalineSurge.class).reset(1, AdrenalineSurge.DURATION / 20.0f * (float)Waterskin.this.volume);
                    }
                    if (item instanceof Sorrowmoss.Seed) {
                        Buff.affect(Item.curUser, ToxicImbue.class).set((float)Waterskin.this.volume / 2.0f);
                        if (!isMastered || Random.Int(2) >= 1) {
                            item.detach(Dungeon.hero.belongings.backpack);
                        }
                    }
                    if (item instanceof Starflower.Seed) {
                        Buff.affect(Item.curUser, Bless.class, Waterskin.this.volume * 3);
                        if (!isMastered || Random.Int(2) >= 1) {
                            item.detach(Dungeon.hero.belongings.backpack);
                        }
                    }
                    if (item instanceof Stormvine.Seed) {
                        Buff.affect(Item.curUser, Levitation.class, Waterskin.this.volume * 2);
                        if (!isMastered || Random.Int(2) >= 1) {
                            item.detach(Dungeon.hero.belongings.backpack);
                        }
                    }
                    if (item instanceof Sungrass.Seed) {
                        Buff.affect(Item.curUser, Healing.class).setHeal(Dungeon.hero.HT / 10 * Waterskin.this.volume, 0.0f, 1);
                        if (!isMastered || Random.Int(2) >= 1) {
                            item.detach(Dungeon.hero.belongings.backpack);
                        }
                    }
                    if (item instanceof Swiftthistle.Seed) {
                        Buff.affect(Item.curUser, Haste.class, Waterskin.this.volume * 2);
                        if (!isMastered || Random.Int(2) >= 1) {
                            item.detach(Dungeon.hero.belongings.backpack);
                        }
                    }
                    Waterskin.this.use();
                }
            }
        };
    }

    @Override
    public void storeInBundle(Bundle bundle) {
        super.storeInBundle(bundle);
        bundle.put(VOLUME, this.volume);
    }

    @Override
    public void restoreFromBundle(Bundle bundle) {
        super.restoreFromBundle(bundle);
        this.volume = bundle.getInt(VOLUME);
    }

    @Override
    public ArrayList<String> actions(Hero hero) {
        ArrayList<String> actions = super.actions(hero);
        if (this.volume > 0) {
            actions.add(AC_DRINK);
        }
        return actions;
    }

    @Override
    public void execute(Hero hero, String action) {
        super.execute(hero, action);
        if (action.equals(AC_DRINK)) {
            if (this.volume > 0) {
                if (hero.hasTalent(Talent.HERBAL_DEW)) {
                    GameScene.selectItem(this.itemSelector);
                } else {
                    this.use();
                }
            } else {
                GLog.w(Messages.get(this, "empty", new Object[0]), new Object[0]);
            }
        }
    }

    @Override
    public void use() {
        float missingHealthPercent = 1.0f - (float)Dungeon.hero.HP / (float)Dungeon.hero.HT;
        int curShield = 0;
        if (Dungeon.hero.buff(Barrier.class) != null) {
            curShield = Dungeon.hero.buff(Barrier.class).shielding();
        }
        int maxShield = Math.round((float)Dungeon.hero.HT * 0.2f * (float)Dungeon.hero.pointsInTalent(Talent.SHIELDING_DEW));
        if (Dungeon.hero.hasTalent(Talent.SHIELDING_DEW)) {
            float missingShieldPercent = 1.0f - (float)curShield / (float)maxShield;
            if ((missingShieldPercent *= 0.2f * (float)Dungeon.hero.pointsInTalent(Talent.SHIELDING_DEW)) > 0.0f) {
                missingHealthPercent += missingShieldPercent;
            }
        }
        int dropsNeeded = (int)Math.ceil(missingHealthPercent / 0.05f - 0.01f);
        if (Dewdrop.consumeDew(dropsNeeded = (int)GameMath.gate(1.0f, dropsNeeded, this.volume), Dungeon.hero, true)) {
            this.volume -= dropsNeeded;
            Dungeon.hero.spend(1.0f);
            Dungeon.hero.busy();
            Sample.INSTANCE.play("sounds/drink.mp3");
            Dungeon.hero.sprite.operate(Dungeon.hero.pos);
            Waterskin.updateQuickslot();
        }
    }

    public boolean canUseSeed(Item item) {
        return item instanceof Plant.Seed;
    }

    @Override
    public String info() {
        String info = this.desc();
        info = this.volume == 0 ? info + "\n\n" + Messages.get(this, "desc_water", new Object[0]) : info + "\n\n" + Messages.get(this, "desc_heal", new Object[0]);
        if (this.isFull()) {
            info = info + "\n\n" + Messages.get(this, "desc_full", new Object[0]);
        }
        return info;
    }

    public void empty() {
        this.volume = 0;
        Waterskin.updateQuickslot();
    }

    @Override
    public boolean isUpgradable() {
        return false;
    }

    @Override
    public boolean isIdentified() {
        return true;
    }

    public boolean isFull() {
        return this.volume >= 20;
    }

    public void collectDew(Dewdrop dew) {
        GLog.i(Messages.get(this, "collected", new Object[0]), new Object[0]);
        this.volume += dew.quantity;
        if (this.volume >= 20) {
            this.volume = 20;
            GLog.p(Messages.get(this, "full", new Object[0]), new Object[0]);
        }
        Waterskin.updateQuickslot();
    }

    public void fill() {
        this.volume = 20;
        Waterskin.updateQuickslot();
    }

    @Override
    public String status() {
        return Messages.format(TXT_STATUS, this.volume, 20);
    }
}

