/*
 * Decompiled with CFR 0.152.
 */
package com.shatteredpixel.shatteredpixeldungeon.items.quest;

import com.shatteredpixel.shatteredpixeldungeon.Dungeon;
import com.shatteredpixel.shatteredpixeldungeon.actors.Actor;
import com.shatteredpixel.shatteredpixeldungeon.actors.Char;
import com.shatteredpixel.shatteredpixeldungeon.actors.buffs.Buff;
import com.shatteredpixel.shatteredpixeldungeon.actors.buffs.Invisibility;
import com.shatteredpixel.shatteredpixeldungeon.actors.buffs.Vulnerable;
import com.shatteredpixel.shatteredpixeldungeon.actors.hero.Hero;
import com.shatteredpixel.shatteredpixeldungeon.actors.hero.HeroClass;
import com.shatteredpixel.shatteredpixeldungeon.actors.hero.HeroSubClass;
import com.shatteredpixel.shatteredpixeldungeon.actors.mobs.Bat;
import com.shatteredpixel.shatteredpixeldungeon.actors.mobs.Bee;
import com.shatteredpixel.shatteredpixeldungeon.actors.mobs.Crab;
import com.shatteredpixel.shatteredpixeldungeon.actors.mobs.Scorpio;
import com.shatteredpixel.shatteredpixeldungeon.actors.mobs.Spinner;
import com.shatteredpixel.shatteredpixeldungeon.actors.mobs.Swarm;
import com.shatteredpixel.shatteredpixeldungeon.effects.CellEmitter;
import com.shatteredpixel.shatteredpixeldungeon.effects.Speck;
import com.shatteredpixel.shatteredpixeldungeon.items.EquipableItem;
import com.shatteredpixel.shatteredpixeldungeon.items.Item;
import com.shatteredpixel.shatteredpixeldungeon.items.bags.Bag;
import com.shatteredpixel.shatteredpixeldungeon.items.quest.DarkGold;
import com.shatteredpixel.shatteredpixeldungeon.items.weapon.Weapon;
import com.shatteredpixel.shatteredpixeldungeon.items.weapon.melee.MeleeWeapon;
import com.shatteredpixel.shatteredpixeldungeon.items.weapon.melee.MinersTool;
import com.shatteredpixel.shatteredpixeldungeon.items.weapon.melee.Spade;
import com.shatteredpixel.shatteredpixeldungeon.journal.Catalog;
import com.shatteredpixel.shatteredpixeldungeon.levels.Level;
import com.shatteredpixel.shatteredpixeldungeon.messages.Messages;
import com.shatteredpixel.shatteredpixeldungeon.scenes.GameScene;
import com.shatteredpixel.shatteredpixeldungeon.sprites.ItemSprite;
import com.shatteredpixel.shatteredpixeldungeon.sprites.ItemSpriteSheet;
import com.shatteredpixel.shatteredpixeldungeon.ui.AttackIndicator;
import com.shatteredpixel.shatteredpixeldungeon.utils.GLog;
import com.shatteredpixel.shatteredpixeldungeon.windows.WndBag;
import com.watabou.noosa.audio.Sample;
import com.watabou.utils.Bundle;
import com.watabou.utils.Callback;
import com.watabou.utils.PathFinder;
import java.util.ArrayList;

public class Pickaxe
extends MeleeWeapon {
    public static final String AC_MINE = "MINE";
    public static final String AC_INFUSE = "INFUSE";
    public static final float TIME_TO_MINE = 2.0f;
    private static final ItemSprite.Glowing BLOODY = new ItemSprite.Glowing(0x550000);
    public boolean bloodStained;
    private final WndBag.ItemSelector itemSelector;
    private static final String BLOODSTAINED = "bloodStained";

    public Pickaxe() {
        this.image = ItemSpriteSheet.PICKAXE;
        this.levelKnown = true;
        this.unique = true;
        this.bones = false;
        this.tier = 2;
        this.bloodStained = false;
        this.itemSelector = new WndBag.ItemSelector(){

            @Override
            public String textPrompt() {
                return Messages.get(Pickaxe.class, "infuse_title", new Object[0]);
            }

            @Override
            public Class<? extends Bag> preferredBag() {
                return null;
            }

            @Override
            public boolean itemSelectable(Item item) {
                return item instanceof Spade && item.isIdentified();
            }

            @Override
            public void onSelect(Item item) {
                Item result = Pickaxe.changeItem(item);
                if (result == null) {
                    GLog.n(Messages.get(Pickaxe.class, "nothing", new Object[0]), new Object[0]);
                    curItem.collect(curUser.belongings.backpack);
                } else {
                    if (item.isEquipped(Dungeon.hero)) {
                        item.cursed = false;
                        ((EquipableItem)item).doUnequip(Dungeon.hero, false);
                        ((EquipableItem)result).doEquip(Dungeon.hero);
                    } else {
                        item.detach(Dungeon.hero.belongings.backpack);
                        if (!result.collect()) {
                            Dungeon.level.drop((Item)result, (int)curUser.pos).sprite.drop();
                        }
                    }
                    if (result.isIdentified()) {
                        Catalog.setSeen(result.getClass());
                    }
                    Sample.INSTANCE.play("sounds/evoke.mp3");
                    Dungeon.hero.sprite.operate(Dungeon.hero.pos);
                    CellEmitter.center(Dungeon.hero.pos).burst(Speck.factory(1), 10);
                    GLog.p(Messages.get(Pickaxe.class, "infuse", new Object[0]), new Object[0]);
                    Pickaxe.this.detach(Dungeon.hero.belongings.backpack);
                    Item.updateQuickslot();
                }
            }
        };
    }

    @Override
    public int STRReq(int lvl) {
        return super.STRReq(lvl) + 2;
    }

    @Override
    public ArrayList<String> actions(Hero hero) {
        ArrayList<String> actions = super.actions(hero);
        actions.add(AC_MINE);
        if (Dungeon.hero.subClass == HeroSubClass.TREASUREHUNTER) {
            actions.add(AC_INFUSE);
        }
        return actions;
    }

    @Override
    public void execute(final Hero hero, String action) {
        super.execute(hero, action);
        if (action.equals(AC_MINE)) {
            if (Dungeon.depth < 11 || Dungeon.depth > 15) {
                GLog.w(Messages.get(this, "no_vein", new Object[0]), new Object[0]);
                return;
            }
            for (int i = 0; i < PathFinder.NEIGHBOURS8.length; ++i) {
                final int pos = hero.pos + PathFinder.NEIGHBOURS8[i];
                if (Dungeon.level.map[pos] != 12) continue;
                hero.spend(2.0f);
                hero.busy();
                hero.sprite.attack(pos, new Callback(){

                    @Override
                    public void call() {
                        CellEmitter.center(pos).burst(Speck.factory(1), 7);
                        Sample.INSTANCE.play("sounds/evoke.mp3");
                        Level.set(pos, 4);
                        GameScene.updateMap(pos);
                        DarkGold gold = new DarkGold();
                        if (gold.doPickUp(Dungeon.hero)) {
                            GLog.i(Messages.capitalize(Messages.get(Dungeon.hero, "you_now_have", gold.name())), new Object[0]);
                        } else {
                            Dungeon.level.drop((Item)gold, (int)hero.pos).sprite.drop();
                        }
                        hero.onOperateComplete();
                    }
                });
                return;
            }
            GLog.w(Messages.get(this, "no_vein", new Object[0]), new Object[0]);
        }
        if (action.equals(AC_INFUSE)) {
            curUser = hero;
            GameScene.selectItem(this.itemSelector);
        }
    }

    public static Item changeItem(Item item) {
        if (item instanceof Spade) {
            return Pickaxe.changeWeapon((Weapon)item);
        }
        return null;
    }

    private static Weapon changeWeapon(Weapon w) {
        MinersTool n = new MinersTool();
        int level = w.level();
        if (w.curseInfusionBonus) {
            --level;
        }
        if (level > 0) {
            n.upgrade(level);
        } else if (level < 0) {
            n.degrade(-level);
        }
        n.enchantment = w.enchantment;
        n.curseInfusionBonus = w.curseInfusionBonus;
        n.masteryPotionBonus = w.masteryPotionBonus;
        n.levelKnown = w.levelKnown;
        n.cursedKnown = w.cursedKnown;
        n.cursed = w.cursed;
        n.augment = w.augment;
        return n;
    }

    @Override
    public int proc(Char attacker, final Char defender, int damage) {
        if (!this.bloodStained && defender instanceof Bat) {
            Actor.add(new Actor(){
                {
                    this.actPriority = 100;
                }

                @Override
                protected boolean act() {
                    if (!defender.isAlive()) {
                        Pickaxe.this.bloodStained = true;
                        Item.updateQuickslot();
                    }
                    Actor.remove(this);
                    return true;
                }
            });
        }
        return super.proc(attacker, defender, damage);
    }

    @Override
    public String defaultAction() {
        if (Dungeon.hero.heroClass == HeroClass.DUELIST && this.isEquipped(Dungeon.hero)) {
            return AC_ABILITY;
        }
        return AC_MINE;
    }

    @Override
    public String targetingPrompt() {
        return Messages.get(this, "prompt", new Object[0]);
    }

    @Override
    protected void duelistAbility(final Hero hero, Integer target) {
        if (target == null) {
            return;
        }
        final Char enemy = Actor.findChar(target);
        if (enemy == null || enemy == hero || hero.isCharmedBy(enemy) || !Dungeon.level.heroFOV[target]) {
            GLog.w(Messages.get(this, "ability_no_target", new Object[0]), new Object[0]);
            return;
        }
        hero.belongings.abilityWeapon = this;
        if (!hero.canAttack(enemy)) {
            GLog.w(Messages.get(this, "ability_bad_position", new Object[0]), new Object[0]);
            hero.belongings.abilityWeapon = null;
            return;
        }
        hero.belongings.abilityWeapon = null;
        hero.sprite.attack(enemy.pos, new Callback(){

            @Override
            public void call() {
                float damageMulti = 1.0f;
                if (Char.hasProp(enemy, Char.Property.INORGANIC) || enemy instanceof Swarm || enemy instanceof Bee || enemy instanceof Crab || enemy instanceof Spinner || enemy instanceof Scorpio) {
                    damageMulti = 2.0f;
                }
                Pickaxe.this.beforeAbilityUsed(hero, enemy);
                AttackIndicator.target(enemy);
                if (hero.attack(enemy, damageMulti, 0.0f, Char.INFINITE_ACCURACY)) {
                    if (enemy.isAlive()) {
                        Buff.affect(enemy, Vulnerable.class, 3.0f);
                    } else {
                        MeleeWeapon.onAbilityKill(hero, enemy);
                    }
                    Sample.INSTANCE.play("sounds/hit_strong.mp3");
                }
                Invisibility.dispel();
                hero.spendAndNext(hero.attackDelay());
                Pickaxe.this.afterAbilityUsed(hero);
            }
        });
    }

    @Override
    public void storeInBundle(Bundle bundle) {
        super.storeInBundle(bundle);
        bundle.put(BLOODSTAINED, this.bloodStained);
    }

    @Override
    public void restoreFromBundle(Bundle bundle) {
        super.restoreFromBundle(bundle);
        this.bloodStained = bundle.getBoolean(BLOODSTAINED);
    }

    @Override
    public ItemSprite.Glowing glowing() {
        if (super.glowing() == null) {
            return this.bloodStained ? BLOODY : null;
        }
        return super.glowing();
    }
}

