/*
 * Decompiled with CFR 0.152.
 */
package com.shatteredpixel.shatteredpixeldungeon.items.rings;

import com.shatteredpixel.shatteredpixeldungeon.Dungeon;
import com.shatteredpixel.shatteredpixeldungeon.actors.Char;
import com.shatteredpixel.shatteredpixeldungeon.actors.buffs.Adrenaline;
import com.shatteredpixel.shatteredpixeldungeon.actors.buffs.AttackSpeedBuff;
import com.shatteredpixel.shatteredpixeldungeon.actors.buffs.Flurry;
import com.shatteredpixel.shatteredpixeldungeon.actors.buffs.SerialAttack;
import com.shatteredpixel.shatteredpixeldungeon.actors.buffs.Surgery;
import com.shatteredpixel.shatteredpixeldungeon.actors.hero.Talent;
import com.shatteredpixel.shatteredpixeldungeon.actors.hero.abilities.samurai.ShadowBlade;
import com.shatteredpixel.shatteredpixeldungeon.items.rings.Ring;
import com.shatteredpixel.shatteredpixeldungeon.items.rings.RingOfRush;
import com.shatteredpixel.shatteredpixeldungeon.items.weapon.melee.DoubleDagger;
import com.shatteredpixel.shatteredpixeldungeon.messages.Messages;
import com.shatteredpixel.shatteredpixeldungeon.sprites.ItemSpriteSheet;

public class RingOfFuror
extends Ring {
    public RingOfFuror() {
        this.icon = ItemSpriteSheet.Icons.RING_FUROR;
    }

    @Override
    public String statsInfo() {
        if (this.isIdentified()) {
            return Messages.get(this, "stats", Messages.decimalFormat("#.##", 100.0 * (Math.pow(1.0905f, this.soloBuffedBonus()) - 1.0)));
        }
        return Messages.get(this, "typical_stats", Messages.decimalFormat("#.##", 9.05f));
    }

    @Override
    protected Ring.RingBuff buff() {
        return new Furor();
    }

    public static float attackSpeedMultiplier(Char target) {
        float speedBonus = (float)Math.pow(1.0905, RingOfFuror.getBuffedBonus(target, Furor.class));
        if (target == Dungeon.hero) {
            int aEnc;
            if (Dungeon.hero.buff(Adrenaline.class) != null) {
                speedBonus *= 1.5f;
            }
            if (Dungeon.hero.buff(ShadowBlade.shadowBladeTracker.class) != null) {
                speedBonus *= 2.0f + 0.05f * (float)Dungeon.hero.pointsInTalent(Talent.DOUBLE_BLADE_PRACTICE);
            }
            if (Dungeon.hero.buff(Flurry.class) != null) {
                speedBonus *= 2.0f;
            }
            if (Dungeon.hero.hasTalent(Talent.ATK_SPEED_ENHANCE)) {
                speedBonus *= 1.0f + 0.05f * (float)Dungeon.hero.pointsInTalent(Talent.ATK_SPEED_ENHANCE);
            }
            if (Dungeon.hero.buff(AttackSpeedBuff.class) != null) {
                speedBonus *= 1.0f + 0.05f * (float)Dungeon.hero.buff(AttackSpeedBuff.class).getCount();
            }
            if (Dungeon.hero.hasTalent(Talent.SLASHING_PRACTICE) && Dungeon.hero.buff(SerialAttack.class) != null) {
                speedBonus *= 1.0f + 0.02f * (float)Dungeon.hero.pointsInTalent(Talent.SLASHING_PRACTICE) * (float)Dungeon.hero.buff(SerialAttack.class).getCount();
            }
            if (Dungeon.hero.buff(Surgery.class) != null && Dungeon.hero.hasTalent(Talent.HASTY_HANDS)) {
                speedBonus *= 1.0f + 0.01f * (float)Dungeon.hero.buff(Surgery.class).getCount() * (float)Dungeon.hero.pointsInTalent(Talent.HASTY_HANDS);
            }
            if (Dungeon.hero.hasTalent(Talent.LESS_RESIST) && (aEnc = Dungeon.hero.belongings.armor.STRReq() - Dungeon.hero.STR()) < 0) {
                speedBonus *= 1.0f + 0.05f * (float)Dungeon.hero.pointsInTalent(Talent.LESS_RESIST) * (float)(-aEnc);
            }
            if (Dungeon.hero.buff(DoubleDagger.ReverseBlade.class) != null) {
                speedBonus *= 3.0f;
            }
            if (Dungeon.hero.buff(Talent.QuickFollowupTracker.class) != null) {
                speedBonus *= 1.0f + 0.33333334f * (float)Dungeon.hero.pointsInTalent(Talent.QUICK_FOLLOWUP);
            }
            speedBonus *= RingOfRush.rushSpeedMultiplier(Dungeon.hero);
        }
        return speedBonus;
    }

    public class Furor
    extends Ring.RingBuff {
    }
}

