/*
 * Decompiled with CFR 0.152.
 */
package com.shatteredpixel.shatteredpixeldungeon.items.rings;

import com.shatteredpixel.shatteredpixeldungeon.Dungeon;
import com.shatteredpixel.shatteredpixeldungeon.actors.Char;
import com.shatteredpixel.shatteredpixeldungeon.actors.hero.Talent;
import com.shatteredpixel.shatteredpixeldungeon.items.rings.Ring;
import com.shatteredpixel.shatteredpixeldungeon.messages.Messages;
import com.shatteredpixel.shatteredpixeldungeon.sprites.ItemSpriteSheet;
import java.text.DecimalFormat;

public class RingOfReload
extends Ring {
    public RingOfReload() {
        this.icon = ItemSpriteSheet.Icons.RING_RELOAD;
    }

    @Override
    public String statsInfo() {
        if (this.isIdentified()) {
            return Messages.get(this, "stats", new DecimalFormat("#.##").format(100.0 * (1.0 - Math.pow(0.825f, this.soloBuffedBonus()))));
        }
        return Messages.get(this, "typical_stats", new DecimalFormat("#.##").format(17.5));
    }

    @Override
    protected Ring.RingBuff buff() {
        return new Reload();
    }

    public static float reloadMultiplier(Char target) {
        float speed = (float)Math.pow(0.825f, RingOfReload.getBuffedBonus(target, Reload.class));
        if (Dungeon.hero.hasTalent(Talent.FAST_RELOAD) && Dungeon.hero.belongings.weapon != null) {
            speed = (float)((double)speed * Math.pow(1.0f - 0.05f * (float)Dungeon.hero.pointsInTalent(Talent.FAST_RELOAD), Math.max(0, Dungeon.hero.STR() - Dungeon.hero.belongings.weapon.STRReq())));
        }
        if (Dungeon.hero.hasTalent(Talent.RELOAD_PRACTICE)) {
            speed = (float)((double)speed * (1.0 - 0.1 * (double)Dungeon.hero.pointsInTalent(Talent.RELOAD_PRACTICE)));
        }
        return speed;
    }

    public class Reload
    extends Ring.RingBuff {
    }
}

