/*
 * Decompiled with CFR 0.152.
 */
package com.shatteredpixel.shatteredpixeldungeon.items.spells;

import com.shatteredpixel.shatteredpixeldungeon.Badges;
import com.shatteredpixel.shatteredpixeldungeon.effects.CellEmitter;
import com.shatteredpixel.shatteredpixeldungeon.effects.particles.ShadowParticle;
import com.shatteredpixel.shatteredpixeldungeon.items.EquipableItem;
import com.shatteredpixel.shatteredpixeldungeon.items.Item;
import com.shatteredpixel.shatteredpixeldungeon.items.Recipe;
import com.shatteredpixel.shatteredpixeldungeon.items.armor.Armor;
import com.shatteredpixel.shatteredpixeldungeon.items.quest.MetalShard;
import com.shatteredpixel.shatteredpixeldungeon.items.rings.RingOfMight;
import com.shatteredpixel.shatteredpixeldungeon.items.scrolls.ScrollOfRemoveCurse;
import com.shatteredpixel.shatteredpixeldungeon.items.spells.InventorySpell;
import com.shatteredpixel.shatteredpixeldungeon.items.wands.Wand;
import com.shatteredpixel.shatteredpixeldungeon.items.weapon.CorrosionBow;
import com.shatteredpixel.shatteredpixeldungeon.items.weapon.GoldenBow;
import com.shatteredpixel.shatteredpixeldungeon.items.weapon.NaturesBow;
import com.shatteredpixel.shatteredpixeldungeon.items.weapon.SpiritBow;
import com.shatteredpixel.shatteredpixeldungeon.items.weapon.Weapon;
import com.shatteredpixel.shatteredpixeldungeon.items.weapon.WindBow;
import com.shatteredpixel.shatteredpixeldungeon.items.weapon.melee.MagesStaff;
import com.shatteredpixel.shatteredpixeldungeon.items.weapon.melee.MeleeWeapon;
import com.shatteredpixel.shatteredpixeldungeon.items.weapon.melee.MissileButton;
import com.shatteredpixel.shatteredpixeldungeon.items.weapon.missiles.MissileWeapon;
import com.shatteredpixel.shatteredpixeldungeon.sprites.ItemSpriteSheet;
import com.watabou.noosa.audio.Sample;

public class CurseInfusion
extends InventorySpell {
    public CurseInfusion() {
        this.image = ItemSpriteSheet.CURSE_INFUSE;
    }

    @Override
    protected boolean usableOnItem(Item item) {
        return item instanceof EquipableItem && !(item instanceof MissileWeapon) && !(item instanceof MissileButton) || item instanceof Wand;
    }

    @Override
    protected void onItemSelected(Item item) {
        CellEmitter.get(CurseInfusion.curUser.pos).burst(ShadowParticle.UP, 5);
        Sample.INSTANCE.play("sounds/cursed.mp3");
        item.cursed = true;
        if (item instanceof MeleeWeapon || item instanceof SpiritBow || item instanceof WindBow || item instanceof GoldenBow || item instanceof CorrosionBow || item instanceof NaturesBow) {
            Weapon w = (Weapon)item;
            if (w.enchantment != null) {
                w.enchant(Weapon.Enchantment.randomCurse(w.enchantment.getClass()));
            } else {
                w.enchant(Weapon.Enchantment.randomCurse(new Class[0]));
            }
            w.curseInfusionBonus = true;
            if (w instanceof MagesStaff) {
                ((MagesStaff)w).updateWand(true);
            }
        } else if (item instanceof Armor) {
            Armor a = (Armor)item;
            if (a.glyph != null) {
                a.inscribe(Armor.Glyph.randomCurse(a.glyph.getClass()));
            } else {
                a.inscribe(Armor.Glyph.randomCurse(new Class[0]));
            }
            a.curseInfusionBonus = true;
        } else if (item instanceof Wand) {
            ((Wand)item).curseInfusionBonus = true;
            ((Wand)item).updateLevel();
        } else if (item instanceof RingOfMight) {
            curUser.updateHT(false);
        }
        Badges.validateItemLevelAquired(item);
        CurseInfusion.updateQuickslot();
    }

    @Override
    public int value() {
        return (int)(80.0f * ((float)this.quantity / 3.0f));
    }

    public static class Recipe
    extends Recipe.SimpleRecipe {
        public Recipe() {
            this.inputs = new Class[]{ScrollOfRemoveCurse.class, MetalShard.class};
            this.inQuantity = new int[]{1, 1};
            this.cost = 6;
            this.output = CurseInfusion.class;
            this.outQuantity = 4;
        }
    }
}

