/*
 * Decompiled with CFR 0.152.
 */
package com.shatteredpixel.shatteredpixeldungeon.items.spells;

import com.shatteredpixel.shatteredpixeldungeon.Dungeon;
import com.shatteredpixel.shatteredpixeldungeon.effects.Speck;
import com.shatteredpixel.shatteredpixeldungeon.items.Cartridge;
import com.shatteredpixel.shatteredpixeldungeon.items.EquipableItem;
import com.shatteredpixel.shatteredpixeldungeon.items.Item;
import com.shatteredpixel.shatteredpixeldungeon.items.LiquidMetal;
import com.shatteredpixel.shatteredpixeldungeon.items.Recipe;
import com.shatteredpixel.shatteredpixeldungeon.items.StunGun;
import com.shatteredpixel.shatteredpixeldungeon.items.StunGunAP;
import com.shatteredpixel.shatteredpixeldungeon.items.StunGunHP;
import com.shatteredpixel.shatteredpixeldungeon.items.spells.InventorySpell;
import com.shatteredpixel.shatteredpixeldungeon.items.stones.StoneOfAugmentation;
import com.shatteredpixel.shatteredpixeldungeon.items.weapon.Weapon;
import com.shatteredpixel.shatteredpixeldungeon.items.weapon.melee.AntimaterRifle;
import com.shatteredpixel.shatteredpixeldungeon.items.weapon.melee.AntimaterRifleHP;
import com.shatteredpixel.shatteredpixeldungeon.items.weapon.melee.AssultRifle;
import com.shatteredpixel.shatteredpixeldungeon.items.weapon.melee.AssultRifleHP;
import com.shatteredpixel.shatteredpixeldungeon.items.weapon.melee.AutoHandgun;
import com.shatteredpixel.shatteredpixeldungeon.items.weapon.melee.AutoHandgunHP;
import com.shatteredpixel.shatteredpixeldungeon.items.weapon.melee.AutoRifle;
import com.shatteredpixel.shatteredpixeldungeon.items.weapon.melee.AutoRifleHP;
import com.shatteredpixel.shatteredpixeldungeon.items.weapon.melee.Carbine;
import com.shatteredpixel.shatteredpixeldungeon.items.weapon.melee.CarbineHP;
import com.shatteredpixel.shatteredpixeldungeon.items.weapon.melee.CrudePistol;
import com.shatteredpixel.shatteredpixeldungeon.items.weapon.melee.CrudePistolHP;
import com.shatteredpixel.shatteredpixeldungeon.items.weapon.melee.DualPistol;
import com.shatteredpixel.shatteredpixeldungeon.items.weapon.melee.DualPistolHP;
import com.shatteredpixel.shatteredpixeldungeon.items.weapon.melee.FlameThrower;
import com.shatteredpixel.shatteredpixeldungeon.items.weapon.melee.FlameThrowerHP;
import com.shatteredpixel.shatteredpixeldungeon.items.weapon.melee.FrostGun;
import com.shatteredpixel.shatteredpixeldungeon.items.weapon.melee.GoldenPistol;
import com.shatteredpixel.shatteredpixeldungeon.items.weapon.melee.GoldenPistolHP;
import com.shatteredpixel.shatteredpixeldungeon.items.weapon.melee.GrenadeLauncher;
import com.shatteredpixel.shatteredpixeldungeon.items.weapon.melee.GrenadeLauncherAP;
import com.shatteredpixel.shatteredpixeldungeon.items.weapon.melee.GrenadeLauncherHP;
import com.shatteredpixel.shatteredpixeldungeon.items.weapon.melee.Handgun;
import com.shatteredpixel.shatteredpixeldungeon.items.weapon.melee.HandgunHP;
import com.shatteredpixel.shatteredpixeldungeon.items.weapon.melee.HeavyMachinegun;
import com.shatteredpixel.shatteredpixeldungeon.items.weapon.melee.HeavyMachinegunHP;
import com.shatteredpixel.shatteredpixeldungeon.items.weapon.melee.HuntingRifle;
import com.shatteredpixel.shatteredpixeldungeon.items.weapon.melee.HuntingRifleHP;
import com.shatteredpixel.shatteredpixeldungeon.items.weapon.melee.KSG;
import com.shatteredpixel.shatteredpixeldungeon.items.weapon.melee.KSGHP;
import com.shatteredpixel.shatteredpixeldungeon.items.weapon.melee.Magnum;
import com.shatteredpixel.shatteredpixeldungeon.items.weapon.melee.MagnumHP;
import com.shatteredpixel.shatteredpixeldungeon.items.weapon.melee.MarksmanRifle;
import com.shatteredpixel.shatteredpixeldungeon.items.weapon.melee.MarksmanRifleHP;
import com.shatteredpixel.shatteredpixeldungeon.items.weapon.melee.MeleeWeapon;
import com.shatteredpixel.shatteredpixeldungeon.items.weapon.melee.MiniGun;
import com.shatteredpixel.shatteredpixeldungeon.items.weapon.melee.MiniGunHP;
import com.shatteredpixel.shatteredpixeldungeon.items.weapon.melee.ParalysisGun;
import com.shatteredpixel.shatteredpixeldungeon.items.weapon.melee.Pistol;
import com.shatteredpixel.shatteredpixeldungeon.items.weapon.melee.PistolHP;
import com.shatteredpixel.shatteredpixeldungeon.items.weapon.melee.PlasmaCannon;
import com.shatteredpixel.shatteredpixeldungeon.items.weapon.melee.PlasmaCannonHP;
import com.shatteredpixel.shatteredpixeldungeon.items.weapon.melee.Revolver;
import com.shatteredpixel.shatteredpixeldungeon.items.weapon.melee.RevolverHP;
import com.shatteredpixel.shatteredpixeldungeon.items.weapon.melee.ShotGun;
import com.shatteredpixel.shatteredpixeldungeon.items.weapon.melee.ShotGunHP;
import com.shatteredpixel.shatteredpixeldungeon.items.weapon.melee.SleepGun;
import com.shatteredpixel.shatteredpixeldungeon.items.weapon.melee.SniperRifle;
import com.shatteredpixel.shatteredpixeldungeon.items.weapon.melee.SniperRifleHP;
import com.shatteredpixel.shatteredpixeldungeon.items.weapon.melee.SubMachinegun;
import com.shatteredpixel.shatteredpixeldungeon.items.weapon.melee.SubMachinegunHP;
import com.shatteredpixel.shatteredpixeldungeon.items.weapon.melee.TacticalHandgun;
import com.shatteredpixel.shatteredpixeldungeon.items.weapon.melee.TacticalHandgunHP;
import com.shatteredpixel.shatteredpixeldungeon.items.weapon.melee.WA2000;
import com.shatteredpixel.shatteredpixeldungeon.items.weapon.melee.WA2000HP;
import com.shatteredpixel.shatteredpixeldungeon.journal.Catalog;
import com.shatteredpixel.shatteredpixeldungeon.messages.Messages;
import com.shatteredpixel.shatteredpixeldungeon.sprites.ItemSpriteSheet;
import com.shatteredpixel.shatteredpixeldungeon.utils.GLog;

public class HPBullet
extends InventorySpell {
    public HPBullet() {
        this.image = ItemSpriteSheet.HP_BULLET;
        this.unique = true;
        this.bones = false;
    }

    @Override
    protected boolean usableOnItem(Item item) {
        return item instanceof CrudePistol || item instanceof Pistol || item instanceof GoldenPistol || item instanceof Handgun || item instanceof Magnum || item instanceof TacticalHandgun || item instanceof AutoHandgun || item instanceof DualPistol || item instanceof SubMachinegun || item instanceof AssultRifle || item instanceof HeavyMachinegun || item instanceof MiniGun || item instanceof AutoRifle || item instanceof Revolver || item instanceof HuntingRifle || item instanceof Carbine || item instanceof SniperRifle || item instanceof AntimaterRifle || item instanceof MarksmanRifle || item instanceof WA2000 || item instanceof ShotGun || item instanceof KSG || item instanceof FlameThrower || item instanceof PlasmaCannon || item instanceof GrenadeLauncher || item instanceof GrenadeLauncherAP || item instanceof SleepGun || item instanceof FrostGun || item instanceof StunGun || item instanceof StunGunAP;
    }

    @Override
    protected void onItemSelected(Item item) {
        Item result = HPBullet.changeItem(item);
        if (result == null) {
            GLog.n(Messages.get(this, "nothing", new Object[0]), new Object[0]);
            curItem.collect(HPBullet.curUser.belongings.backpack);
        } else {
            if (item.isEquipped(Dungeon.hero)) {
                item.cursed = false;
                ((EquipableItem)item).doUnequip(Dungeon.hero, false);
                ((EquipableItem)result).doEquip(Dungeon.hero);
            } else {
                item.detach(Dungeon.hero.belongings.backpack);
                if (!result.collect()) {
                    Dungeon.level.drop((Item)result, (int)HPBullet.curUser.pos).sprite.drop();
                }
            }
            if (result.isIdentified()) {
                Catalog.setSeen(result.getClass());
            }
            Dungeon.hero.sprite.emitter().start(Speck.factory(4), 0.2f, 3);
            GLog.p(Messages.get(this, "load", new Object[0]), new Object[0]);
        }
    }

    public static Item changeItem(Item item) {
        if (item instanceof MeleeWeapon) {
            return HPBullet.changeWeapon((Weapon)item);
        }
        if (item instanceof StunGun || item instanceof StunGunAP) {
            return new StunGunHP();
        }
        return null;
    }

    private static Weapon changeWeapon(Weapon w) {
        MeleeWeapon n = w instanceof CrudePistol ? new CrudePistolHP() : (w instanceof Pistol ? new PistolHP() : (w instanceof GoldenPistol ? new GoldenPistolHP() : (w instanceof Handgun ? new HandgunHP() : (w instanceof Magnum ? new MagnumHP() : (w instanceof TacticalHandgun ? new TacticalHandgunHP() : (w instanceof AutoHandgun ? new AutoHandgunHP() : (w instanceof DualPistol ? new DualPistolHP() : (w instanceof SubMachinegun ? new SubMachinegunHP() : (w instanceof AssultRifle ? new AssultRifleHP() : (w instanceof HeavyMachinegun ? new HeavyMachinegunHP() : (w instanceof MiniGun ? new MiniGunHP() : (w instanceof AutoRifle ? new AutoRifleHP() : (w instanceof Revolver ? new RevolverHP() : (w instanceof HuntingRifle ? new HuntingRifleHP() : (w instanceof Carbine ? new CarbineHP() : (w instanceof SniperRifle ? new SniperRifleHP() : (w instanceof AntimaterRifle ? new AntimaterRifleHP() : (w instanceof MarksmanRifle ? new MarksmanRifleHP() : (w instanceof WA2000 ? new WA2000HP() : (w instanceof ShotGun ? new ShotGunHP() : (w instanceof KSG ? new KSGHP() : (w instanceof FlameThrower ? new FlameThrowerHP() : (w instanceof PlasmaCannon ? new PlasmaCannonHP() : (w instanceof GrenadeLauncher || w instanceof GrenadeLauncherAP || w instanceof GrenadeLauncherHP ? new GrenadeLauncherHP() : new ParalysisGun()))))))))))))))))))))))));
        n.enchantment = w.enchantment;
        n.curseInfusionBonus = w.curseInfusionBonus;
        n.masteryPotionBonus = w.masteryPotionBonus;
        n.levelKnown = w.levelKnown;
        n.cursedKnown = w.cursedKnown;
        n.cursed = w.cursed;
        n.augment = w.augment;
        n.isUpgraded = w.isUpgraded;
        return n;
    }

    @Override
    public int value() {
        return this.quantity * 85;
    }

    public static class Recipe
    extends Recipe.SimpleRecipe {
        public Recipe() {
            this.inputs = new Class[]{Cartridge.class, LiquidMetal.class, StoneOfAugmentation.class};
            this.inQuantity = new int[]{1, 15, 1};
            this.cost = 3;
            this.output = HPBullet.class;
            this.outQuantity = 1;
        }
    }
}

