/*
 * Decompiled with CFR 0.152.
 */
package com.shatteredpixel.shatteredpixeldungeon.items.spells;

import com.shatteredpixel.shatteredpixeldungeon.Badges;
import com.shatteredpixel.shatteredpixeldungeon.Dungeon;
import com.shatteredpixel.shatteredpixeldungeon.Statistics;
import com.shatteredpixel.shatteredpixeldungeon.actors.buffs.Degrade;
import com.shatteredpixel.shatteredpixeldungeon.actors.hero.Hero;
import com.shatteredpixel.shatteredpixeldungeon.actors.hero.Talent;
import com.shatteredpixel.shatteredpixeldungeon.effects.Speck;
import com.shatteredpixel.shatteredpixeldungeon.effects.particles.ShadowParticle;
import com.shatteredpixel.shatteredpixeldungeon.items.Item;
import com.shatteredpixel.shatteredpixeldungeon.items.scrolls.ScrollOfUpgrade;
import com.shatteredpixel.shatteredpixeldungeon.items.spells.InventorySpell;
import com.shatteredpixel.shatteredpixeldungeon.items.weapon.Weapon;
import com.shatteredpixel.shatteredpixeldungeon.messages.Messages;
import com.shatteredpixel.shatteredpixeldungeon.sprites.ItemSpriteSheet;
import com.shatteredpixel.shatteredpixeldungeon.utils.GLog;
import com.watabou.utils.Random;

public class ScrollOfAlchemy
extends InventorySpell {
    public ScrollOfAlchemy() {
        this.image = ItemSpriteSheet.SCROLL_PLUS;
        this.icon = ItemSpriteSheet.Icons.POTION_MASTERY;
        this.unique = true;
        this.bones = false;
    }

    @Override
    protected boolean usableOnItem(Item item) {
        return item.alchemy && item.isUpgradable();
    }

    @Override
    protected void onItemSelected(Item item) {
        ScrollOfAlchemy.upgrade(curUser);
        Degrade.detach(curUser, Degrade.class);
        if (item instanceof Weapon) {
            Weapon w = (Weapon)item;
            boolean wasCursed = w.cursed;
            boolean hadCursedEnchant = w.hasCurseEnchant();
            boolean hadGoodEnchant = w.hasGoodEnchant();
            if (w.enchantment != null && Random.Int(2) < Dungeon.hero.pointsInTalent(Talent.MAGICAL_TRANSFERENCE)) {
                w.upgrade(true);
            } else {
                w.upgrade();
            }
            if (w.cursedKnown && hadCursedEnchant && !w.hasCurseEnchant()) {
                ScrollOfAlchemy.removeCurse(Dungeon.hero);
            } else if (w.cursedKnown && wasCursed && !w.cursed) {
                ScrollOfAlchemy.weakenCurse(Dungeon.hero);
            }
            if (hadGoodEnchant && !w.hasGoodEnchant()) {
                GLog.w(Messages.get(Weapon.class, "incompatible", new Object[0]), new Object[0]);
            }
        } else {
            item.upgrade();
        }
        Badges.validateItemLevelAquired(item);
        ++Statistics.upgradesUsed;
        Badges.validateMageUnlock();
    }

    public static void upgrade(Hero hero) {
        hero.sprite.emitter().start(Speck.factory(4), 0.2f, 3);
    }

    public static void weakenCurse(Hero hero) {
        GLog.p(Messages.get(ScrollOfUpgrade.class, "weaken_curse", new Object[0]), new Object[0]);
        hero.sprite.emitter().start(ShadowParticle.UP, 0.05f, 5);
    }

    public static void removeCurse(Hero hero) {
        GLog.p(Messages.get(ScrollOfUpgrade.class, "remove_curse", new Object[0]), new Object[0]);
        hero.sprite.emitter().start(ShadowParticle.UP, 0.05f, 10);
    }

    @Override
    public int value() {
        return 50;
    }
}

