/*
 * Decompiled with CFR 0.152.
 */
package com.shatteredpixel.shatteredpixeldungeon.items.spells;

import com.shatteredpixel.shatteredpixeldungeon.actors.buffs.Awareness;
import com.shatteredpixel.shatteredpixeldungeon.actors.buffs.Buff;
import com.shatteredpixel.shatteredpixeldungeon.actors.hero.Hero;
import com.shatteredpixel.shatteredpixeldungeon.items.Recipe;
import com.shatteredpixel.shatteredpixeldungeon.items.potions.exotic.PotionOfMagicalSight;
import com.shatteredpixel.shatteredpixeldungeon.items.scrolls.exotic.ScrollOfForesight;
import com.shatteredpixel.shatteredpixeldungeon.items.spells.ArcaneCatalyst;
import com.shatteredpixel.shatteredpixeldungeon.items.spells.Spell;
import com.shatteredpixel.shatteredpixeldungeon.messages.Messages;
import com.shatteredpixel.shatteredpixeldungeon.sprites.ItemSpriteSheet;
import com.shatteredpixel.shatteredpixeldungeon.utils.GLog;
import com.watabou.noosa.audio.Sample;

public class Xray
extends Spell {
    public Xray() {
        this.image = ItemSpriteSheet.XRAY;
    }

    @Override
    protected void onCast(Hero hero) {
        Buff.affect(hero, Awareness.class, 2.0f);
        hero.sprite.operate(hero.pos);
        Sample.INSTANCE.play("sounds/read.mp3");
        GLog.p(Messages.get(this, "xray", new Object[0]), new Object[0]);
        this.detach(Xray.curUser.belongings.backpack);
        Xray.updateQuickslot();
        hero.spendAndNext(1.0f);
    }

    @Override
    public int value() {
        return Math.round((float)this.quantity * 70.0f);
    }

    public static class Recipe
    extends Recipe.SimpleRecipe {
        public Recipe() {
            this.inputs = new Class[]{PotionOfMagicalSight.class, ScrollOfForesight.class, ArcaneCatalyst.class};
            this.inQuantity = new int[]{1, 1, 1};
            this.cost = 4;
            this.output = Xray.class;
            this.outQuantity = 2;
        }
    }
}

