/*
 * Decompiled with CFR 0.152.
 */
package com.shatteredpixel.shatteredpixeldungeon.items.stones;

import com.shatteredpixel.shatteredpixeldungeon.Dungeon;
import com.shatteredpixel.shatteredpixeldungeon.actors.hero.Belongings;
import com.shatteredpixel.shatteredpixeldungeon.items.Item;
import com.shatteredpixel.shatteredpixeldungeon.items.armor.Armor;
import com.shatteredpixel.shatteredpixeldungeon.items.scrolls.ScrollOfUpgrade;
import com.shatteredpixel.shatteredpixeldungeon.items.scrolls.exotic.ScrollOfEnchantment;
import com.shatteredpixel.shatteredpixeldungeon.items.stones.InventoryStone;
import com.shatteredpixel.shatteredpixeldungeon.items.weapon.Weapon;
import com.shatteredpixel.shatteredpixeldungeon.items.weapon.melee.AntimaterRifle;
import com.shatteredpixel.shatteredpixeldungeon.items.weapon.melee.AssultRifle;
import com.shatteredpixel.shatteredpixeldungeon.items.weapon.melee.AutoHandgun;
import com.shatteredpixel.shatteredpixeldungeon.items.weapon.melee.AutoRifle;
import com.shatteredpixel.shatteredpixeldungeon.items.weapon.melee.Carbine;
import com.shatteredpixel.shatteredpixeldungeon.items.weapon.melee.CrudePistol;
import com.shatteredpixel.shatteredpixeldungeon.items.weapon.melee.DualPistol;
import com.shatteredpixel.shatteredpixeldungeon.items.weapon.melee.FlameThrower;
import com.shatteredpixel.shatteredpixeldungeon.items.weapon.melee.FrostGun;
import com.shatteredpixel.shatteredpixeldungeon.items.weapon.melee.GoldenPistol;
import com.shatteredpixel.shatteredpixeldungeon.items.weapon.melee.GrenadeLauncher;
import com.shatteredpixel.shatteredpixeldungeon.items.weapon.melee.GrenadeLauncherAP;
import com.shatteredpixel.shatteredpixeldungeon.items.weapon.melee.GrenadeLauncherHP;
import com.shatteredpixel.shatteredpixeldungeon.items.weapon.melee.Handgun;
import com.shatteredpixel.shatteredpixeldungeon.items.weapon.melee.HeavyMachinegun;
import com.shatteredpixel.shatteredpixeldungeon.items.weapon.melee.HuntingRifle;
import com.shatteredpixel.shatteredpixeldungeon.items.weapon.melee.KSG;
import com.shatteredpixel.shatteredpixeldungeon.items.weapon.melee.Magnum;
import com.shatteredpixel.shatteredpixeldungeon.items.weapon.melee.MarksmanRifle;
import com.shatteredpixel.shatteredpixeldungeon.items.weapon.melee.MiniGun;
import com.shatteredpixel.shatteredpixeldungeon.items.weapon.melee.MissileButton;
import com.shatteredpixel.shatteredpixeldungeon.items.weapon.melee.ParalysisGun;
import com.shatteredpixel.shatteredpixeldungeon.items.weapon.melee.Pistol;
import com.shatteredpixel.shatteredpixeldungeon.items.weapon.melee.PlasmaCannon;
import com.shatteredpixel.shatteredpixeldungeon.items.weapon.melee.RPG7;
import com.shatteredpixel.shatteredpixeldungeon.items.weapon.melee.Revolver;
import com.shatteredpixel.shatteredpixeldungeon.items.weapon.melee.RocketLauncher;
import com.shatteredpixel.shatteredpixeldungeon.items.weapon.melee.ShotGun;
import com.shatteredpixel.shatteredpixeldungeon.items.weapon.melee.SleepGun;
import com.shatteredpixel.shatteredpixeldungeon.items.weapon.melee.SniperRifle;
import com.shatteredpixel.shatteredpixeldungeon.items.weapon.melee.SubMachinegun;
import com.shatteredpixel.shatteredpixeldungeon.items.weapon.melee.TacticalHandgun;
import com.shatteredpixel.shatteredpixeldungeon.items.weapon.melee.WA2000;
import com.shatteredpixel.shatteredpixeldungeon.messages.Messages;
import com.shatteredpixel.shatteredpixeldungeon.scenes.GameScene;
import com.shatteredpixel.shatteredpixeldungeon.scenes.PixelScene;
import com.shatteredpixel.shatteredpixeldungeon.sprites.ItemSpriteSheet;
import com.shatteredpixel.shatteredpixeldungeon.ui.RedButton;
import com.shatteredpixel.shatteredpixeldungeon.ui.RenderedTextBlock;
import com.shatteredpixel.shatteredpixeldungeon.ui.Window;
import com.shatteredpixel.shatteredpixeldungeon.windows.IconTitle;

public class StoneOfAugmentation
extends InventoryStone {
    public StoneOfAugmentation() {
        this.preferredBag = Belongings.Backpack.class;
        this.image = ItemSpriteSheet.STONE_AUGMENTATION;
    }

    @Override
    protected boolean usableOnItem(Item item) {
        if (item instanceof CrudePistol || item instanceof Pistol || item instanceof GoldenPistol || item instanceof Handgun || item instanceof Magnum || item instanceof TacticalHandgun || item instanceof AutoHandgun || item instanceof DualPistol || item instanceof SubMachinegun || item instanceof AssultRifle || item instanceof HeavyMachinegun || item instanceof MiniGun || item instanceof AutoRifle || item instanceof Revolver || item instanceof HuntingRifle || item instanceof Carbine || item instanceof SniperRifle || item instanceof AntimaterRifle || item instanceof MarksmanRifle || item instanceof WA2000 || item instanceof ShotGun || item instanceof KSG || item instanceof RocketLauncher || item instanceof RPG7 || item instanceof FlameThrower || item instanceof PlasmaCannon || item instanceof MissileButton || item instanceof GrenadeLauncher || item instanceof GrenadeLauncherAP || item instanceof GrenadeLauncherHP || item instanceof SleepGun || item instanceof FrostGun || item instanceof ParalysisGun) {
            return false;
        }
        return ScrollOfEnchantment.enchantable(item);
    }

    @Override
    protected void onItemSelected(Item item) {
        GameScene.show(new WndAugment(item));
    }

    public void apply(Weapon weapon, Weapon.Augment augment) {
        weapon.augment = augment;
        this.useAnimation();
        if (Dungeon.isChallenged(8192)) {
            weapon.fix();
        }
        ScrollOfUpgrade.upgrade(curUser);
    }

    public void apply(Armor armor, Armor.Augment augment) {
        armor.augment = augment;
        this.useAnimation();
        if (Dungeon.isChallenged(8192)) {
            armor.fix();
        }
        ScrollOfUpgrade.upgrade(curUser);
    }

    @Override
    public int value() {
        return 30 * this.quantity;
    }

    @Override
    public int energyVal() {
        return 4 * this.quantity;
    }

    public class WndAugment
    extends Window {
        private static final int WIDTH = 120;
        private static final int MARGIN = 2;
        private static final int BUTTON_WIDTH = 116;
        private static final int BUTTON_HEIGHT = 20;

        public WndAugment(final Item toAugment) {
            IconTitle titlebar = new IconTitle(toAugment);
            titlebar.setRect(0.0f, 0.0f, 120.0f, 0.0f);
            this.add(titlebar);
            RenderedTextBlock tfMesage = PixelScene.renderTextBlock(Messages.get(this, "choice", new Object[0]), 8);
            tfMesage.maxWidth(116);
            tfMesage.setPos(2.0f, titlebar.bottom() + 2.0f);
            this.add(tfMesage);
            float pos = tfMesage.top() + tfMesage.height();
            if (toAugment instanceof Weapon) {
                for (Enum enum_ : Weapon.Augment.values()) {
                    if (((Weapon)toAugment).augment == enum_) continue;
                    RedButton btnSpeed = new RedButton(Messages.get(this, enum_.name(), new Object[0]), (Weapon.Augment)enum_){
                        final /* synthetic */ Weapon.Augment val$aug;
                        {
                            this.val$aug = augment;
                            super(arg0);
                        }

                        @Override
                        protected void onClick() {
                            WndAugment.this.hide();
                            StoneOfAugmentation.this.apply((Weapon)toAugment, this.val$aug);
                        }
                    };
                    btnSpeed.setRect(2.0f, pos + 2.0f, 116.0f, 20.0f);
                    this.add(btnSpeed);
                    pos = btnSpeed.bottom();
                }
            } else if (toAugment instanceof Armor) {
                for (Enum enum_ : Armor.Augment.values()) {
                    if (((Armor)toAugment).augment == enum_) continue;
                    RedButton btnSpeed = new RedButton(Messages.get(this, enum_.name(), new Object[0]), (Armor.Augment)enum_){
                        final /* synthetic */ Armor.Augment val$aug;
                        {
                            this.val$aug = augment;
                            super(arg0);
                        }

                        @Override
                        protected void onClick() {
                            WndAugment.this.hide();
                            StoneOfAugmentation.this.apply((Armor)toAugment, this.val$aug);
                        }
                    };
                    btnSpeed.setRect(2.0f, pos + 2.0f, 116.0f, 20.0f);
                    this.add(btnSpeed);
                    pos = btnSpeed.bottom();
                }
            }
            RedButton btnCancel = new RedButton(Messages.get(this, "cancel", new Object[0])){

                @Override
                protected void onClick() {
                    WndAugment.this.hide();
                    StoneOfAugmentation.this.collect();
                }
            };
            btnCancel.setRect(2.0f, pos + 2.0f, 116.0f, 20.0f);
            this.add(btnCancel);
            this.resize(120, (int)btnCancel.bottom() + 2);
        }

        @Override
        public void onBackPressed() {
            StoneOfAugmentation.this.collect();
            super.onBackPressed();
        }
    }
}

