/*
 * Decompiled with CFR 0.152.
 */
package com.shatteredpixel.shatteredpixeldungeon.items.stones;

import com.shatteredpixel.shatteredpixeldungeon.Dungeon;
import com.shatteredpixel.shatteredpixeldungeon.actors.hero.Belongings;
import com.shatteredpixel.shatteredpixeldungeon.effects.Enchanting;
import com.shatteredpixel.shatteredpixeldungeon.effects.Speck;
import com.shatteredpixel.shatteredpixeldungeon.items.Item;
import com.shatteredpixel.shatteredpixeldungeon.items.Recipe;
import com.shatteredpixel.shatteredpixeldungeon.items.armor.Armor;
import com.shatteredpixel.shatteredpixeldungeon.items.scrolls.exotic.ScrollOfEnchantment;
import com.shatteredpixel.shatteredpixeldungeon.items.stones.InventoryStone;
import com.shatteredpixel.shatteredpixeldungeon.items.weapon.Weapon;
import com.shatteredpixel.shatteredpixeldungeon.items.weapon.melee.CrudePistol_Energy;
import com.shatteredpixel.shatteredpixeldungeon.items.weapon.melee.Dagger_Energy;
import com.shatteredpixel.shatteredpixeldungeon.items.weapon.melee.Gloves_Energy;
import com.shatteredpixel.shatteredpixeldungeon.items.weapon.melee.Saber_Energy;
import com.shatteredpixel.shatteredpixeldungeon.items.weapon.melee.WornKatana_Energy;
import com.shatteredpixel.shatteredpixeldungeon.items.weapon.melee.WornShortsword_Energy;
import com.shatteredpixel.shatteredpixeldungeon.messages.Messages;
import com.shatteredpixel.shatteredpixeldungeon.sprites.ItemSpriteSheet;
import com.shatteredpixel.shatteredpixeldungeon.utils.GLog;

public class StoneOfEnchantment
extends InventoryStone {
    public StoneOfEnchantment() {
        this.preferredBag = Belongings.Backpack.class;
        this.image = ItemSpriteSheet.STONE_ENCHANT;
        this.unique = true;
    }

    @Override
    protected boolean usableOnItem(Item item) {
        return ScrollOfEnchantment.enchantable(item);
    }

    @Override
    protected void onItemSelected(Item item) {
        if (item instanceof Weapon) {
            ((Weapon)item).enchant();
        } else {
            ((Armor)item).inscribe();
        }
        StoneOfEnchantment.curUser.sprite.emitter().start(Speck.factory(2), 0.1f, 5);
        Enchanting.show(curUser, item);
        if (item instanceof Weapon) {
            GLog.p(Messages.get(this, "weapon", new Object[0]), new Object[0]);
        } else {
            GLog.p(Messages.get(this, "armor", new Object[0]), new Object[0]);
        }
        if (Dungeon.isChallenged(8192)) {
            item.fix();
        }
        this.useAnimation();
    }

    @Override
    public int value() {
        return 30 * this.quantity;
    }

    @Override
    public int energyVal() {
        return 4 * this.quantity;
    }

    public static class Recipe6
    extends Recipe.SimpleRecipe {
        public Recipe6() {
            this.inputs = new Class[]{Saber_Energy.class};
            this.inQuantity = new int[]{1};
            this.cost = 15;
            this.output = StoneOfEnchantment.class;
            this.outQuantity = 2;
        }
    }

    public static class Recipe5
    extends Recipe.SimpleRecipe {
        public Recipe5() {
            this.inputs = new Class[]{WornKatana_Energy.class};
            this.inQuantity = new int[]{1};
            this.cost = 15;
            this.output = StoneOfEnchantment.class;
            this.outQuantity = 2;
        }
    }

    public static class Recipe4
    extends Recipe.SimpleRecipe {
        public Recipe4() {
            this.inputs = new Class[]{CrudePistol_Energy.class};
            this.inQuantity = new int[]{1};
            this.cost = 15;
            this.output = StoneOfEnchantment.class;
            this.outQuantity = 2;
        }
    }

    public static class Recipe3
    extends Recipe.SimpleRecipe {
        public Recipe3() {
            this.inputs = new Class[]{Gloves_Energy.class};
            this.inQuantity = new int[]{1};
            this.cost = 15;
            this.output = StoneOfEnchantment.class;
            this.outQuantity = 2;
        }
    }

    public static class Recipe2
    extends Recipe.SimpleRecipe {
        public Recipe2() {
            this.inputs = new Class[]{Dagger_Energy.class};
            this.inQuantity = new int[]{1};
            this.cost = 15;
            this.output = StoneOfEnchantment.class;
            this.outQuantity = 2;
        }
    }

    public static class Recipe1
    extends Recipe.SimpleRecipe {
        public Recipe1() {
            this.inputs = new Class[]{WornShortsword_Energy.class};
            this.inQuantity = new int[]{1};
            this.cost = 15;
            this.output = StoneOfEnchantment.class;
            this.outQuantity = 2;
        }
    }
}

