/*
 * Decompiled with CFR 0.152.
 */
package com.shatteredpixel.shatteredpixeldungeon.items.weapon;

import com.shatteredpixel.shatteredpixeldungeon.Dungeon;
import com.shatteredpixel.shatteredpixeldungeon.actors.Actor;
import com.shatteredpixel.shatteredpixeldungeon.actors.Char;
import com.shatteredpixel.shatteredpixeldungeon.actors.buffs.Buff;
import com.shatteredpixel.shatteredpixeldungeon.actors.buffs.RevealedArea;
import com.shatteredpixel.shatteredpixeldungeon.actors.hero.Hero;
import com.shatteredpixel.shatteredpixeldungeon.actors.hero.Talent;
import com.shatteredpixel.shatteredpixeldungeon.actors.hero.abilities.huntress.NaturesPower;
import com.shatteredpixel.shatteredpixeldungeon.actors.mobs.Mob;
import com.shatteredpixel.shatteredpixeldungeon.effects.Splash;
import com.shatteredpixel.shatteredpixeldungeon.effects.particles.LeafParticle;
import com.shatteredpixel.shatteredpixeldungeon.items.Item;
import com.shatteredpixel.shatteredpixeldungeon.items.rings.RingOfSharpshooting;
import com.shatteredpixel.shatteredpixeldungeon.items.weapon.Weapon;
import com.shatteredpixel.shatteredpixeldungeon.items.weapon.missiles.MissileWeapon;
import com.shatteredpixel.shatteredpixeldungeon.messages.Messages;
import com.shatteredpixel.shatteredpixeldungeon.plants.Blindweed;
import com.shatteredpixel.shatteredpixeldungeon.plants.Firebloom;
import com.shatteredpixel.shatteredpixeldungeon.plants.Icecap;
import com.shatteredpixel.shatteredpixeldungeon.plants.Plant;
import com.shatteredpixel.shatteredpixeldungeon.plants.Sorrowmoss;
import com.shatteredpixel.shatteredpixeldungeon.plants.Stormvine;
import com.shatteredpixel.shatteredpixeldungeon.scenes.CellSelector;
import com.shatteredpixel.shatteredpixeldungeon.scenes.GameScene;
import com.shatteredpixel.shatteredpixeldungeon.sprites.ItemSpriteSheet;
import com.shatteredpixel.shatteredpixeldungeon.sprites.MissileSprite;
import com.shatteredpixel.shatteredpixeldungeon.ui.QuickSlotButton;
import com.watabou.noosa.Visual;
import com.watabou.noosa.audio.Sample;
import com.watabou.noosa.particles.Emitter;
import com.watabou.utils.Callback;
import com.watabou.utils.Random;
import com.watabou.utils.Reflection;
import java.util.ArrayList;

public class WindBow
extends Weapon {
    public static final String AC_SHOOT = "SHOOT";
    public boolean sniperSpecial;
    public float sniperSpecialBonusDamage;
    private static Class[] harmfulPlants = new Class[]{Blindweed.class, Firebloom.class, Icecap.class, Sorrowmoss.class, Stormvine.class};
    private int targetPos;
    private CellSelector.Listener shooter;

    public WindBow() {
        this.image = ItemSpriteSheet.WIND_BOW;
        this.defaultAction = AC_SHOOT;
        this.usesTargeting = true;
        this.unique = true;
        this.bones = false;
        this.canAdvance = true;
        this.sniperSpecial = false;
        this.sniperSpecialBonusDamage = 0.0f;
        this.shooter = new CellSelector.Listener(){

            @Override
            public void onSelect(Integer target) {
                if (target != null) {
                    WindBow.this.knockArrow().cast(curUser, target);
                }
            }

            @Override
            public String prompt() {
                return Messages.get(WindBow.class, "prompt", new Object[0]);
            }
        };
    }

    @Override
    public ArrayList<String> actions(Hero hero) {
        ArrayList<String> actions = super.actions(hero);
        actions.remove("EQUIP");
        actions.add(AC_SHOOT);
        return actions;
    }

    @Override
    public void execute(Hero hero, String action) {
        super.execute(hero, action);
        if (action.equals(AC_SHOOT)) {
            curUser = hero;
            curItem = this;
            GameScene.selectCell(this.shooter);
        }
    }

    @Override
    public int proc(final Char attacker, final Char defender, int damage) {
        if (attacker.buff(NaturesPower.naturesPowerTracker.class) != null && !this.sniperSpecial) {
            Actor.add(new Actor(){
                {
                    this.actPriority = 100;
                }

                @Override
                protected boolean act() {
                    NaturesPower.naturesPowerTracker tracker;
                    if (Random.Int(12) < ((Hero)attacker).pointsInTalent(Talent.NATURES_WRATH)) {
                        Plant plant = (Plant)Reflection.newInstance(Random.element(harmfulPlants));
                        plant.pos = defender.pos;
                        plant.activate(defender.isAlive() ? defender : null);
                    }
                    if (!defender.isAlive() && (tracker = attacker.buff(NaturesPower.naturesPowerTracker.class)) != null) {
                        tracker.extend(((Hero)attacker).pointsInTalent(Talent.WILD_MOMENTUM));
                    }
                    Actor.remove(this);
                    return true;
                }
            });
        }
        return super.proc(attacker, defender, damage);
    }

    @Override
    public String info() {
        String info = this.desc();
        info = info + "\n\n" + Messages.get(WindBow.class, "stats", Math.round(this.augment.damageFactor(this.min())), Math.round(this.augment.damageFactor(this.max())), this.STRReq());
        if (this.STRReq() > Dungeon.hero.STR()) {
            info = info + " " + Messages.get(Weapon.class, "too_heavy", new Object[0]);
        } else if (Dungeon.hero.STR() > this.STRReq()) {
            info = info + " " + Messages.get(Weapon.class, "excess_str", Dungeon.hero.STR() - this.STRReq());
        }
        switch (this.augment) {
            case SPEED: {
                info = info + "\n\n" + Messages.get(Weapon.class, "faster", new Object[0]);
                break;
            }
            case DAMAGE: {
                info = info + "\n\n" + Messages.get(Weapon.class, "stronger", new Object[0]);
                break;
            }
        }
        if (this.enchantment != null && (this.cursedKnown || !this.enchantment.curse())) {
            info = info + "\n\n" + Messages.get(Weapon.class, "enchanted", this.enchantment.name());
            info = info + " " + Messages.get(this.enchantment, "desc", new Object[0]);
        }
        if (this.cursed && this.isEquipped(Dungeon.hero)) {
            info = info + "\n\n" + Messages.get(Weapon.class, "cursed_worn", new Object[0]);
        } else if (this.cursedKnown && this.cursed) {
            info = info + "\n\n" + Messages.get(Weapon.class, "cursed", new Object[0]);
        } else if (!this.isIdentified() && this.cursedKnown) {
            info = info + "\n\n" + Messages.get(Weapon.class, "not_cursed", new Object[0]);
        }
        info = info + "\n\n" + Messages.get(MissileWeapon.class, "distance", new Object[0]);
        return info;
    }

    @Override
    public int STRReq(int lvl) {
        return WindBow.STRReq(1, lvl) - 2;
    }

    @Override
    public int min(int lvl) {
        int dmg = 1 + Dungeon.hero.lvl / 5 + RingOfSharpshooting.levelDamageBonus(Dungeon.hero) + (this.curseInfusionBonus ? 1 + Dungeon.hero.lvl / 30 : 0);
        return Math.max(0, Math.round((float)dmg * 0.7f));
    }

    @Override
    public int max(int lvl) {
        int dmg = 6 + (int)((float)Dungeon.hero.lvl / 2.5f) + 2 * RingOfSharpshooting.levelDamageBonus(Dungeon.hero) + (this.curseInfusionBonus ? 2 + Dungeon.hero.lvl / 15 : 0);
        return Math.max(0, Math.round((float)dmg * 0.7f));
    }

    @Override
    public int targetingPos(Hero user, int dst) {
        return this.knockArrow().targetingPos(user, dst);
    }

    @Override
    public int damageRoll(Char owner) {
        int exStr;
        int damage = this.augment.damageFactor(super.damageRoll(owner));
        if (owner instanceof Hero && (exStr = ((Hero)owner).STR() - this.STRReq()) > 0) {
            damage += Random.IntRange(0, exStr);
        }
        if (this.sniperSpecial) {
            damage = Math.round((float)damage * (1.0f + this.sniperSpecialBonusDamage));
            switch (this.augment) {
                case NONE: {
                    damage = Math.round((float)damage * 0.667f);
                    break;
                }
                case SPEED: {
                    damage = Math.round((float)damage * 0.5f);
                    break;
                }
                case DAMAGE: {
                    int distance = Dungeon.level.distance(owner.pos, this.targetPos) - 1;
                    float multiplier = Math.min(3.0f, 1.2f * (float)Math.pow(1.125, distance));
                    damage = Math.round((float)damage * multiplier);
                }
            }
        }
        return damage;
    }

    @Override
    protected float baseDelay(Char owner) {
        if (this.sniperSpecial) {
            switch (this.augment) {
                default: {
                    return 0.0f;
                }
                case SPEED: {
                    return 1.0f;
                }
                case DAMAGE: 
            }
            return 2.0f;
        }
        return super.baseDelay(owner);
    }

    @Override
    protected float speedMultiplier(Char owner) {
        float speed = super.speedMultiplier(owner);
        if (owner.buff(NaturesPower.naturesPowerTracker.class) != null) {
            speed += (float)(8 + ((Hero)owner).pointsInTalent(Talent.GROWING_POWER)) / 24.0f;
        }
        return speed;
    }

    @Override
    public int level() {
        int level;
        int n = level = Dungeon.hero == null ? 0 : Dungeon.hero.lvl / 5;
        if (this.curseInfusionBonus) {
            level += 1 + level / 6;
        }
        return level;
    }

    @Override
    public int buffedLvl() {
        return this.level();
    }

    @Override
    public boolean isUpgradable() {
        return false;
    }

    public SpiritArrow knockArrow() {
        return new SpiritArrow();
    }

    public class SpiritArrow
    extends MissileWeapon {
        int flurryCount;
        Actor flurryActor;

        public SpiritArrow() {
            this.image = ItemSpriteSheet.WIND_ARROW;
            this.hitSound = "sounds/hit_arrow.mp3";
            this.flurryCount = -1;
            this.flurryActor = null;
        }

        @Override
        public Emitter emitter() {
            if (Dungeon.hero.buff(NaturesPower.naturesPowerTracker.class) != null && !WindBow.this.sniperSpecial) {
                Emitter e = new Emitter();
                e.pos(5.0f, 5.0f);
                e.fillTarget = false;
                e.pour(LeafParticle.GENERAL, 0.01f);
                return e;
            }
            return super.emitter();
        }

        @Override
        public int damageRoll(Char owner) {
            return WindBow.this.damageRoll(owner);
        }

        @Override
        public boolean hasEnchant(Class<? extends Weapon.Enchantment> type, Char owner) {
            return WindBow.this.hasEnchant(type, owner);
        }

        @Override
        public int proc(Char attacker, Char defender, int damage) {
            return WindBow.this.proc(attacker, defender, damage);
        }

        @Override
        public float delayFactor(Char user) {
            return WindBow.this.delayFactor(user);
        }

        @Override
        public float accuracyFactor(Char owner, Char target) {
            if (WindBow.this.sniperSpecial && WindBow.this.augment == Weapon.Augment.DAMAGE) {
                return Float.POSITIVE_INFINITY;
            }
            return super.accuracyFactor(owner, target);
        }

        @Override
        public int STRReq(int lvl) {
            return WindBow.this.STRReq(lvl);
        }

        @Override
        protected void onThrow(int cell) {
            Char enemy = Actor.findChar(cell);
            if (enemy == null || enemy == curUser) {
                this.parent = null;
                Splash.at(cell, -855638017, 1);
            } else {
                for (int i = 0; i < 1 + Random.Int(3) && enemy.isAlive(); ++i) {
                    if (curUser.shoot(enemy, this)) continue;
                    Splash.at(cell, -855638017, 1 + Random.Int(2));
                }
                if (WindBow.this.sniperSpecial && WindBow.this.augment != Weapon.Augment.SPEED) {
                    WindBow.this.sniperSpecial = false;
                }
            }
        }

        @Override
        public void throwSound() {
            Sample.INSTANCE.play("sounds/atk_spiritbow.mp3", 1.0f, Random.Float(0.87f, 1.15f));
        }

        @Override
        public void cast(final Hero user, final int dst) {
            final int cell = this.throwPos(user, dst);
            WindBow.this.targetPos = cell;
            if (WindBow.this.sniperSpecial && WindBow.this.augment == Weapon.Augment.SPEED) {
                Char enemy;
                if (this.flurryCount == -1) {
                    this.flurryCount = 3;
                }
                if ((enemy = Actor.findChar(cell)) == null) {
                    user.spendAndNext(this.castDelay(user, dst));
                    WindBow.this.sniperSpecial = false;
                    this.flurryCount = -1;
                    if (this.flurryActor != null) {
                        this.flurryActor.next();
                        this.flurryActor = null;
                    }
                    return;
                }
                QuickSlotButton.target(enemy);
                final boolean last = this.flurryCount == 1;
                user.busy();
                this.throwSound();
                ((MissileSprite)user.sprite.parent.recycle(MissileSprite.class)).reset((Visual)user.sprite, cell, (Item)this, new Callback(){

                    @Override
                    public void call() {
                        if (enemy.isAlive()) {
                            curUser = user;
                            SpiritArrow.this.onThrow(cell);
                        }
                        if (last) {
                            user.spendAndNext(SpiritArrow.this.castDelay(user, dst));
                            WindBow.this.sniperSpecial = false;
                            SpiritArrow.this.flurryCount = -1;
                        }
                        if (SpiritArrow.this.flurryActor != null) {
                            SpiritArrow.this.flurryActor.next();
                            SpiritArrow.this.flurryActor = null;
                        }
                    }
                });
                user.sprite.zap(cell, new Callback(){

                    @Override
                    public void call() {
                        --SpiritArrow.this.flurryCount;
                        if (SpiritArrow.this.flurryCount > 0) {
                            Actor.add(new Actor(){
                                {
                                    this.actPriority = 99;
                                }

                                @Override
                                protected boolean act() {
                                    SpiritArrow.this.flurryActor = this;
                                    int target = QuickSlotButton.autoAim(enemy, SpiritArrow.this);
                                    if (target == -1) {
                                        target = cell;
                                    }
                                    SpiritArrow.this.cast(user, target);
                                    Actor.remove(this);
                                    return false;
                                }
                            });
                            curUser.next();
                        }
                    }
                });
            } else {
                int shotPos;
                if (user.hasTalent(Talent.SEER_SHOT) && user.buff(Talent.SeerShotCooldown.class) == null && Actor.findChar(shotPos = this.throwPos(user, dst)) == null) {
                    RevealedArea a = Buff.affect(user, RevealedArea.class, 5 * user.pointsInTalent(Talent.SEER_SHOT));
                    a.depth = Dungeon.depth;
                    a.pos = shotPos;
                    Buff.affect(user, Talent.SeerShotCooldown.class, 20.0f);
                }
                if (user.hasTalent(Talent.ATTRACTION)) {
                    shotPos = this.throwPos(user, dst);
                    for (Mob mob : Dungeon.level.mobs.toArray(new Mob[0])) {
                        if (mob.paralysed > 0 || Dungeon.level.distance(shotPos, mob.pos) > user.pointsInTalent(Talent.ATTRACTION) || mob.state == mob.HUNTING) continue;
                        mob.beckon(shotPos);
                    }
                }
                super.cast(user, dst);
            }
        }
    }
}

