/*
 * Decompiled with CFR 0.152.
 */
package com.shatteredpixel.shatteredpixeldungeon.items.weapon.enchantments;

import com.shatteredpixel.shatteredpixeldungeon.actors.Char;
import com.shatteredpixel.shatteredpixeldungeon.actors.buffs.Barrier;
import com.shatteredpixel.shatteredpixeldungeon.actors.buffs.Buff;
import com.shatteredpixel.shatteredpixeldungeon.actors.buffs.ShieldBuff;
import com.shatteredpixel.shatteredpixeldungeon.effects.Speck;
import com.shatteredpixel.shatteredpixeldungeon.items.weapon.Weapon;
import com.shatteredpixel.shatteredpixeldungeon.items.weapon.melee.TrueRunicBlade;
import com.shatteredpixel.shatteredpixeldungeon.messages.Messages;
import com.shatteredpixel.shatteredpixeldungeon.sprites.CharSprite;
import com.shatteredpixel.shatteredpixeldungeon.sprites.ItemSprite;
import com.watabou.noosa.Image;
import com.watabou.utils.Random;

public class Blocking
extends Weapon.Enchantment {
    private static ItemSprite.Glowing BLUE = new ItemSprite.Glowing(255);

    @Override
    public int proc(Weapon weapon, Char attacker, Char defender, int damage) {
        int level = Math.max(0, weapon.buffedLvl());
        float procChance = ((float)level + 4.0f) / ((float)level + 40.0f) * this.procChanceMultiplier(attacker);
        if (weapon instanceof TrueRunicBlade) {
            procChance = 1.0f;
        }
        if (Random.Float() < procChance) {
            float powerMulti = Math.max(1.0f, procChance);
            BlockBuff b = Buff.affect(attacker, BlockBuff.class);
            b.setShield(Math.round(powerMulti * (float)(2 + weapon.buffedLvl())));
            attacker.sprite.emitter().burst(Speck.factory(2), 5);
        }
        return damage;
    }

    @Override
    public ItemSprite.Glowing glowing() {
        return BLUE;
    }

    public static class BlockBuff
    extends ShieldBuff {
        public BlockBuff() {
            this.type = Buff.buffType.POSITIVE;
        }

        @Override
        public boolean act() {
            this.detach();
            return true;
        }

        @Override
        public void setShield(int shield) {
            super.setShield(shield);
            this.postpone(5.0f);
        }

        @Override
        public void fx(boolean on) {
            if (on) {
                this.target.sprite.add(CharSprite.State.SHIELDED);
            } else if (this.target.buff(Barrier.class) == null) {
                this.target.sprite.remove(CharSprite.State.SHIELDED);
            }
        }

        @Override
        public int icon() {
            return 20;
        }

        @Override
        public void tintIcon(Image icon) {
            icon.hardlight(0.5f, 1.0f, 2.0f);
        }

        @Override
        public float iconFadePercent() {
            return Math.max(0.0f, (5.0f - this.visualcooldown()) / 5.0f);
        }

        @Override
        public String iconTextDisplay() {
            return Integer.toString((int)this.visualcooldown());
        }

        @Override
        public String desc() {
            return Messages.get(this, "desc", this.shielding(), this.dispTurns(this.visualcooldown()));
        }
    }
}

