/*
 * Decompiled with CFR 0.152.
 */
package com.shatteredpixel.shatteredpixeldungeon.items.weapon.melee;

import com.shatteredpixel.shatteredpixeldungeon.Dungeon;
import com.shatteredpixel.shatteredpixeldungeon.actors.Char;
import com.shatteredpixel.shatteredpixeldungeon.actors.buffs.Adrenaline;
import com.shatteredpixel.shatteredpixeldungeon.actors.buffs.AllyBuff;
import com.shatteredpixel.shatteredpixeldungeon.actors.buffs.Bless;
import com.shatteredpixel.shatteredpixeldungeon.actors.buffs.Buff;
import com.shatteredpixel.shatteredpixeldungeon.actors.buffs.FlavourBuff;
import com.shatteredpixel.shatteredpixeldungeon.actors.buffs.LostInventory;
import com.shatteredpixel.shatteredpixeldungeon.actors.hero.Hero;
import com.shatteredpixel.shatteredpixeldungeon.effects.CellEmitter;
import com.shatteredpixel.shatteredpixeldungeon.effects.Speck;
import com.shatteredpixel.shatteredpixeldungeon.items.potions.exotic.PotionOfCleansing;
import com.shatteredpixel.shatteredpixeldungeon.items.weapon.melee.MeleeWeapon;
import com.shatteredpixel.shatteredpixeldungeon.sprites.HeroSprite;
import com.shatteredpixel.shatteredpixeldungeon.sprites.ItemSpriteSheet;
import com.watabou.noosa.audio.Sample;

public class Bible
extends MeleeWeapon {
    public Bible() {
        this.image = ItemSpriteSheet.BIBLE;
        this.hitSound = "sounds/hit.mp3";
        this.hitSoundPitch = 1.1f;
        this.tier = 3;
    }

    @Override
    public int proc(Char attacker, Char defender, int damage) {
        if (attacker.buff(Bless.class) == null) {
            Buff.affect(attacker, Bless.class, 2.0f);
        } else if (attacker.buff(PotionOfCleansing.Cleanse.class) == null) {
            for (Buff b : attacker.buffs()) {
                if (b.type != Buff.buffType.NEGATIVE || b instanceof AllyBuff || b instanceof LostInventory) continue;
                b.detach();
            }
            Buff.affect(attacker, PotionOfCleansing.Cleanse.class, 2.0f);
        } else if (attacker.buff(Adrenaline.class) == null) {
            Buff.affect(attacker, Adrenaline.class, 2.0f);
        } else {
            int healAmt = 1;
            attacker.heal(healAmt);
        }
        return super.proc(attacker, defender, damage);
    }

    @Override
    public int max(int lvl) {
        return 3 * (this.tier + 1) + lvl * this.tier;
    }

    @Override
    protected int baseChargeUse(Hero hero, Char target) {
        return 2;
    }

    @Override
    protected void duelistAbility(Hero hero, Integer target) {
        Bible.angelAbility(hero, 5, this);
    }

    public static void angelAbility(Hero hero, int duration, MeleeWeapon wep) {
        wep.beforeAbilityUsed(hero, null);
        Buff.prolong(hero, Angel.class, duration);
        hero.next();
        ((HeroSprite)hero.sprite).read();
        CellEmitter.get(Dungeon.hero.pos).burst(Speck.factory(7), 6);
        Sample.INSTANCE.play("sounds/puff.mp3");
        Sample.INSTANCE.play("sounds/read.mp3");
        wep.afterAbilityUsed(hero);
    }

    public static class Angel
    extends FlavourBuff {
        public Angel() {
            this.announced = true;
            this.type = Buff.buffType.POSITIVE;
        }

        @Override
        public int icon() {
            return 154;
        }

        @Override
        public float iconFadePercent() {
            return Math.max(0.0f, (6.0f - this.visualcooldown()) / 6.0f);
        }
    }
}

