/*
 * Decompiled with CFR 0.152.
 */
package com.shatteredpixel.shatteredpixeldungeon.items.weapon.melee;

import com.shatteredpixel.shatteredpixeldungeon.Dungeon;
import com.shatteredpixel.shatteredpixeldungeon.actors.Actor;
import com.shatteredpixel.shatteredpixeldungeon.actors.Char;
import com.shatteredpixel.shatteredpixeldungeon.actors.buffs.Buff;
import com.shatteredpixel.shatteredpixeldungeon.actors.buffs.FlavourBuff;
import com.shatteredpixel.shatteredpixeldungeon.actors.hero.Hero;
import com.shatteredpixel.shatteredpixeldungeon.items.LiquidMetal;
import com.shatteredpixel.shatteredpixeldungeon.items.Recipe;
import com.shatteredpixel.shatteredpixeldungeon.items.weapon.melee.ChainWhip;
import com.shatteredpixel.shatteredpixeldungeon.items.weapon.melee.Flail;
import com.shatteredpixel.shatteredpixeldungeon.items.weapon.melee.MeleeWeapon;
import com.shatteredpixel.shatteredpixeldungeon.messages.Messages;
import com.shatteredpixel.shatteredpixeldungeon.sprites.ItemSpriteSheet;
import com.shatteredpixel.shatteredpixeldungeon.ui.BuffIndicator;
import com.shatteredpixel.shatteredpixeldungeon.utils.GLog;
import com.watabou.noosa.Image;
import com.watabou.noosa.audio.Sample;
import com.watabou.utils.Bundle;

public class ChainFlail
extends MeleeWeapon {
    private static float spinBonus = 1.0f;

    public ChainFlail() {
        this.image = ItemSpriteSheet.CHAIN_FLAIL;
        this.hitSound = "sounds/hit_crush.mp3";
        this.hitSoundPitch = 0.8f;
        this.tier = 6;
        this.RCH = 2;
        this.ACC = 0.8f;
        this.alchemy = true;
    }

    @Override
    public int max(int lvl) {
        return Math.round(7 * this.tier) + lvl * (this.tier + 3);
    }

    @Override
    public float accuracyFactor(final Char owner, final Char target) {
        SpinAbilityTracker spin = owner.buff(SpinAbilityTracker.class);
        if (spin != null) {
            Actor.add(new Actor(){
                {
                    this.actPriority = 100;
                }

                @Override
                protected boolean act() {
                    if (owner instanceof Hero && !target.isAlive()) {
                        MeleeWeapon.onAbilityKill((Hero)owner, target);
                    }
                    Actor.remove(this);
                    return true;
                }
            });
            spin.detach();
            spinBonus = 1.0f + 0.2f * (float)spin.spins;
            if (spinBonus == 1.6f) {
                return Float.POSITIVE_INFINITY;
            }
            return super.accuracyFactor(owner, target);
        }
        spinBonus = 1.0f;
        return super.accuracyFactor(owner, target);
    }

    @Override
    protected int baseChargeUse(Hero hero, Char target) {
        if (Dungeon.hero.buff(SpinAbilityTracker.class) != null) {
            return 0;
        }
        return 2;
    }

    @Override
    protected void duelistAbility(Hero hero, Integer target) {
        this.beforeAbilityUsed(hero, null);
        SpinAbilityTracker spin = hero.buff(SpinAbilityTracker.class);
        if (spin == null) {
            spin = Buff.affect(hero, SpinAbilityTracker.class, 3.0f);
        }
        if (spin.spins < 3) {
            ++spin.spins;
            Buff.prolong(hero, SpinAbilityTracker.class, 3.0f);
            Sample.INSTANCE.play("sounds/chains.mp3", 1.0f, 1.0f, 0.9f + 0.1f * (float)spin.spins);
            hero.sprite.operate(hero.pos);
            hero.spendAndNext(1.0f);
            BuffIndicator.refreshHero();
        } else {
            GLog.w(Messages.get(this, "spin_warn", new Object[0]), new Object[0]);
        }
        this.afterAbilityUsed(hero);
    }

    public static class SpinAbilityTracker
    extends FlavourBuff {
        public int spins;
        public static String SPINS = "spins";

        public SpinAbilityTracker() {
            this.type = Buff.buffType.POSITIVE;
            this.spins = 0;
        }

        @Override
        public int icon() {
            return 62;
        }

        @Override
        public void tintIcon(Image icon) {
            switch (this.spins) {
                default: {
                    icon.hardlight(0.0f, 1.0f, 0.0f);
                    break;
                }
                case 2: {
                    icon.hardlight(1.0f, 1.0f, 0.0f);
                    break;
                }
                case 3: {
                    icon.hardlight(1.0f, 0.0f, 0.0f);
                }
            }
        }

        @Override
        public float iconFadePercent() {
            return Math.max(0.0f, (3.0f - this.visualcooldown()) / 3.0f);
        }

        @Override
        public String desc() {
            return Messages.get(this, "desc", Float.valueOf((float)this.spins * 0.2f));
        }

        @Override
        public void storeInBundle(Bundle bundle) {
            super.storeInBundle(bundle);
            bundle.put(SPINS, this.spins);
        }

        @Override
        public void restoreFromBundle(Bundle bundle) {
            super.restoreFromBundle(bundle);
            this.spins = bundle.getInt(SPINS);
        }
    }

    public static class Recipe
    extends Recipe.SimpleRecipe {
        public Recipe() {
            this.inputs = new Class[]{ChainWhip.class, Flail.class, LiquidMetal.class};
            this.inQuantity = new int[]{1, 1, 60};
            this.cost = 5;
            this.output = ChainFlail.class;
            this.outQuantity = 1;
        }
    }
}

