/*
 * Decompiled with CFR 0.152.
 */
package com.shatteredpixel.shatteredpixeldungeon.items.weapon.melee;

import com.shatteredpixel.shatteredpixeldungeon.Dungeon;
import com.shatteredpixel.shatteredpixeldungeon.actors.Char;
import com.shatteredpixel.shatteredpixeldungeon.actors.buffs.Buff;
import com.shatteredpixel.shatteredpixeldungeon.actors.buffs.Burning;
import com.shatteredpixel.shatteredpixeldungeon.actors.hero.Hero;
import com.shatteredpixel.shatteredpixeldungeon.items.LiquidMetal;
import com.shatteredpixel.shatteredpixeldungeon.items.Recipe;
import com.shatteredpixel.shatteredpixeldungeon.items.potions.elixirs.ElixirOfDragonsBlood;
import com.shatteredpixel.shatteredpixeldungeon.items.weapon.melee.MeleeWeapon;
import com.shatteredpixel.shatteredpixeldungeon.items.weapon.melee.Scimitar;
import com.shatteredpixel.shatteredpixeldungeon.sprites.ItemSpriteSheet;
import com.watabou.utils.Random;

public class FlameScimitar
extends MeleeWeapon {
    public FlameScimitar() {
        this.image = ItemSpriteSheet.FLAME_SCIMITAR;
        this.hitSound = "sounds/hit_slash.mp3";
        this.hitSoundPitch = 1.2f;
        this.tier = 4;
        this.DLY = 0.8f;
        this.alchemy = true;
    }

    @Override
    public int proc(Char attacker, Char defender, int damage) {
        float procChance = 0.5f;
        if (Random.Float() < procChance) {
            if (defender.buff(Burning.class) != null) {
                Buff.affect(defender, Burning.class).reignite(defender, 8.0f);
                int burnDamage = Random.NormalIntRange(1, 3 + Dungeon.depth / 4);
                defender.damage(Math.round((float)burnDamage * 0.67f), this);
            } else {
                Buff.affect(defender, Burning.class).reignite(defender, 8.0f);
            }
        }
        return super.proc(attacker, defender, damage);
    }

    @Override
    public int max(int lvl) {
        return 4 * (this.tier + 1) + lvl * (this.tier + 1);
    }

    @Override
    protected int baseChargeUse(Hero hero, Char target) {
        return 2;
    }

    @Override
    protected void duelistAbility(Hero hero, Integer target) {
        this.beforeAbilityUsed(hero, null);
        Buff.prolong(hero, Scimitar.SwordDance.class, 5.0f);
        hero.sprite.operate(hero.pos);
        hero.next();
        this.afterAbilityUsed(hero);
    }

    public static class Recipe
    extends Recipe.SimpleRecipe {
        public Recipe() {
            this.inputs = new Class[]{Scimitar.class, ElixirOfDragonsBlood.class, LiquidMetal.class};
            this.inQuantity = new int[]{1, 1, 40};
            this.cost = 5;
            this.output = FlameScimitar.class;
            this.outQuantity = 1;
        }
    }
}

