/*
 * Decompiled with CFR 0.152.
 */
package com.shatteredpixel.shatteredpixeldungeon.items.weapon.melee;

import com.shatteredpixel.shatteredpixeldungeon.Dungeon;
import com.shatteredpixel.shatteredpixeldungeon.actors.Actor;
import com.shatteredpixel.shatteredpixeldungeon.actors.Char;
import com.shatteredpixel.shatteredpixeldungeon.actors.buffs.Paralysis;
import com.shatteredpixel.shatteredpixeldungeon.actors.hero.Hero;
import com.shatteredpixel.shatteredpixeldungeon.effects.Pushing;
import com.shatteredpixel.shatteredpixeldungeon.items.LiquidMetal;
import com.shatteredpixel.shatteredpixeldungeon.items.Recipe;
import com.shatteredpixel.shatteredpixeldungeon.items.wands.WandOfBlastWave;
import com.shatteredpixel.shatteredpixeldungeon.items.weapon.melee.Gauntlet;
import com.shatteredpixel.shatteredpixeldungeon.items.weapon.melee.MeleeWeapon;
import com.shatteredpixel.shatteredpixeldungeon.items.weapon.missiles.ForceCube;
import com.shatteredpixel.shatteredpixeldungeon.mechanics.Ballistica;
import com.shatteredpixel.shatteredpixeldungeon.messages.Messages;
import com.shatteredpixel.shatteredpixeldungeon.scenes.GameScene;
import com.shatteredpixel.shatteredpixeldungeon.sprites.ItemSpriteSheet;
import com.shatteredpixel.shatteredpixeldungeon.utils.GLog;
import com.watabou.noosa.audio.Sample;
import com.watabou.utils.Callback;
import com.watabou.utils.Random;

public class ForceGlove
extends MeleeWeapon {
    public ForceGlove() {
        this.image = ItemSpriteSheet.FORCE_GLOVE;
        this.hitSound = "sounds/hit_crush.mp3";
        this.hitSoundPitch = 1.2f;
        this.tier = 6;
        this.RCH = 2;
        this.alchemy = true;
    }

    @Override
    public int proc(Char attacker, Char defender, int damage) {
        if (Dungeon.level.adjacent(attacker.pos, defender.pos)) {
            damage = (int)((float)damage * 0.5f);
            Ballistica trajectory = new Ballistica(attacker.pos, defender.pos, 1);
            trajectory = new Ballistica(trajectory.collisionPos, trajectory.path.get(trajectory.path.size() - 1), 7);
            WandOfBlastWave.throwChar(defender, trajectory, 20, true, true, Dungeon.hero.getClass());
        }
        return super.proc(attacker, defender, damage);
    }

    @Override
    public int max(int lvl) {
        return 5 * this.tier + lvl * this.tier;
    }

    @Override
    public String targetingPrompt() {
        return Messages.get(this, "prompt", new Object[0]);
    }

    @Override
    protected void duelistAbility(Hero hero, Integer target) {
        ForceGlove.forceAbility(hero, target, this);
    }

    public static void forceAbility(final Hero hero, Integer target, MeleeWeapon wep) {
        if (target == null || target == -1) {
            return;
        }
        int range = 6;
        if (Dungeon.level.distance(hero.pos, target) > range || Dungeon.level.distance(hero.pos, target) <= 1) {
            GLog.w(Messages.get(MeleeWeapon.class, "ability_bad_position", new Object[0]), new Object[0]);
            return;
        }
        Ballistica chain = new Ballistica(ForceGlove.curUser.pos, target, 1);
        final Char ch = Actor.findChar(target);
        if (ch == null || !Dungeon.level.heroFOV[target]) {
            GLog.w(Messages.get(ForceGlove.class, "no_target", new Object[0]), new Object[0]);
            return;
        }
        if (ch.properties().contains((Object)Char.Property.IMMOVABLE)) {
            GLog.w(Messages.get(ForceGlove.class, "immovable", new Object[0]), new Object[0]);
            return;
        }
        int bestPos = -1;
        for (int i : chain.subPath(1, chain.dist)) {
            if (Dungeon.level.solid[i] || Actor.findChar(i) != null || Char.hasProp(ch, Char.Property.LARGE) && !Dungeon.level.openSpace[i]) continue;
            bestPos = i;
            break;
        }
        if (bestPos == -1) {
            GLog.i(Messages.get(ForceGlove.class, "does_nothing", new Object[0]), new Object[0]);
            return;
        }
        final int pulledPos = bestPos;
        final int finalDist = Dungeon.level.distance(target, bestPos);
        wep.beforeAbilityUsed(hero, ch);
        WandOfBlastWave.BlastWave.blast(target);
        Sample.INSTANCE.play("sounds/blast.mp3");
        hero.sprite.zap(target);
        Actor.add(new Pushing(ch, ch.pos, pulledPos, new Callback(){

            @Override
            public void call() {
                ch.pos = pulledPos;
                Dungeon.level.occupyCell(ch);
                Dungeon.observe();
                GameScene.updateFog();
                ch.damage(Random.NormalIntRange(finalDist, 2 * finalDist), curUser);
                if (ch.isAlive()) {
                    Paralysis.prolong(ch, Paralysis.class, 1.0f + (float)finalDist / 2.0f);
                }
                hero.spendAndNext(1.0f);
            }
        }));
        hero.busy();
        hero.next();
        wep.afterAbilityUsed(hero);
    }

    public static class Recipe
    extends Recipe.SimpleRecipe {
        public Recipe() {
            this.inputs = new Class[]{Gauntlet.class, ForceCube.class, LiquidMetal.class};
            this.inQuantity = new int[]{1, 1, 60};
            this.cost = 10;
            this.output = ForceGlove.class;
            this.outQuantity = 1;
        }
    }
}

