/*
 * Decompiled with CFR 0.152.
 */
package com.shatteredpixel.shatteredpixeldungeon.items.weapon.melee;

import com.shatteredpixel.shatteredpixeldungeon.Dungeon;
import com.shatteredpixel.shatteredpixeldungeon.actors.Actor;
import com.shatteredpixel.shatteredpixeldungeon.actors.Char;
import com.shatteredpixel.shatteredpixeldungeon.actors.buffs.Barrier;
import com.shatteredpixel.shatteredpixeldungeon.actors.buffs.Bless;
import com.shatteredpixel.shatteredpixeldungeon.actors.buffs.Buff;
import com.shatteredpixel.shatteredpixeldungeon.actors.buffs.FlavourBuff;
import com.shatteredpixel.shatteredpixeldungeon.actors.buffs.Frost;
import com.shatteredpixel.shatteredpixeldungeon.actors.buffs.FrostDartCoolDown;
import com.shatteredpixel.shatteredpixeldungeon.actors.buffs.GrenadeCoolDown;
import com.shatteredpixel.shatteredpixeldungeon.actors.buffs.MagicImmune;
import com.shatteredpixel.shatteredpixeldungeon.actors.buffs.Momentum;
import com.shatteredpixel.shatteredpixeldungeon.actors.hero.Hero;
import com.shatteredpixel.shatteredpixeldungeon.actors.hero.Talent;
import com.shatteredpixel.shatteredpixeldungeon.actors.hero.abilities.gunner.Riot;
import com.shatteredpixel.shatteredpixeldungeon.actors.mobs.DM300;
import com.shatteredpixel.shatteredpixeldungeon.actors.mobs.DwarfKing;
import com.shatteredpixel.shatteredpixeldungeon.actors.mobs.Goo;
import com.shatteredpixel.shatteredpixeldungeon.actors.mobs.Tengu;
import com.shatteredpixel.shatteredpixeldungeon.actors.mobs.YogDzewa;
import com.shatteredpixel.shatteredpixeldungeon.effects.CellEmitter;
import com.shatteredpixel.shatteredpixeldungeon.effects.particles.BlastParticle;
import com.shatteredpixel.shatteredpixeldungeon.effects.particles.SmokeParticle;
import com.shatteredpixel.shatteredpixeldungeon.items.weapon.CorrosionBow;
import com.shatteredpixel.shatteredpixeldungeon.items.weapon.GoldenBow;
import com.shatteredpixel.shatteredpixeldungeon.items.weapon.NaturesBow;
import com.shatteredpixel.shatteredpixeldungeon.items.weapon.SpiritBow;
import com.shatteredpixel.shatteredpixeldungeon.items.weapon.Weapon;
import com.shatteredpixel.shatteredpixeldungeon.items.weapon.WindBow;
import com.shatteredpixel.shatteredpixeldungeon.items.weapon.melee.GrenadeLauncherHP;
import com.shatteredpixel.shatteredpixeldungeon.items.weapon.melee.MeleeWeapon;
import com.shatteredpixel.shatteredpixeldungeon.items.weapon.missiles.MissileWeapon;
import com.shatteredpixel.shatteredpixeldungeon.messages.Messages;
import com.shatteredpixel.shatteredpixeldungeon.scenes.CellSelector;
import com.shatteredpixel.shatteredpixeldungeon.scenes.GameScene;
import com.shatteredpixel.shatteredpixeldungeon.sprites.ItemSpriteSheet;
import com.shatteredpixel.shatteredpixeldungeon.utils.GLog;
import com.watabou.noosa.audio.Sample;
import com.watabou.utils.Bundle;
import com.watabou.utils.Random;
import java.text.DecimalFormat;
import java.util.ArrayList;

public class FrostGun
extends MeleeWeapon {
    public static final String AC_SHOOT = "SHOOT";
    public static final String AC_RELOAD = "RELOAD";
    public int max_round;
    public int round = 0;
    public float reload_time;
    private static final String TXT_STATUS = "%d/%d";
    private static final String ROUND = "round";
    private static final String MAX_ROUND = "max_round";
    private static final String RELOAD_TIME = "reload_time";
    private int targetPos;
    private CellSelector.Listener shooter;

    public FrostGun() {
        this.defaultAction = AC_SHOOT;
        this.usesTargeting = true;
        this.image = ItemSpriteSheet.FROST_GUN;
        this.hitSound = "sounds/hit_crush.mp3";
        this.hitSoundPitch = 0.8f;
        this.tier = 3;
        this.bones = false;
        this.unique = true;
        this.shooter = new CellSelector.Listener(){

            @Override
            public void onSelect(Integer target) {
                if (target != null) {
                    if (target == curUser.pos) {
                        if (Dungeon.hero.buff(GrenadeCoolDown.class) != null) {
                            GLog.w(Messages.get(FrostGun.class, "cannot_reload", new Object[0]), new Object[0]);
                        } else {
                            FrostGun.this.reload();
                        }
                    } else {
                        FrostGun.this.knockBullet().cast(curUser, target);
                    }
                }
            }

            @Override
            public String prompt() {
                return Messages.get(SpiritBow.class, "prompt", new Object[0]);
            }
        };
    }

    @Override
    public void storeInBundle(Bundle bundle) {
        super.storeInBundle(bundle);
        bundle.put(MAX_ROUND, this.max_round);
        bundle.put(ROUND, this.round);
        bundle.put(RELOAD_TIME, this.reload_time);
    }

    @Override
    public void restoreFromBundle(Bundle bundle) {
        super.restoreFromBundle(bundle);
        this.max_round = bundle.getInt(MAX_ROUND);
        this.round = bundle.getInt(ROUND);
        this.reload_time = bundle.getFloat(RELOAD_TIME);
    }

    @Override
    public ArrayList<String> actions(Hero hero) {
        ArrayList<String> actions = super.actions(hero);
        actions.add(AC_SHOOT);
        actions.add(AC_RELOAD);
        actions.remove("EQUIP");
        actions.remove(AC_ABILITY);
        return actions;
    }

    @Override
    public void execute(Hero hero, String action) {
        super.execute(hero, action);
        if (action.equals(AC_SHOOT)) {
            if (this.round <= 0) {
                this.reload_time = 1.0f;
                if (hero.buff(FrostDartCoolDown.class) != null) {
                    this.usesTargeting = false;
                    GLog.w(Messages.get(FrostGun.class, "cannot_reload", new Object[0]), new Object[0]);
                } else {
                    this.reload();
                }
            } else {
                this.reload_time = 1.0f;
                this.usesTargeting = true;
                curUser = hero;
                curItem = this;
                GameScene.selectCell(this.shooter);
            }
        }
        if (action.equals(AC_RELOAD)) {
            if (hero.buff(FrostDartCoolDown.class) != null) {
                GLog.w(Messages.get(FrostGun.class, "cannot_reload", new Object[0]), new Object[0]);
            } else {
                this.max_round = 1;
                if (this.round == this.max_round) {
                    GLog.w(Messages.get(this, "already_loaded", new Object[0]), new Object[0]);
                } else {
                    this.reload();
                }
            }
        }
    }

    public void reload() {
        this.max_round = 1;
        curUser.spend(this.reload_time);
        curUser.busy();
        Sample.INSTANCE.play("sounds/unlock.mp3", 2.0f, 1.1f);
        FrostGun.curUser.sprite.operate(FrostGun.curUser.pos);
        this.round = Math.max(this.max_round, this.round);
        GLog.i(Messages.get(this, "reloading", new Object[0]), new Object[0]);
        if (Dungeon.hero.hasTalent(Talent.SAFE_RELOAD) && Dungeon.hero.buff(Talent.ReloadCooldown.class) == null) {
            Buff.affect(Dungeon.hero, Barrier.class).setShield(1 + 2 * Dungeon.hero.pointsInTalent(Talent.SAFE_RELOAD));
            Buff.affect(Dungeon.hero, Talent.ReloadCooldown.class, 5.0f);
        }
        FrostGun.updateQuickslot();
    }

    public int getRound() {
        return this.round;
    }

    @Override
    public String status() {
        this.max_round = 1;
        return Messages.format(TXT_STATUS, this.round, this.max_round);
    }

    @Override
    public int STRReq(int lvl) {
        return FrostGun.STRReq(this.tier, lvl);
    }

    @Override
    public int min(int lvl) {
        return 1;
    }

    @Override
    public int max(int lvl) {
        return 1;
    }

    public int Bulletmin(int lvl) {
        return 0;
    }

    public int Bulletmax(int lvl) {
        return 5;
    }

    @Override
    public String info() {
        this.max_round = 1;
        this.reload_time = 1.0f;
        String info = this.desc();
        info = this.levelKnown ? info + "\n\n" + Messages.get(FrostGun.class, "stats_known", this.Bulletmin(this.buffedLvl()), this.Bulletmax(this.buffedLvl()), this.round, this.max_round, new DecimalFormat("#.##").format(this.reload_time)) : info + "\n\n" + Messages.get(GrenadeLauncherHP.class, "stats_unknown", this.Bulletmin(this.buffedLvl()), this.Bulletmax(this.buffedLvl()), this.round, this.max_round, new DecimalFormat("#.##").format(this.reload_time));
        String statsInfo = this.statsInfo();
        if (!statsInfo.equals("")) {
            info = info + "\n\n" + statsInfo;
        }
        if (this.enchantment != null && (this.cursedKnown || !this.enchantment.curse())) {
            info = info + "\n\n" + Messages.get(Weapon.class, "enchanted", this.enchantment.name());
            info = info + " " + Messages.get(this.enchantment, "desc", new Object[0]);
        }
        if (this.cursed && this.isEquipped(Dungeon.hero)) {
            info = info + "\n\n" + Messages.get(Weapon.class, "cursed_worn", new Object[0]);
        } else if (this.cursedKnown && this.cursed) {
            info = info + "\n\n" + Messages.get(Weapon.class, "cursed", new Object[0]);
        } else if (!this.isIdentified() && this.cursedKnown) {
            info = info + "\n\n" + Messages.get(Weapon.class, "not_cursed", new Object[0]);
        }
        return info;
    }

    @Override
    public int targetingPos(Hero user, int dst) {
        return this.knockBullet().targetingPos(user, dst);
    }

    @Override
    public int damageRoll(Char owner) {
        int exStr;
        int damage = this.augment.damageFactor(super.damageRoll(owner));
        if (owner instanceof Hero && (exStr = ((Hero)owner).STR() - this.STRReq()) > 0) {
            damage += Random.IntRange(0, exStr);
        }
        return damage;
    }

    @Override
    protected float baseDelay(Char owner) {
        int encumbrance;
        float delay = this.augment.delayFactor(this.DLY);
        if (owner instanceof Hero && (encumbrance = this.STRReq() - ((Hero)owner).STR()) > 0) {
            delay = (float)((double)delay * Math.pow(1.2, encumbrance));
        }
        return delay;
    }

    @Override
    public int level() {
        return (Dungeon.hero == null ? 0 : Dungeon.hero.lvl / 5) + (this.curseInfusionBonus ? 1 : 0);
    }

    @Override
    public int buffedLvl() {
        return this.level();
    }

    @Override
    public boolean isUpgradable() {
        return false;
    }

    public Dart knockBullet() {
        return new Dart();
    }

    public class Dart
    extends MissileWeapon {
        public Dart() {
            this.image = ItemSpriteSheet.CHILLING_DART;
            this.hitSound = "sounds/hit_arrow.mp3";
            this.tier = 3;
            this.ACC = 10000.0f;
        }

        @Override
        public int buffedLvl() {
            return FrostGun.this.buffedLvl();
        }

        @Override
        public int damageRoll(Char owner) {
            Hero hero = (Hero)owner;
            Char enemy = hero.enemy();
            int bulletdamage = Random.NormalIntRange(FrostGun.this.Bulletmin(FrostGun.this.buffedLvl()), FrostGun.this.Bulletmax(FrostGun.this.buffedLvl()));
            if (owner.buff(Momentum.class) != null && owner.buff(Momentum.class).freerunning()) {
                bulletdamage = Math.round((float)bulletdamage * (1.0f + 0.15f * (float)((Hero)owner).pointsInTalent(Talent.PROJECTILE_MOMENTUM)));
            }
            if (owner.buff(Bless.class) != null && ((Hero)owner).hasTalent(Talent.BLESSED_TALENT)) {
                bulletdamage = Math.round((float)bulletdamage * (1.0f + 0.15f * (float)((Hero)owner).pointsInTalent(Talent.BLESSED_TALENT)));
            }
            return bulletdamage;
        }

        @Override
        public boolean hasEnchant(Class<? extends Weapon.Enchantment> type, Char owner) {
            return FrostGun.this.hasEnchant(type, owner);
        }

        @Override
        public int proc(Char attacker, Char defender, int damage) {
            SpiritBow bow = Dungeon.hero.belongings.getItem(SpiritBow.class);
            WindBow bow2 = Dungeon.hero.belongings.getItem(WindBow.class);
            GoldenBow bow3 = Dungeon.hero.belongings.getItem(GoldenBow.class);
            NaturesBow bow4 = Dungeon.hero.belongings.getItem(NaturesBow.class);
            CorrosionBow bow5 = Dungeon.hero.belongings.getItem(CorrosionBow.class);
            if (FrostGun.this.enchantment == null && Random.Int(3) < Dungeon.hero.pointsInTalent(Talent.SHARED_ENCHANTMENT) && Dungeon.hero.buff(MagicImmune.class) == null && bow != null && bow.enchantment != null) {
                return bow.enchantment.proc(this, attacker, defender, damage);
            }
            if (FrostGun.this.enchantment == null && Random.Int(3) < Dungeon.hero.pointsInTalent(Talent.SHARED_ENCHANTMENT) && Dungeon.hero.buff(MagicImmune.class) == null && bow2 != null && bow2.enchantment != null) {
                return bow2.enchantment.proc(this, attacker, defender, damage);
            }
            if (FrostGun.this.enchantment == null && Random.Int(3) < Dungeon.hero.pointsInTalent(Talent.SHARED_ENCHANTMENT) && Dungeon.hero.buff(MagicImmune.class) == null && bow3 != null && bow3.enchantment != null) {
                return bow3.enchantment.proc(this, attacker, defender, damage);
            }
            if (FrostGun.this.enchantment == null && Random.Int(3) < Dungeon.hero.pointsInTalent(Talent.SHARED_ENCHANTMENT) && Dungeon.hero.buff(MagicImmune.class) == null && bow4 != null && bow4.enchantment != null) {
                return bow4.enchantment.proc(this, attacker, defender, damage);
            }
            if (FrostGun.this.enchantment == null && Random.Int(3) < Dungeon.hero.pointsInTalent(Talent.SHARED_ENCHANTMENT) && Dungeon.hero.buff(MagicImmune.class) == null && bow5 != null && bow5.enchantment != null) {
                return bow5.enchantment.proc(this, attacker, defender, damage);
            }
            return FrostGun.this.proc(attacker, defender, damage);
        }

        @Override
        public float delayFactor(Char user) {
            if (Dungeon.hero.buff(Riot.riotTracker.class) != null) {
                return FrostGun.this.delayFactor(user) / 2.0f;
            }
            return FrostGun.this.delayFactor(user);
        }

        @Override
        public int STRReq(int lvl) {
            if (FrostGun.this.masteryPotionBonus) {
                return Dart.STRReq(this.tier, FrostGun.this.buffedLvl()) - 2;
            }
            return Dart.STRReq(this.tier, FrostGun.this.buffedLvl());
        }

        @Override
        protected void onThrow(int cell) {
            float duration = 70.0f - (float)(4 * FrostGun.this.buffedLvl());
            if (FrostGun.this.buffedLvl() >= 6) {
                duration -= 16.0f;
            }
            Buff.prolong(Dungeon.hero, FrostDartCoolDown.class, duration);
            final Char enemy = Actor.findChar(cell);
            if (enemy == null || enemy == curUser) {
                this.parent = null;
                CellEmitter.get(cell).burst(SmokeParticle.FACTORY, 2);
                CellEmitter.center(cell).burst(BlastParticle.FACTORY, 2);
            } else if (!curUser.shoot(enemy, this)) {
                CellEmitter.get(cell).burst(SmokeParticle.FACTORY, 2);
                CellEmitter.center(cell).burst(BlastParticle.FACTORY, 2);
            }
            if (!(enemy == null || enemy instanceof Goo || enemy instanceof Tengu || enemy instanceof DM300 || enemy instanceof DwarfKing || enemy instanceof YogDzewa)) {
                new FlavourBuff(){
                    {
                        this.actPriority = 100;
                    }

                    @Override
                    public boolean act() {
                        Buff.affect(enemy, Frost.class, 20.0f);
                        return super.act();
                    }
                }.attachTo(enemy);
            }
            --FrostGun.this.round;
            Dart.updateQuickslot();
        }

        @Override
        public void throwSound() {
            Sample.INSTANCE.play("sounds/hit_crush.mp3", 1.0f, Random.Float(0.33f, 0.66f));
        }

        @Override
        public void cast(Hero user, int dst) {
            super.cast(user, dst);
        }
    }
}

