/*
 * Decompiled with CFR 0.152.
 */
package com.shatteredpixel.shatteredpixeldungeon.items.weapon.melee;

import com.shatteredpixel.shatteredpixeldungeon.Dungeon;
import com.shatteredpixel.shatteredpixeldungeon.actors.Actor;
import com.shatteredpixel.shatteredpixeldungeon.actors.Char;
import com.shatteredpixel.shatteredpixeldungeon.actors.buffs.Barrier;
import com.shatteredpixel.shatteredpixeldungeon.actors.buffs.Bless;
import com.shatteredpixel.shatteredpixeldungeon.actors.buffs.Blindness;
import com.shatteredpixel.shatteredpixeldungeon.actors.buffs.Buff;
import com.shatteredpixel.shatteredpixeldungeon.actors.buffs.Cloaking;
import com.shatteredpixel.shatteredpixeldungeon.actors.buffs.ElectroBullet;
import com.shatteredpixel.shatteredpixeldungeon.actors.buffs.FireBullet;
import com.shatteredpixel.shatteredpixeldungeon.actors.buffs.FrostBullet;
import com.shatteredpixel.shatteredpixeldungeon.actors.buffs.InfiniteBullet;
import com.shatteredpixel.shatteredpixeldungeon.actors.buffs.Light;
import com.shatteredpixel.shatteredpixeldungeon.actors.buffs.MagicImmune;
import com.shatteredpixel.shatteredpixeldungeon.actors.buffs.Momentum;
import com.shatteredpixel.shatteredpixeldungeon.actors.hero.Hero;
import com.shatteredpixel.shatteredpixeldungeon.actors.hero.HeroSubClass;
import com.shatteredpixel.shatteredpixeldungeon.actors.hero.Talent;
import com.shatteredpixel.shatteredpixeldungeon.actors.hero.abilities.gunner.Riot;
import com.shatteredpixel.shatteredpixeldungeon.actors.mobs.Mob;
import com.shatteredpixel.shatteredpixeldungeon.effects.CellEmitter;
import com.shatteredpixel.shatteredpixeldungeon.effects.particles.BlastParticle;
import com.shatteredpixel.shatteredpixeldungeon.effects.particles.SmokeParticle;
import com.shatteredpixel.shatteredpixeldungeon.items.AmmoBelt;
import com.shatteredpixel.shatteredpixeldungeon.items.Item;
import com.shatteredpixel.shatteredpixeldungeon.items.LiquidMetal;
import com.shatteredpixel.shatteredpixeldungeon.items.Recipe;
import com.shatteredpixel.shatteredpixeldungeon.items.rings.RingOfReload;
import com.shatteredpixel.shatteredpixeldungeon.items.rings.RingOfSharpshooting;
import com.shatteredpixel.shatteredpixeldungeon.items.weapon.CorrosionBow;
import com.shatteredpixel.shatteredpixeldungeon.items.weapon.GoldenBow;
import com.shatteredpixel.shatteredpixeldungeon.items.weapon.NaturesBow;
import com.shatteredpixel.shatteredpixeldungeon.items.weapon.SpiritBow;
import com.shatteredpixel.shatteredpixeldungeon.items.weapon.Weapon;
import com.shatteredpixel.shatteredpixeldungeon.items.weapon.WindBow;
import com.shatteredpixel.shatteredpixeldungeon.items.weapon.melee.CrudePistol;
import com.shatteredpixel.shatteredpixeldungeon.items.weapon.melee.MeleeWeapon;
import com.shatteredpixel.shatteredpixeldungeon.items.weapon.melee.Pistol;
import com.shatteredpixel.shatteredpixeldungeon.items.weapon.missiles.MissileWeapon;
import com.shatteredpixel.shatteredpixeldungeon.messages.Messages;
import com.shatteredpixel.shatteredpixeldungeon.scenes.CellSelector;
import com.shatteredpixel.shatteredpixeldungeon.scenes.GameScene;
import com.shatteredpixel.shatteredpixeldungeon.sprites.ItemSpriteSheet;
import com.shatteredpixel.shatteredpixeldungeon.utils.GLog;
import com.watabou.noosa.audio.Sample;
import com.watabou.utils.Bundle;
import com.watabou.utils.Random;
import java.text.DecimalFormat;
import java.util.ArrayList;

public class GoldenPistol
extends MeleeWeapon {
    public static final String AC_SHOOT = "SHOOT";
    public static final String AC_RELOAD = "RELOAD";
    public int max_round;
    public int round = 0;
    public boolean silencer = false;
    public boolean short_barrel = false;
    public boolean long_barrel = false;
    public boolean magazine = false;
    public boolean light = false;
    public boolean heavy = false;
    public boolean flash = false;
    public float reload_time;
    private static final String TXT_STATUS = "%d/%d";
    private static final String ROUND = "round";
    private static final String MAX_ROUND = "max_round";
    private static final String RELOAD_TIME = "reload_time";
    private static final String SILENCER = "silencer";
    private static final String SHORT_BARREL = "short_barrel";
    private static final String LONG_BARREL = "long_barrel";
    private static final String MAGAZINE = "magazine";
    private static final String LIGHT = "light";
    private static final String HEAVY = "heavy";
    private static final String FLASH = "flash";
    private int targetPos;
    private CellSelector.Listener shooter;

    public GoldenPistol() {
        this.defaultAction = AC_SHOOT;
        this.usesTargeting = true;
        this.image = ItemSpriteSheet.GOLDEN_PISTOL;
        this.hitSound = "sounds/hit_crush.mp3";
        this.hitSoundPitch = 0.8f;
        this.tier = 3;
        this.gun = true;
        this.handGun = true;
        this.shooter = new CellSelector.Listener(){

            @Override
            public void onSelect(Integer target) {
                AmmoBelt.OverHeat overHeat = Dungeon.hero.buff(AmmoBelt.OverHeat.class);
                if (target != null) {
                    if (overHeat != null && Random.Float() < AmmoBelt.OverHeat.chance) {
                        GoldenPistol.this.usesTargeting = false;
                        GLog.w(Messages.get(CrudePistol.class, "failed", new Object[0]), new Object[0]);
                        curUser.spendAndNext(1.0f);
                    } else if (target == curUser.pos) {
                        GoldenPistol.this.reload();
                    } else {
                        GoldenPistol.this.knockBullet().cast(curUser, target);
                        if (Dungeon.hero.buff(MeleeWeapon.PrecisionShooting.class) != null && Dungeon.hero.buff(MeleeWeapon.Charger.class) != null && Dungeon.hero.buff(MeleeWeapon.PrecisionShooting.class).onUse && Dungeon.hero.buff(MeleeWeapon.Charger.class).charges >= 1) {
                            GoldenPistol.this.beforeAbilityUsed(curUser, Actor.findChar(target));
                            --Dungeon.hero.buff(MeleeWeapon.Charger.class).charges;
                            GoldenPistol.this.afterAbilityUsed(curUser);
                        }
                    }
                }
            }

            @Override
            public String prompt() {
                return Messages.get(SpiritBow.class, "prompt", new Object[0]);
            }
        };
    }

    @Override
    public void storeInBundle(Bundle bundle) {
        super.storeInBundle(bundle);
        bundle.put(MAX_ROUND, this.max_round);
        bundle.put(ROUND, this.round);
        bundle.put(RELOAD_TIME, this.reload_time);
        bundle.put(SILENCER, this.silencer);
        bundle.put(SHORT_BARREL, this.short_barrel);
        bundle.put(LONG_BARREL, this.long_barrel);
        bundle.put(MAGAZINE, this.magazine);
        bundle.put(LIGHT, this.light);
        bundle.put(HEAVY, this.heavy);
        bundle.put(FLASH, this.flash);
    }

    @Override
    public void restoreFromBundle(Bundle bundle) {
        super.restoreFromBundle(bundle);
        this.max_round = bundle.getInt(MAX_ROUND);
        this.round = bundle.getInt(ROUND);
        this.reload_time = bundle.getFloat(RELOAD_TIME);
        this.silencer = bundle.getBoolean(SILENCER);
        this.short_barrel = bundle.getBoolean(SHORT_BARREL);
        this.long_barrel = bundle.getBoolean(LONG_BARREL);
        this.magazine = bundle.getBoolean(MAGAZINE);
        this.light = bundle.getBoolean(LIGHT);
        this.heavy = bundle.getBoolean(HEAVY);
        this.flash = bundle.getBoolean(FLASH);
    }

    @Override
    public ArrayList<String> actions(Hero hero) {
        ArrayList<String> actions = super.actions(hero);
        if (this.isEquipped(hero)) {
            actions.add(AC_SHOOT);
            actions.add(AC_RELOAD);
        }
        return actions;
    }

    @Override
    protected int baseChargeUse(Hero hero, Char target) {
        return 0;
    }

    @Override
    protected void duelistAbility(Hero hero, Integer target) {
        CrudePistol.shootAbility(hero, this);
    }

    @Override
    public void execute(Hero hero, String action) {
        super.execute(hero, action);
        if (action.equals(AC_SHOOT)) {
            if (!this.isEquipped(hero)) {
                this.usesTargeting = false;
                GLog.w(Messages.get(this, "not_equipped", new Object[0]), new Object[0]);
            } else if (this.round <= 0) {
                this.reload_time = 2.0f * RingOfReload.reloadMultiplier(Dungeon.hero);
                this.reload();
            } else {
                this.reload_time = 2.0f * RingOfReload.reloadMultiplier(Dungeon.hero);
                this.usesTargeting = true;
                curUser = hero;
                curItem = this;
                GameScene.selectCell(this.shooter);
            }
        }
        if (action.equals(AC_RELOAD)) {
            int n = this.max_round = this.magazine ? 4 : 3;
            if (Dungeon.hero.hasTalent(Talent.LARGER_MAGAZINE)) {
                this.max_round = (int)((float)this.max_round + 1.0f * (float)Dungeon.hero.pointsInTalent(Talent.LARGER_MAGAZINE));
            }
            if (this.round == this.max_round) {
                GLog.w(Messages.get(this, "already_loaded", new Object[0]), new Object[0]);
            } else {
                this.reload();
            }
        }
    }

    public void reload() {
        int n = this.max_round = this.magazine ? 4 : 3;
        if (Dungeon.hero.hasTalent(Talent.LARGER_MAGAZINE)) {
            this.max_round = (int)((float)this.max_round + 1.0f * (float)Dungeon.hero.pointsInTalent(Talent.LARGER_MAGAZINE));
        }
        Buff.detach(Dungeon.hero, FrostBullet.class);
        Buff.detach(Dungeon.hero, FireBullet.class);
        Buff.detach(Dungeon.hero, ElectroBullet.class);
        if (Dungeon.hero.hasTalent(Talent.ELEMENTAL_BULLET) && this.round == 0) {
            int chance = Random.Int(6);
            int point = Dungeon.hero.pointsInTalent(Talent.ELEMENTAL_BULLET);
            switch (chance) {
                default: {
                    break;
                }
                case 0: {
                    if (point < 1) break;
                    Buff.affect(Dungeon.hero, FrostBullet.class, 100.0f);
                    break;
                }
                case 1: {
                    if (point < 2) break;
                    Buff.affect(Dungeon.hero, FireBullet.class, 100.0f);
                    break;
                }
                case 2: {
                    if (point < 3) break;
                    Buff.affect(Dungeon.hero, ElectroBullet.class, 100.0f);
                }
            }
        }
        curUser.spend(this.reload_time);
        curUser.busy();
        Sample.INSTANCE.play("sounds/unlock.mp3", 2.0f, 1.1f);
        GoldenPistol.curUser.sprite.operate(GoldenPistol.curUser.pos);
        this.round = Math.max(this.max_round, this.round);
        GLog.i(Messages.get(this, "reloading", new Object[0]), new Object[0]);
        if (Dungeon.hero.hasTalent(Talent.SAFE_RELOAD) && Dungeon.hero.buff(Talent.ReloadCooldown.class) == null) {
            Buff.affect(Dungeon.hero, Barrier.class).setShield(1 + 2 * Dungeon.hero.pointsInTalent(Talent.SAFE_RELOAD));
            Buff.affect(Dungeon.hero, Talent.ReloadCooldown.class, 5.0f);
        }
        GoldenPistol.updateQuickslot();
    }

    public int getRound() {
        return this.round;
    }

    public void oneReload() {
        int n = this.max_round = this.magazine ? 4 : 3;
        if (Dungeon.hero.hasTalent(Talent.LARGER_MAGAZINE)) {
            this.max_round = (int)((float)this.max_round + 1.0f * (float)Dungeon.hero.pointsInTalent(Talent.LARGER_MAGAZINE));
        }
        ++this.round;
        if (this.round > this.max_round) {
            this.round = this.max_round;
        }
    }

    @Override
    public String status() {
        int n = this.max_round = this.magazine ? 4 : 3;
        if (Dungeon.hero.hasTalent(Talent.LARGER_MAGAZINE)) {
            this.max_round = (int)((float)this.max_round + 1.0f * (float)Dungeon.hero.pointsInTalent(Talent.LARGER_MAGAZINE));
        }
        return Messages.format(TXT_STATUS, this.round, this.max_round);
    }

    @Override
    public int STRReq(int lvl) {
        int needSTR = GoldenPistol.STRReq(this.tier, lvl);
        if (this.heavy) {
            needSTR += 2;
        }
        if (this.light) {
            needSTR -= 2;
        }
        return needSTR;
    }

    @Override
    public int min(int lvl) {
        return this.tier + lvl;
    }

    @Override
    public int max(int lvl) {
        return 3 * (this.tier + 1) + lvl;
    }

    public int Bulletmin(int lvl) {
        return 2 * this.tier + lvl + RingOfSharpshooting.levelDamageBonus(Dungeon.hero);
    }

    public int Bulletmax(int lvl) {
        return 4 * (this.tier + 1) + lvl * (this.tier + 1) + RingOfSharpshooting.levelDamageBonus(Dungeon.hero);
    }

    @Override
    public int proc(Char attacker, Char defender, int damage) {
        if (this.light) {
            damage = (int)((float)damage * 0.75f);
        }
        if (this.heavy) {
            damage = (int)((float)damage * 1.1f);
        }
        if (this.flash && attacker.buff(Light.class) == null) {
            Buff.affect(defender, Blindness.class, 5.0f);
            Buff.affect(attacker, Light.class, 50.0f);
        }
        return super.proc(attacker, defender, damage);
    }

    @Override
    public String info() {
        int n = this.max_round = this.magazine ? 4 : 3;
        if (Dungeon.hero.hasTalent(Talent.LARGER_MAGAZINE)) {
            this.max_round = (int)((float)this.max_round + 1.0f * (float)Dungeon.hero.pointsInTalent(Talent.LARGER_MAGAZINE));
        }
        this.reload_time = 2.0f * RingOfReload.reloadMultiplier(Dungeon.hero);
        String info = super.info();
        info = this.levelKnown ? info + "\n\n" + Messages.get(CrudePistol.class, "stats_known", this.Bulletmin(this.buffedLvl()), this.Bulletmax(this.buffedLvl()), this.round, this.max_round, new DecimalFormat("#.##").format(this.reload_time)) : info + "\n\n" + Messages.get(CrudePistol.class, "stats_unknown", this.Bulletmin(0), this.Bulletmax(0), this.round, this.max_round, new DecimalFormat("#.##").format(this.reload_time));
        if (this.silencer) {
            info = info + "\n\n" + Messages.get(CrudePistol.class, SILENCER, new Object[0]);
        }
        if (this.short_barrel) {
            info = info + "\n\n" + Messages.get(CrudePistol.class, SHORT_BARREL, new Object[0]);
        }
        if (this.long_barrel) {
            info = info + "\n\n" + Messages.get(CrudePistol.class, LONG_BARREL, new Object[0]);
        }
        if (this.magazine) {
            info = info + "\n\n" + Messages.get(CrudePistol.class, MAGAZINE, new Object[0]);
        }
        if (this.light) {
            info = info + "\n\n" + Messages.get(CrudePistol.class, LIGHT, new Object[0]);
        }
        if (this.heavy) {
            info = info + "\n\n" + Messages.get(CrudePistol.class, HEAVY, new Object[0]);
        }
        if (this.flash) {
            info = info + "\n\n" + Messages.get(CrudePistol.class, FLASH, new Object[0]);
        }
        if (Dungeon.isChallenged(8192) && this.levelKnown) {
            info = info + "\n\n" + Messages.get(Item.class, "durability_weapon", this.durability(), this.maxDurability());
        }
        return info;
    }

    @Override
    public int targetingPos(Hero user, int dst) {
        return this.knockBullet().targetingPos(user, dst);
    }

    @Override
    public int damageRoll(Char owner) {
        int exStr;
        int damage = this.augment.damageFactor(super.damageRoll(owner));
        if (owner instanceof Hero && (exStr = ((Hero)owner).STR() - this.STRReq()) > 0) {
            damage += Random.IntRange(0, exStr);
        }
        return damage;
    }

    @Override
    protected float baseDelay(Char owner) {
        int encumbrance;
        float delay = this.augment.delayFactor(this.DLY);
        if (owner instanceof Hero && (encumbrance = this.STRReq() - ((Hero)owner).STR()) > 0) {
            delay = (float)((double)delay * Math.pow(1.2, encumbrance));
        }
        return delay;
    }

    public Bullet knockBullet() {
        return new Bullet();
    }

    public class Bullet
    extends MissileWeapon {
        public Bullet() {
            this.image = ItemSpriteSheet.SINGLE_BULLET;
            this.hitSound = "sounds/puff.mp3";
            this.tier = 3;
            this.bullet = true;
            this.handGunBullet = true;
        }

        @Override
        public int buffedLvl() {
            return GoldenPistol.this.buffedLvl();
        }

        @Override
        public int damageRoll(Char owner) {
            Hero hero = (Hero)owner;
            Char enemy = hero.enemy();
            int bulletdamage = Random.NormalIntRange(GoldenPistol.this.Bulletmin(GoldenPistol.this.buffedLvl()), GoldenPistol.this.Bulletmax(GoldenPistol.this.buffedLvl()));
            if (owner.buff(Momentum.class) != null && owner.buff(Momentum.class).freerunning()) {
                bulletdamage = Math.round((float)bulletdamage * (1.0f + 0.15f * (float)((Hero)owner).pointsInTalent(Talent.PROJECTILE_MOMENTUM)));
            }
            if (owner.buff(Bless.class) != null && ((Hero)owner).hasTalent(Talent.BLESSED_TALENT)) {
                bulletdamage = Math.round((float)bulletdamage * (1.0f + 0.15f * (float)((Hero)owner).pointsInTalent(Talent.BLESSED_TALENT)));
            }
            return bulletdamage;
        }

        @Override
        public boolean hasEnchant(Class<? extends Weapon.Enchantment> type, Char owner) {
            return GoldenPistol.this.hasEnchant(type, owner);
        }

        @Override
        public int proc(Char attacker, Char defender, int damage) {
            if (GoldenPistol.this.silencer) {
                damage = (int)((float)damage * 0.75f);
            }
            if (damage >= defender.HP && Dungeon.hero.buff(MeleeWeapon.PrecisionShooting.class) != null && Dungeon.hero.buff(MeleeWeapon.Charger.class).charges >= 1) {
                GoldenPistol.onAbilityKill(Dungeon.hero, defender);
            }
            SpiritBow bow = Dungeon.hero.belongings.getItem(SpiritBow.class);
            WindBow bow2 = Dungeon.hero.belongings.getItem(WindBow.class);
            GoldenBow bow3 = Dungeon.hero.belongings.getItem(GoldenBow.class);
            NaturesBow bow4 = Dungeon.hero.belongings.getItem(NaturesBow.class);
            CorrosionBow bow5 = Dungeon.hero.belongings.getItem(CorrosionBow.class);
            if (GoldenPistol.this.enchantment == null && Random.Int(3) < Dungeon.hero.pointsInTalent(Talent.SHARED_ENCHANTMENT) && Dungeon.hero.buff(MagicImmune.class) == null && bow != null && bow.enchantment != null) {
                return bow.enchantment.proc(this, attacker, defender, damage);
            }
            if (GoldenPistol.this.enchantment == null && Random.Int(3) < Dungeon.hero.pointsInTalent(Talent.SHARED_ENCHANTMENT) && Dungeon.hero.buff(MagicImmune.class) == null && bow2 != null && bow2.enchantment != null) {
                return bow2.enchantment.proc(this, attacker, defender, damage);
            }
            if (GoldenPistol.this.enchantment == null && Random.Int(3) < Dungeon.hero.pointsInTalent(Talent.SHARED_ENCHANTMENT) && Dungeon.hero.buff(MagicImmune.class) == null && bow3 != null && bow3.enchantment != null) {
                return bow3.enchantment.proc(this, attacker, defender, damage);
            }
            if (GoldenPistol.this.enchantment == null && Random.Int(3) < Dungeon.hero.pointsInTalent(Talent.SHARED_ENCHANTMENT) && Dungeon.hero.buff(MagicImmune.class) == null && bow4 != null && bow4.enchantment != null) {
                return bow4.enchantment.proc(this, attacker, defender, damage);
            }
            if (GoldenPistol.this.enchantment == null && Random.Int(3) < Dungeon.hero.pointsInTalent(Talent.SHARED_ENCHANTMENT) && Dungeon.hero.buff(MagicImmune.class) == null && bow5 != null && bow5.enchantment != null) {
                return bow5.enchantment.proc(this, attacker, defender, damage);
            }
            return GoldenPistol.this.proc(attacker, defender, damage);
        }

        @Override
        public float delayFactor(Char user) {
            if (Dungeon.hero.subClass == HeroSubClass.GUNSLINGER && Dungeon.hero.justMoved) {
                return 0.0f;
            }
            if (Dungeon.hero.buff(Riot.riotTracker.class) != null) {
                return GoldenPistol.this.delayFactor(user) / 2.0f;
            }
            return GoldenPistol.this.delayFactor(user);
        }

        @Override
        public float accuracyFactor(Char owner, Char target) {
            float accFactor = super.accuracyFactor(owner, target);
            if (GoldenPistol.this.short_barrel) {
                accFactor = Dungeon.level.adjacent(owner.pos, target.pos) ? (accFactor *= 1.25f) : (accFactor *= 0.75f);
            }
            if (GoldenPistol.this.long_barrel) {
                accFactor = Dungeon.level.adjacent(owner.pos, target.pos) ? (accFactor *= 0.75f) : (accFactor *= 1.1f);
            }
            if (GoldenPistol.this.magazine && !Dungeon.level.adjacent(owner.pos, target.pos)) {
                accFactor *= 0.85f;
            }
            if (GoldenPistol.this.light) {
                accFactor *= 0.9f;
            }
            if (GoldenPistol.this.heavy) {
                accFactor *= 1.1f;
            }
            return accFactor;
        }

        @Override
        public int STRReq(int lvl) {
            return GoldenPistol.this.STRReq();
        }

        @Override
        protected void onThrow(int cell) {
            Char enemy = Actor.findChar(cell);
            if (enemy == null || enemy == curUser) {
                this.parent = null;
                CellEmitter.get(cell).burst(SmokeParticle.FACTORY, 2);
                CellEmitter.center(cell).burst(BlastParticle.FACTORY, 2);
            } else if (!curUser.shoot(enemy, this)) {
                CellEmitter.get(cell).burst(SmokeParticle.FACTORY, 2);
                CellEmitter.center(cell).burst(BlastParticle.FACTORY, 2);
            }
            if (Dungeon.hero.buff(InfiniteBullet.class) == null && (Dungeon.hero.buff(Riot.riotTracker.class) == null || Random.Int(10) > Dungeon.hero.pointsInTalent(Talent.ROUND_PRESERVE) - 1)) {
                --GoldenPistol.this.round;
            }
            if (Dungeon.hero.pointsInTalent(Talent.SILENCER) > 1) {
                if (Dungeon.hero.pointsInTalent(Talent.SILENCER) <= 2 && Dungeon.hero.buff(Cloaking.class) != null) {
                    // empty if block
                }
            } else {
                for (Mob mob : Dungeon.level.mobs.toArray(new Mob[0])) {
                    int dist = 4;
                    if (Dungeon.hero.hasTalent(Talent.SILENCER) && Dungeon.hero.buff(Cloaking.class) != null) {
                        dist = (int)((double)dist * 0.5);
                    }
                    if (mob.paralysed > 0 || Dungeon.level.distance(Bullet.curUser.pos, mob.pos) > dist || mob.state == mob.HUNTING || GoldenPistol.this.silencer) continue;
                    mob.beckon(Bullet.curUser.pos);
                }
            }
            Bullet.updateQuickslot();
            if (Dungeon.isChallenged(8192)) {
                GoldenPistol.this.use();
            }
        }

        @Override
        public void throwSound() {
            Sample.INSTANCE.play("sounds/hit_crush.mp3", 1.0f, Random.Float(0.33f, 0.66f));
        }

        @Override
        public void cast(Hero user, int dst) {
            super.cast(user, dst);
        }
    }

    public static class Recipe
    extends Recipe.SimpleRecipe {
        public Recipe() {
            this.inputs = new Class[]{Pistol.class, LiquidMetal.class};
            this.inQuantity = new int[]{1, 30};
            this.cost = 0;
            this.output = GoldenPistol.class;
            this.outQuantity = 1;
        }
    }
}

