/*
 * Decompiled with CFR 0.152.
 */
package com.shatteredpixel.shatteredpixeldungeon.items.weapon.melee;

import com.shatteredpixel.shatteredpixeldungeon.actors.Char;
import com.shatteredpixel.shatteredpixeldungeon.actors.buffs.LanceBuff;
import com.shatteredpixel.shatteredpixeldungeon.actors.hero.Hero;
import com.shatteredpixel.shatteredpixeldungeon.effects.Speck;
import com.shatteredpixel.shatteredpixeldungeon.items.LiquidMetal;
import com.shatteredpixel.shatteredpixeldungeon.items.Recipe;
import com.shatteredpixel.shatteredpixeldungeon.items.armor.glyphs.AntiMagic;
import com.shatteredpixel.shatteredpixeldungeon.items.weapon.melee.Lance;
import com.shatteredpixel.shatteredpixeldungeon.items.weapon.melee.MeleeWeapon;
import com.shatteredpixel.shatteredpixeldungeon.items.weapon.melee.ObsidianShield;
import com.shatteredpixel.shatteredpixeldungeon.items.weapon.melee.RoundShield;
import com.shatteredpixel.shatteredpixeldungeon.messages.Messages;
import com.shatteredpixel.shatteredpixeldungeon.sprites.ItemSpriteSheet;
import com.shatteredpixel.shatteredpixeldungeon.utils.GLog;
import com.watabou.noosa.audio.Sample;
import com.watabou.utils.Bundle;
import com.watabou.utils.Random;
import java.util.ArrayList;
import java.util.HashSet;

public class LanceNShield
extends MeleeWeapon {
    public boolean stance;
    public static final String AC_CHANGE = "CHANGE";
    public static final HashSet<Class> RESISTS = new HashSet();
    private static final String STANCE = "stance";

    public LanceNShield() {
        this.image = ItemSpriteSheet.LANCE_N_SHIELD;
        this.hitSound = "sounds/hit_stab.mp3";
        this.hitSoundPitch = 1.1f;
        this.tier = 7;
        this.alchemy = true;
        this.stance = true;
        this.defaultAction = AC_CHANGE;
    }

    @Override
    public ArrayList<String> actions(Hero hero) {
        ArrayList<String> actions = super.actions(hero);
        if (this.isEquipped(hero)) {
            actions.add(AC_CHANGE);
        }
        return actions;
    }

    @Override
    public void execute(Hero hero, String action) {
        super.execute(hero, action);
        if (action.equals(AC_CHANGE)) {
            if (!this.isEquipped(hero)) {
                GLog.w(Messages.get(this, "not_equipped", new Object[0]), new Object[0]);
            } else {
                if (this.stance) {
                    if (hero.buff(LanceBuff.class) != null) {
                        hero.buff(LanceBuff.class).detach();
                    }
                    GLog.p(Messages.get(this, "change_defense", new Object[0]), new Object[0]);
                    this.stance = false;
                } else {
                    GLog.p(Messages.get(this, "change_attack", new Object[0]), new Object[0]);
                    this.stance = true;
                }
                Sample.INSTANCE.play("sounds/miss.mp3", 1.0f, 0.8f);
                hero.sprite.emitter().burst(Speck.factory(106), 5);
            }
        }
    }

    @Override
    public int reachFactor(Char owner) {
        int reach = super.reachFactor(owner);
        if (this.stance) {
            ++reach;
        }
        return reach;
    }

    @Override
    public int max(int lvl) {
        if (this.stance) {
            return 4 * (this.tier - 1) + lvl * (this.tier - 1);
        }
        return 4 * (this.tier - 2) + lvl * (this.tier - 2);
    }

    @Override
    public int defenseFactor(Char owner) {
        if (this.stance) {
            return 0;
        }
        return 4 + 2 * this.buffedLvl();
    }

    public static int drRoll(int level) {
        return Random.NormalIntRange(0, 4 + 2 * level);
    }

    @Override
    public String statsInfo() {
        if (this.stance) {
            if (this.isIdentified()) {
                return Messages.get(this, "stats_desc_attack", new Object[0]);
            }
            return Messages.get(this, "typical_stats_desc_attack", new Object[0]);
        }
        if (this.isIdentified()) {
            return Messages.get(this, "stats_desc_defense", 4 + 2 * this.buffedLvl());
        }
        return Messages.get(this, "typical_stats_desc_defense", 4);
    }

    @Override
    public void storeInBundle(Bundle bundle) {
        super.storeInBundle(bundle);
        bundle.put(STANCE, this.stance);
    }

    @Override
    public void restoreFromBundle(Bundle bundle) {
        super.restoreFromBundle(bundle);
        this.stance = bundle.getBoolean(STANCE);
    }

    @Override
    public String targetingPrompt() {
        if (this.stance) {
            return Messages.get(this, "prompt", new Object[0]);
        }
        return null;
    }

    @Override
    protected void duelistAbility(Hero hero, Integer target) {
        if (this.stance) {
            Lance.dashAbility(hero, target, this);
        } else {
            RoundShield.guardAbility(hero, 3, this);
        }
    }

    static {
        RESISTS.addAll(AntiMagic.RESISTS);
    }

    public static class Recipe
    extends Recipe.SimpleRecipe {
        public Recipe() {
            this.inputs = new Class[]{Lance.class, ObsidianShield.class, LiquidMetal.class};
            this.inQuantity = new int[]{1, 1, 50};
            this.cost = 10;
            this.output = LanceNShield.class;
            this.outQuantity = 1;
        }
    }
}

