/*
 * Decompiled with CFR 0.152.
 */
package com.shatteredpixel.shatteredpixeldungeon.items.weapon.melee;

import com.shatteredpixel.shatteredpixeldungeon.Dungeon;
import com.shatteredpixel.shatteredpixeldungeon.actors.Actor;
import com.shatteredpixel.shatteredpixeldungeon.actors.Char;
import com.shatteredpixel.shatteredpixeldungeon.actors.blobs.WaterOfAwareness;
import com.shatteredpixel.shatteredpixeldungeon.actors.blobs.WaterOfHealth;
import com.shatteredpixel.shatteredpixeldungeon.actors.blobs.WellWater;
import com.shatteredpixel.shatteredpixeldungeon.actors.buffs.Barrier;
import com.shatteredpixel.shatteredpixeldungeon.actors.buffs.Buff;
import com.shatteredpixel.shatteredpixeldungeon.actors.buffs.Invisibility;
import com.shatteredpixel.shatteredpixeldungeon.actors.buffs.MinersToolCoolDown;
import com.shatteredpixel.shatteredpixeldungeon.actors.buffs.Roots;
import com.shatteredpixel.shatteredpixeldungeon.actors.buffs.ShovelDigCoolDown;
import com.shatteredpixel.shatteredpixeldungeon.actors.buffs.Vulnerable;
import com.shatteredpixel.shatteredpixeldungeon.actors.hero.Hero;
import com.shatteredpixel.shatteredpixeldungeon.actors.hero.HeroSubClass;
import com.shatteredpixel.shatteredpixeldungeon.actors.hero.Talent;
import com.shatteredpixel.shatteredpixeldungeon.actors.mobs.Mob;
import com.shatteredpixel.shatteredpixeldungeon.effects.CellEmitter;
import com.shatteredpixel.shatteredpixeldungeon.effects.Speck;
import com.shatteredpixel.shatteredpixeldungeon.effects.particles.EarthParticle;
import com.shatteredpixel.shatteredpixeldungeon.effects.particles.LeafParticle;
import com.shatteredpixel.shatteredpixeldungeon.items.Dewdrop;
import com.shatteredpixel.shatteredpixeldungeon.items.Generator;
import com.shatteredpixel.shatteredpixeldungeon.items.Gold;
import com.shatteredpixel.shatteredpixeldungeon.items.Heap;
import com.shatteredpixel.shatteredpixeldungeon.items.Item;
import com.shatteredpixel.shatteredpixeldungeon.items.Torch;
import com.shatteredpixel.shatteredpixeldungeon.items.spells.AquaBlast;
import com.shatteredpixel.shatteredpixeldungeon.items.weapon.enchantments.Lucky;
import com.shatteredpixel.shatteredpixeldungeon.items.weapon.melee.MeleeWeapon;
import com.shatteredpixel.shatteredpixeldungeon.levels.Level;
import com.shatteredpixel.shatteredpixeldungeon.levels.features.Chasm;
import com.shatteredpixel.shatteredpixeldungeon.levels.traps.GeyserTrap;
import com.shatteredpixel.shatteredpixeldungeon.levels.traps.Trap;
import com.shatteredpixel.shatteredpixeldungeon.messages.Messages;
import com.shatteredpixel.shatteredpixeldungeon.plants.Plant;
import com.shatteredpixel.shatteredpixeldungeon.scenes.CellSelector;
import com.shatteredpixel.shatteredpixeldungeon.scenes.GameScene;
import com.shatteredpixel.shatteredpixeldungeon.sprites.ItemSpriteSheet;
import com.shatteredpixel.shatteredpixeldungeon.utils.GLog;
import com.watabou.noosa.audio.Sample;
import com.watabou.utils.PathFinder;
import com.watabou.utils.Random;
import java.util.ArrayList;

public class MinersTool
extends MeleeWeapon {
    public static final String AC_MINE = "MINE";
    private static final Class<?>[] WATERS = new Class[]{WaterOfAwareness.class, WaterOfHealth.class};
    public Class<? extends WellWater> overrideWater = null;

    public MinersTool() {
        this.defaultAction = AC_MINE;
        this.image = ItemSpriteSheet.MINERS_TOOL;
        this.hitSound = "sounds/hit.mp3";
        this.hitSoundPitch = 0.9f;
        this.tier = 5;
        this.unique = true;
        this.bones = false;
    }

    @Override
    public int proc(Char attacker, Char defender, int damage) {
        int level = Math.max(0, this.buffedLvl());
        float procChance = ((float)level + 1.0f) / ((float)level + 8.0f);
        if (Random.Float() < procChance) {
            Buff.prolong(defender, Vulnerable.class, 5.0f);
        }
        if (attacker == Dungeon.hero && ((Hero)attacker).subClass == HeroSubClass.TREASUREHUNTER && damage >= defender.HP && Random.Float() < (0.1f + 0.04f * (float)this.level()) * (1.0f + 0.5f * (float)Dungeon.hero.pointsInTalent(Talent.FINDING_TREASURE))) {
            Buff.affect(defender, Lucky.LuckProc.class);
        }
        return super.proc(attacker, defender, damage);
    }

    @Override
    public ArrayList<String> actions(Hero hero) {
        ArrayList<String> actions = super.actions(hero);
        actions.add(AC_MINE);
        return actions;
    }

    @Override
    public void execute(final Hero hero, String action) {
        super.execute(hero, action);
        if (action.equals(AC_MINE)) {
            if (hero.buff(MinersToolCoolDown.class) != null) {
                GLog.w(Messages.get(this, "not_ready_mining", new Object[0]), new Object[0]);
            } else {
                this.usesTargeting = false;
                curUser = hero;
                curItem = this;
                GameScene.selectCell(new CellSelector.Listener(){

                    @Override
                    public void onSelect(Integer cell) {
                        if (cell != null) {
                            if (!Dungeon.level.adjacent(curUser.pos, cell) || cell == curUser.pos) {
                                if (cell == curUser.pos) {
                                    if (hero.buff(ShovelDigCoolDown.class) != null) {
                                        GLog.w(Messages.get(this, "not_ready", new Object[0]), new Object[0]);
                                    } else {
                                        MinersTool.this.Dig();
                                    }
                                } else {
                                    GLog.w(Messages.get(MinersTool.class, "too_far", new Object[0]), new Object[0]);
                                }
                            } else if (Dungeon.level.map[cell] == 12) {
                                MinersTool.this.goldMining(cell);
                            } else if (Dungeon.level.map[cell] == 29) {
                                MinersTool.this.filling(cell);
                            } else if (Dungeon.level.map[cell] == 1 || Dungeon.level.map[cell] == 20 || Dungeon.level.map[cell] == 14 || Dungeon.level.map[cell] == 2 || Dungeon.level.map[cell] == 15 || Dungeon.level.map[cell] == 30 || Dungeon.level.map[cell] == 9 || Dungeon.level.map[cell] == 19) {
                                if (Dungeon.depth % 5 == 0 || Dungeon.depth == 31) {
                                    GLog.w(Messages.get(MinersTool.class, "cannot_mine_boss", new Object[0]), new Object[0]);
                                } else {
                                    Char ch = Actor.findChar(cell);
                                    if (ch != null) {
                                        if (ch.alignment != Char.Alignment.NEUTRAL && !Char.hasProp(ch, Char.Property.IMMOVABLE)) {
                                            MinersTool.this.floorMining(cell);
                                        } else {
                                            GLog.w(Messages.get(MinersTool.class, "cannot_mine", new Object[0]), new Object[0]);
                                        }
                                    } else {
                                        MinersTool.this.floorMining(cell);
                                    }
                                }
                            } else if (Dungeon.level.map[cell] == 25 || Dungeon.level.map[cell] == 26) {
                                MinersTool.this.statueMining(cell);
                            } else if (Dungeon.level.map[cell] == 18 || Dungeon.level.map[cell] == 17) {
                                MinersTool.this.trapDisarming(cell);
                            } else if (Dungeon.level.map[cell] == 5 || Dungeon.level.map[cell] == 6) {
                                MinersTool.this.doorBlocking(cell);
                            } else if (Dungeon.level.map[cell] == 3) {
                                MinersTool.this.wellMining(cell);
                            } else {
                                GLog.w(Messages.get(MinersTool.class, "cannot_mine", new Object[0]), new Object[0]);
                            }
                        }
                    }

                    @Override
                    public String prompt() {
                        return Messages.get(MinersTool.class, "prompt", new Object[0]);
                    }
                });
            }
        }
    }

    public void Dig() {
        int flowers;
        curUser.spend(1.0f);
        curUser.busy();
        Sample.INSTANCE.play("sounds/trample.mp3", 2.0f, 1.1f);
        MinersTool.curUser.sprite.operate(MinersTool.curUser.pos);
        GLog.i(Messages.get(this, "dig", new Object[0]), new Object[0]);
        int n = flowers = Random.Int(2) < Dungeon.hero.pointsInTalent(Talent.FLOWER_BED) ? 1 : 0;
        if (Dungeon.hero.subClass == HeroSubClass.RESEARCHER) {
            ArrayList<Integer> positions = new ArrayList<Integer>();
            for (int i : PathFinder.NEIGHBOURS25) {
                positions.add(i);
            }
            Random.shuffle(positions);
            Object object = positions.iterator();
            while (object.hasNext()) {
                int i = (Integer)object.next();
                int c = Dungeon.level.map[Dungeon.hero.pos + i];
                if (c != 1 && c != 20 && c != 9 && c != 2 && c != 29 && c != 30) continue;
                if (flowers > 0) {
                    Dungeon.level.plant((Plant.Seed)Generator.randomUsingDefaults(Generator.Category.SEED), Dungeon.hero.pos);
                    --flowers;
                } else if (Random.Int(8) < 1 + Dungeon.hero.pointsInTalent(Talent.ALIVE_GRASS)) {
                    Level.set(Dungeon.hero.pos + i, 15);
                } else {
                    Level.set(Dungeon.hero.pos + i, 30);
                }
                Char enemy = Actor.findChar(Dungeon.hero.pos + i);
                if (enemy instanceof Mob && Dungeon.hero.hasTalent(Talent.ROOT)) {
                    Buff.affect(enemy, Roots.class, 1 + Dungeon.hero.pointsInTalent(Talent.ROOT));
                }
                GameScene.updateMap(Dungeon.hero.pos + i);
                CellEmitter.get(Dungeon.hero.pos + i).burst(LeafParticle.LEVEL_SPECIFIC, 4);
            }
        } else {
            ArrayList<Integer> positions = new ArrayList<Integer>();
            for (int i : PathFinder.NEIGHBOURS9) {
                positions.add(i);
            }
            Random.shuffle(positions);
            Object object = positions.iterator();
            while (object.hasNext()) {
                int i = (Integer)object.next();
                int c = Dungeon.level.map[Dungeon.hero.pos + i];
                if (c != 1 && c != 20 && c != 9 && c != 2) continue;
                if (flowers > 0) {
                    Dungeon.level.plant((Plant.Seed)Generator.randomUsingDefaults(Generator.Category.SEED), Dungeon.hero.pos + i);
                    --flowers;
                } else {
                    Level.set(Dungeon.hero.pos + i, 30);
                }
                Char enemy = Actor.findChar(Dungeon.hero.pos + i);
                if (enemy instanceof Mob && Dungeon.hero.hasTalent(Talent.ROOT)) {
                    Buff.affect(enemy, Roots.class, 1 + Dungeon.hero.pointsInTalent(Talent.ROOT));
                }
                GameScene.updateMap(Dungeon.hero.pos + i);
                CellEmitter.get(Dungeon.hero.pos + i).burst(LeafParticle.LEVEL_SPECIFIC, 4);
            }
        }
        if (Random.Int(10) < Dungeon.hero.pointsInTalent(Talent.DETECTOR)) {
            Dungeon.level.drop((Item)Lucky.genLoot(), (int)Dungeon.hero.pos).sprite.drop();
            Lucky.showFlare(Dungeon.hero.sprite);
        }
        Buff.affect(Dungeon.hero, ShovelDigCoolDown.class, Math.max(20 - 2 * this.buffedLvl(), 5));
        if (Dungeon.hero.hasTalent(Talent.PLANT_SHIELD)) {
            Buff.affect(Dungeon.hero, Barrier.class).setShield(2 + 3 * Dungeon.hero.pointsInTalent(Talent.PLANT_SHIELD));
        }
    }

    @Override
    public int max(int lvl) {
        if (Dungeon.hero.hasTalent(Talent.TAKEDOWN) && Dungeon.hero.buff(Talent.TakeDownCooldown.class) == null) {
            return 4 * (this.tier + 1) + lvl * (this.tier + 1) + 15 * Dungeon.hero.pointsInTalent(Talent.TAKEDOWN);
        }
        return 4 * (this.tier + 1) + lvl * (this.tier + 1);
    }

    public void goldMining(int cell) {
        boolean isPrizeDropped = false;
        Item gold = new Gold().quantity((int)Math.ceil((float)Dungeon.depth / 5.0f) * Random.NormalIntRange(5, 25));
        AquaBlast prizeCh1 = new AquaBlast();
        Torch prizeCh2 = new Torch();
        Item prizeCh3 = Generator.random(Generator.Category.RING);
        Item prizeCh4 = Generator.random(Generator.Category.STONE);
        Item prizeCh5 = Generator.random(Generator.Category.RING);
        Item prizeCh6 = Generator.random(Generator.Category.MISSILE);
        Level.set(cell, 35);
        int upgrade = 0;
        if (Random.Int(2) == 0) {
            ++upgrade;
            if (Random.Int(3) == 0) {
                ++upgrade;
                if (Random.Int(4) == 0) {
                    ++upgrade;
                    if (Random.Int(5) == 0) {
                        ++upgrade;
                    }
                }
            }
        }
        prizeCh5.upgrade(upgrade);
        prizeCh6.upgrade(upgrade);
        if (Math.ceil((float)Dungeon.depth / 5.0f) == 1.0) {
            if (Random.Int(2) == 0) {
                Dungeon.level.drop((Item)prizeCh1, (int)MinersTool.curUser.pos).sprite.drop();
                isPrizeDropped = true;
            } else {
                Dungeon.level.drop((Item)gold, (int)MinersTool.curUser.pos).sprite.drop();
            }
        } else if (Math.ceil((float)Dungeon.depth / 5.0f) == 2.0) {
            if (Random.Int(2) == 0) {
                Dungeon.level.drop((Item)prizeCh2, (int)MinersTool.curUser.pos).sprite.drop();
                isPrizeDropped = true;
            } else {
                Dungeon.level.drop((Item)gold, (int)MinersTool.curUser.pos).sprite.drop();
            }
        } else if (Math.ceil((float)Dungeon.depth / 5.0f) == 3.0) {
            if (Random.Int(5) == 0) {
                Dungeon.level.drop((Item)prizeCh3, (int)MinersTool.curUser.pos).sprite.drop();
                isPrizeDropped = true;
            } else {
                Dungeon.level.drop((Item)gold, (int)MinersTool.curUser.pos).sprite.drop();
            }
        } else if (Math.ceil((float)Dungeon.depth / 5.0f) == 4.0) {
            if (Random.Int(2) == 0) {
                Dungeon.level.drop((Item)prizeCh4, (int)MinersTool.curUser.pos).sprite.drop();
                isPrizeDropped = true;
            } else {
                Dungeon.level.drop((Item)gold, (int)MinersTool.curUser.pos).sprite.drop();
            }
        } else if (Math.ceil((float)Dungeon.depth / 5.0f) == 5.0) {
            if (Random.Int(10) == 0) {
                Dungeon.level.drop((Item)prizeCh5, (int)MinersTool.curUser.pos).sprite.drop();
                isPrizeDropped = true;
            } else {
                Dungeon.level.drop((Item)gold, (int)MinersTool.curUser.pos).sprite.drop();
            }
        } else if (Math.ceil((float)Dungeon.depth / 5.0f) == 6.0) {
            if (Random.Int(2) == 0) {
                Dungeon.level.drop((Item)prizeCh6, (int)MinersTool.curUser.pos).sprite.drop();
                isPrizeDropped = true;
            } else {
                Dungeon.level.drop((Item)gold, (int)MinersTool.curUser.pos).sprite.drop();
            }
        }
        Sample.INSTANCE.play("sounds/evoke.mp3");
        MinersTool.curUser.sprite.zap(cell);
        CellEmitter.center(cell).burst(Speck.factory(1), 10);
        curUser.spendAndNext(3.0f);
        GameScene.updateMap(cell);
        curUser.busy();
        Buff.affect(curUser, MinersToolCoolDown.class, Math.max(20 - 2 * this.buffedLvl(), 5));
        Invisibility.dispel();
        if (isPrizeDropped) {
            GLog.p(Messages.get(MinersTool.class, "prize_mining", new Object[0]), new Object[0]);
        } else {
            GLog.p(Messages.get(MinersTool.class, "gold_mining", new Object[0]), new Object[0]);
        }
    }

    public void floorMining(int cell) {
        Heap heap = (Heap)Dungeon.level.heaps.get(cell);
        if (heap != null && heap.type != Heap.Type.FOR_SALE && heap.type != Heap.Type.LOCKED_CHEST && heap.type != Heap.Type.CRYSTAL_CHEST) {
            for (Item item : heap.items) {
                Dungeon.dropToChasm(item);
            }
            heap.sprite.kill();
            GameScene.discard(heap);
            Dungeon.level.heaps.remove(cell);
        }
        if (heap != null && (heap.type == Heap.Type.FOR_SALE || heap.type == Heap.Type.LOCKED_CHEST || heap.type == Heap.Type.CRYSTAL_CHEST)) {
            GLog.w(Messages.get(MinersTool.class, "cannot_mine", new Object[0]), new Object[0]);
            return;
        }
        Level.set(cell, 0);
        Char ch = Actor.findChar(cell);
        if (ch != null && !ch.flying) {
            if (ch == Dungeon.hero) {
                Chasm.heroFall(cell);
            } else {
                Chasm.mobFall((Mob)ch);
            }
        }
        MinersTool.curUser.sprite.zap(cell);
        Sample.INSTANCE.play("sounds/rocks.mp3");
        CellEmitter.get(cell).start(Speck.factory(8), 0.07f, 10);
        for (Mob mob : Dungeon.level.mobs.toArray(new Mob[0])) {
            mob.beckon(MinersTool.curUser.pos);
        }
        curUser.spendAndNext(3.0f);
        for (int i : PathFinder.NEIGHBOURS9) {
            GameScene.updateMap(cell + i);
        }
        curUser.busy();
        Buff.affect(curUser, MinersToolCoolDown.class, 50.0f);
        Invisibility.dispel();
        GLog.w(Messages.get(MinersTool.class, "floor_mining", new Object[0]), new Object[0]);
    }

    public void filling(int cell) {
        Level.set(cell, 2);
        for (int i : PathFinder.NEIGHBOURS9) {
            GameScene.updateMap(MinersTool.curUser.pos + i);
        }
        CellEmitter.get(cell).burst(LeafParticle.LEVEL_SPECIFIC, 4);
        Sample.INSTANCE.play("sounds/trample.mp3", 2.0f, 1.1f);
        MinersTool.curUser.sprite.operate(MinersTool.curUser.pos);
        curUser.spend(1.0f);
        curUser.busy();
        Buff.affect(curUser, MinersToolCoolDown.class, Math.max(20 - 2 * this.buffedLvl(), 5));
        Invisibility.dispel();
        GLog.i(Messages.get(MinersTool.class, "filling", new Object[0]), new Object[0]);
    }

    public void statueMining(int cell) {
        if (Random.Int(10) == 0) {
            Item stone = Generator.random(Generator.Category.STONE);
            Dungeon.level.drop((Item)stone, (int)cell).sprite.drop();
            GLog.p(Messages.get(MinersTool.class, "statue_mining_stone", new Object[0]), new Object[0]);
        } else {
            GLog.i(Messages.get(MinersTool.class, "statue_mining", new Object[0]), new Object[0]);
        }
        if (Dungeon.level.map[cell] == 25) {
            Level.set(cell, 1);
        } else {
            Level.set(cell, 14);
        }
        MinersTool.curUser.sprite.zap(cell);
        Sample.INSTANCE.play("sounds/rocks.mp3");
        CellEmitter.get(cell).start(Speck.factory(8), 0.07f, 5);
        curUser.spendAndNext(2.0f);
        for (int i : PathFinder.NEIGHBOURS9) {
            GameScene.updateMap(cell + i);
        }
        curUser.busy();
        Buff.affect(curUser, MinersToolCoolDown.class, Math.max(20 - 2 * this.buffedLvl(), 5));
        Invisibility.dispel();
    }

    public void trapDisarming(int cell) {
        Trap t = (Trap)Dungeon.level.traps.get(cell);
        t.reveal();
        t.disarm();
        CellEmitter.get(t.pos).burst(Speck.factory(13), 6);
        Sample.INSTANCE.play("sounds/unlock.mp3");
        Level.set(cell, 19);
        MinersTool.curUser.sprite.operate(MinersTool.curUser.pos);
        curUser.spendAndNext(2.0f);
        GameScene.updateMap(cell);
        curUser.busy();
        Buff.affect(curUser, MinersToolCoolDown.class, Math.max(20 - 2 * this.buffedLvl(), 5));
        Invisibility.dispel();
        GLog.i(Messages.get(MinersTool.class, "trap_disarming", new Object[0]), new Object[0]);
    }

    public void doorBlocking(int cell) {
        Level.set(cell, 13);
        Buff.affect(curUser, MinersToolCoolDown.class, Math.max(20 - 2 * this.buffedLvl(), 5));
        curUser.spendAndNext(3.0f);
        GameScene.updateMap(cell);
        MinersTool.curUser.sprite.operate(cell);
        curUser.busy();
        GLog.p(Messages.get(MinersTool.class, "door_blocking", new Object[0]), new Object[0]);
        CellEmitter.get(cell).burst(LeafParticle.LEVEL_SPECIFIC, 4);
        CellEmitter.bottom(cell).start(EarthParticle.FACTORY, 0.05f, 8);
        Sample.INSTANCE.play("sounds/plant.mp3");
        Invisibility.dispel();
    }

    public void wellMining(int cell) {
        if (Random.Int(10) < 2) {
            if (Random.Int(10) < 1) {
                Level.set(cell, 24);
                Class<WellWater> waterClass = this.overrideWater != null ? this.overrideWater : Random.element(WATERS);
                WellWater.seed(cell, 1, waterClass, Dungeon.level);
                GeyserTrap geyser = new GeyserTrap();
                geyser.pos = cell;
                geyser.activate();
                GLog.p(Messages.get(MinersTool.class, "well_mining", new Object[0]), new Object[0]);
            } else {
                Dungeon.level.drop((Item)new Dewdrop(), (int)cell).sprite.drop();
                GLog.p(Messages.get(MinersTool.class, "dew_drop", new Object[0]), new Object[0]);
            }
        } else {
            GLog.i(Messages.get(MinersTool.class, "nothing", new Object[0]), new Object[0]);
        }
        Buff.affect(curUser, MinersToolCoolDown.class, 50.0f);
        Sample.INSTANCE.play("sounds/evoke.mp3");
        MinersTool.curUser.sprite.zap(cell);
        CellEmitter.center(cell).burst(Speck.factory(1), 10);
        curUser.spendAndNext(3.0f);
        GameScene.updateMap(cell);
        curUser.busy();
        Invisibility.dispel();
    }
}

