/*
 * Decompiled with CFR 0.152.
 */
package com.shatteredpixel.shatteredpixeldungeon.items.weapon.melee;

import com.shatteredpixel.shatteredpixeldungeon.Dungeon;
import com.shatteredpixel.shatteredpixeldungeon.actors.Char;
import com.shatteredpixel.shatteredpixeldungeon.actors.buffs.Buff;
import com.shatteredpixel.shatteredpixeldungeon.actors.buffs.Cripple;
import com.shatteredpixel.shatteredpixeldungeon.actors.buffs.FlavourBuff;
import com.shatteredpixel.shatteredpixeldungeon.actors.buffs.Invisibility;
import com.shatteredpixel.shatteredpixeldungeon.actors.hero.Hero;
import com.shatteredpixel.shatteredpixeldungeon.items.weapon.melee.MeleeWeapon;
import com.shatteredpixel.shatteredpixeldungeon.sprites.ItemSpriteSheet;
import com.shatteredpixel.shatteredpixeldungeon.ui.AttackIndicator;
import com.watabou.noosa.audio.Sample;
import com.watabou.utils.Callback;
import com.watabou.utils.Random;

public class Nunchaku
extends MeleeWeapon {
    public Nunchaku() {
        this.image = ItemSpriteSheet.NUNCHAKU;
        this.hitSound = "sounds/hit_crush.mp3";
        this.hitSoundPitch = 1.0f;
        this.tier = 2;
        this.DLY = 0.5f;
    }

    @Override
    public int proc(Char attacker, Char defender, int damage) {
        if (Random.Int(10) == 0) {
            Buff.affect(defender, Cripple.class, 3.0f);
        }
        return super.proc(attacker, defender, damage);
    }

    @Override
    public int max(int lvl) {
        return Math.round(2.5f * (float)(this.tier + 1)) + lvl * Math.round(0.5f * (float)(this.tier + 1));
    }

    @Override
    protected int baseChargeUse(Hero hero, Char target) {
        return 2;
    }

    @Override
    protected void duelistAbility(Hero hero, Integer target) {
        this.beforeAbilityUsed(hero, null);
        Invisibility.dispel();
        Buff.affect(hero, ParryTracker.class, 1.0f);
        hero.spendAndNext(1.0f);
        hero.busy();
        this.afterAbilityUsed(hero);
    }

    public static class ParryTracker
    extends FlavourBuff {
        public boolean parried;

        public ParryTracker() {
            this.actPriority = 1;
        }
    }

    public static class RiposteTracker
    extends Buff {
        public Char enemy;

        public RiposteTracker() {
            this.actPriority = 100;
        }

        @Override
        public boolean act() {
            this.target.sprite.attack(this.enemy.pos, new Callback(){

                @Override
                public void call() {
                    AttackIndicator.target(enemy);
                    if (Dungeon.hero.attack(enemy, 0.5f, 0.0f, Char.INFINITE_ACCURACY)) {
                        Sample.INSTANCE.play("sounds/hit_strong.mp3");
                    }
                    this.next();
                    if (!enemy.isAlive()) {
                        MeleeWeapon cfr_ignored_0 = (MeleeWeapon)Dungeon.hero.belongings.attackingWeapon();
                        MeleeWeapon.onAbilityKill(Dungeon.hero, enemy);
                    } else {
                        Buff.affect(enemy, Cripple.class, 5.0f);
                    }
                }
            });
            this.detach();
            return false;
        }
    }
}

