/*
 * Decompiled with CFR 0.152.
 */
package com.shatteredpixel.shatteredpixeldungeon.items.weapon.melee;

import com.shatteredpixel.shatteredpixeldungeon.actors.Char;
import com.shatteredpixel.shatteredpixeldungeon.actors.hero.Hero;
import com.shatteredpixel.shatteredpixeldungeon.items.LiquidMetal;
import com.shatteredpixel.shatteredpixeldungeon.items.Recipe;
import com.shatteredpixel.shatteredpixeldungeon.items.scrolls.ScrollOfUpgrade;
import com.shatteredpixel.shatteredpixeldungeon.items.weapon.melee.EnergyWeapon;
import com.shatteredpixel.shatteredpixeldungeon.items.weapon.melee.Rapier;
import com.shatteredpixel.shatteredpixeldungeon.messages.Messages;
import com.shatteredpixel.shatteredpixeldungeon.sprites.ItemSpriteSheet;

public class Rapier_Energy
extends EnergyWeapon {
    public Rapier_Energy() {
        this.image = ItemSpriteSheet.RAPIER_ENERGY;
        this.hitSound = "sounds/hit_slash.mp3";
        this.hitSoundPitch = 1.3f;
        this.tier = 1;
        this.bones = false;
        this.chargePerHit = 2;
        this.chargeUsePerHit = 4;
    }

    @Override
    public int max(int lvl) {
        return 5 * (this.tier + 2) + lvl;
    }

    @Override
    public int defenseFactor(Char owner) {
        return 1;
    }

    @Override
    public String targetingPrompt() {
        return Messages.get(this, "prompt", new Object[0]);
    }

    @Override
    protected void duelistAbility(Hero hero, Integer target) {
        Rapier.lungeAbility(hero, target, 1.67f, 0, this);
    }

    public static class Recipe
    extends Recipe.SimpleRecipe {
        public Recipe() {
            this.inputs = new Class[]{Rapier.class, ScrollOfUpgrade.class, LiquidMetal.class};
            this.inQuantity = new int[]{1, 1, 10};
            this.cost = 8;
            this.output = Rapier_Energy.class;
            this.outQuantity = 1;
        }
    }
}

