/*
 * Decompiled with CFR 0.152.
 */
package com.shatteredpixel.shatteredpixeldungeon.items.weapon.melee;

import com.shatteredpixel.shatteredpixeldungeon.actors.Char;
import com.shatteredpixel.shatteredpixeldungeon.actors.buffs.Buff;
import com.shatteredpixel.shatteredpixeldungeon.actors.hero.Hero;
import com.shatteredpixel.shatteredpixeldungeon.items.LiquidMetal;
import com.shatteredpixel.shatteredpixeldungeon.items.Recipe;
import com.shatteredpixel.shatteredpixeldungeon.items.scrolls.ScrollOfUpgrade;
import com.shatteredpixel.shatteredpixeldungeon.items.weapon.melee.EnergyWeapon;
import com.shatteredpixel.shatteredpixeldungeon.items.weapon.melee.Saber;
import com.shatteredpixel.shatteredpixeldungeon.sprites.ItemSpriteSheet;

public class Saber_Energy
extends EnergyWeapon {
    public Saber_Energy() {
        this.image = ItemSpriteSheet.SABER_ENERGY;
        this.hitSound = "sounds/hit_slash.mp3";
        this.hitSoundPitch = 1.1f;
        this.tier = 1;
        this.bones = false;
        this.chargePerHit = 2;
        this.chargeUsePerHit = 4;
    }

    @Override
    public int max(int lvl) {
        return 5 * (this.tier + 2) + lvl;
    }

    @Override
    public int defenseFactor(Char owner) {
        return 2;
    }

    @Override
    protected int baseChargeUse(Hero hero, Char target) {
        return 2;
    }

    @Override
    protected void duelistAbility(Hero hero, Integer target) {
        this.beforeAbilityUsed(hero, null);
        Buff.prolong(hero, Saber.BlockingStance.class, 5.0f);
        hero.sprite.operate(hero.pos);
        hero.next();
        this.afterAbilityUsed(hero);
    }

    public static class Recipe
    extends Recipe.SimpleRecipe {
        public Recipe() {
            this.inputs = new Class[]{Saber.class, ScrollOfUpgrade.class, LiquidMetal.class};
            this.inQuantity = new int[]{1, 1, 10};
            this.cost = 8;
            this.output = Saber_Energy.class;
            this.outQuantity = 1;
        }
    }
}

