/*
 * Decompiled with CFR 0.152.
 */
package com.shatteredpixel.shatteredpixeldungeon.items.weapon.melee;

import com.shatteredpixel.shatteredpixeldungeon.Dungeon;
import com.shatteredpixel.shatteredpixeldungeon.actors.Char;
import com.shatteredpixel.shatteredpixeldungeon.actors.buffs.Bleeding;
import com.shatteredpixel.shatteredpixeldungeon.actors.buffs.Buff;
import com.shatteredpixel.shatteredpixeldungeon.actors.buffs.Cripple;
import com.shatteredpixel.shatteredpixeldungeon.actors.hero.Hero;
import com.shatteredpixel.shatteredpixeldungeon.actors.hero.HeroSubClass;
import com.shatteredpixel.shatteredpixeldungeon.items.weapon.melee.Knife;
import com.shatteredpixel.shatteredpixeldungeon.items.weapon.melee.MeleeWeapon;
import com.shatteredpixel.shatteredpixeldungeon.messages.Messages;
import com.shatteredpixel.shatteredpixeldungeon.sprites.ItemSpriteSheet;

public class Scythe
extends MeleeWeapon {
    public Scythe() {
        this.image = ItemSpriteSheet.SCYTHE;
        this.hitSound = "sounds/hit_slash.mp3";
        this.hitSoundPitch = 0.8f;
        this.tier = 4;
        this.DLY = 1.5f;
    }

    @Override
    public int max(int lvl) {
        return Math.round(6.67f * (float)(this.tier + 1)) + lvl * Math.round(1.33f * (float)(this.tier + 1));
    }

    @Override
    protected int baseChargeUse(Hero hero, Char target) {
        return 3;
    }

    @Override
    public int proc(Char attacker, Char defender, int damage) {
        if (Dungeon.hero.subClass == HeroSubClass.WEAPONMASTER && defender.alignment != Char.Alignment.ALLY) {
            Buff.affect(defender, Cripple.class, 2 + this.buffedLvl());
        }
        Buff.affect(defender, Bleeding.class).set(Math.round((float)damage * 0.1f));
        return super.proc(attacker, defender, damage);
    }

    @Override
    public String targetingPrompt() {
        return Messages.get(this, "prompt", new Object[0]);
    }

    @Override
    protected void duelistAbility(Hero hero, Integer target) {
        Knife.knifeAbility(hero, target, 0.33f, this);
    }
}

