/*
 * Decompiled with CFR 0.152.
 */
package com.shatteredpixel.shatteredpixeldungeon.items.weapon.melee;

import com.shatteredpixel.shatteredpixeldungeon.Dungeon;
import com.shatteredpixel.shatteredpixeldungeon.actors.Actor;
import com.shatteredpixel.shatteredpixeldungeon.actors.Char;
import com.shatteredpixel.shatteredpixeldungeon.actors.buffs.Buff;
import com.shatteredpixel.shatteredpixeldungeon.actors.buffs.FlavourBuff;
import com.shatteredpixel.shatteredpixeldungeon.actors.buffs.Invisibility;
import com.shatteredpixel.shatteredpixeldungeon.actors.hero.Hero;
import com.shatteredpixel.shatteredpixeldungeon.items.weapon.melee.MeleeWeapon;
import com.shatteredpixel.shatteredpixeldungeon.items.weapon.melee.Sword;
import com.shatteredpixel.shatteredpixeldungeon.messages.Messages;
import com.shatteredpixel.shatteredpixeldungeon.sprites.ItemSpriteSheet;
import com.shatteredpixel.shatteredpixeldungeon.ui.AttackIndicator;
import com.shatteredpixel.shatteredpixeldungeon.utils.GLog;
import com.watabou.noosa.audio.Sample;
import com.watabou.utils.Callback;

public class Sickle
extends MeleeWeapon {
    public Sickle() {
        this.image = ItemSpriteSheet.SICKLE;
        this.hitSound = "sounds/hit_slash.mp3";
        this.hitSoundPitch = 1.0f;
        this.tier = 2;
        this.ACC = 0.68f;
    }

    @Override
    public int max(int lvl) {
        return Math.round(6.67f * (float)(this.tier + 1)) + lvl * (this.tier + 1);
    }

    @Override
    protected int baseChargeUse(Hero hero, Char target) {
        return 2;
    }

    @Override
    public String targetingPrompt() {
        return Messages.get(this, "prompt", new Object[0]);
    }

    @Override
    protected void duelistAbility(Hero hero, Integer target) {
        Sickle.harvestAbility(hero, target, 1.0f, this);
    }

    public static void harvestAbility(final Hero hero, Integer target, final float bleedFactor, final MeleeWeapon wep) {
        if (target == null) {
            return;
        }
        final Char enemy = Actor.findChar(target);
        if (enemy == null || enemy == hero || hero.isCharmedBy(enemy) || !Dungeon.level.heroFOV[target]) {
            GLog.w(Messages.get(wep, "ability_no_target", new Object[0]), new Object[0]);
            return;
        }
        hero.belongings.abilityWeapon = wep;
        if (!hero.canAttack(enemy)) {
            GLog.w(Messages.get(wep, "ability_bad_position", new Object[0]), new Object[0]);
            hero.belongings.abilityWeapon = null;
            return;
        }
        hero.belongings.abilityWeapon = null;
        hero.sprite.attack(enemy.pos, new Callback(){

            @Override
            public void call() {
                wep.beforeAbilityUsed(hero, enemy);
                AttackIndicator.target(enemy);
                Buff.affect((Char)enemy, HarvestBleedTracker.class, (float)0.0f).bleedFactor = bleedFactor;
                if (hero.attack(enemy, 1.0f, 0.0f, Char.INFINITE_ACCURACY)) {
                    Sample.INSTANCE.play("sounds/hit_strong.mp3");
                }
                Invisibility.dispel();
                hero.spendAndNext(hero.attackDelay());
                if (!enemy.isAlive()) {
                    MeleeWeapon.onAbilityKill(hero, enemy);
                    Buff.prolong(hero, Sword.CleaveTracker.class, 5.0f);
                } else if (hero.buff(Sword.CleaveTracker.class) != null) {
                    hero.buff(Sword.CleaveTracker.class).detach();
                }
                wep.afterAbilityUsed(hero);
            }
        });
    }

    public static class HarvestBleedTracker
    extends FlavourBuff {
        public float bleedFactor;
    }
}

