/*
 * Decompiled with CFR 0.152.
 */
package com.shatteredpixel.shatteredpixeldungeon.items.weapon.melee;

import com.shatteredpixel.shatteredpixeldungeon.Dungeon;
import com.shatteredpixel.shatteredpixeldungeon.actors.Actor;
import com.shatteredpixel.shatteredpixeldungeon.actors.Char;
import com.shatteredpixel.shatteredpixeldungeon.actors.buffs.Barrier;
import com.shatteredpixel.shatteredpixeldungeon.actors.buffs.Buff;
import com.shatteredpixel.shatteredpixeldungeon.actors.buffs.Roots;
import com.shatteredpixel.shatteredpixeldungeon.actors.buffs.ShovelDigCoolDown;
import com.shatteredpixel.shatteredpixeldungeon.actors.hero.HeroSubClass;
import com.shatteredpixel.shatteredpixeldungeon.actors.hero.Talent;
import com.shatteredpixel.shatteredpixeldungeon.actors.mobs.Mob;
import com.shatteredpixel.shatteredpixeldungeon.effects.CellEmitter;
import com.shatteredpixel.shatteredpixeldungeon.effects.particles.LeafParticle;
import com.shatteredpixel.shatteredpixeldungeon.items.Generator;
import com.shatteredpixel.shatteredpixeldungeon.items.Item;
import com.shatteredpixel.shatteredpixeldungeon.items.weapon.enchantments.Lucky;
import com.shatteredpixel.shatteredpixeldungeon.items.weapon.melee.Shovel;
import com.shatteredpixel.shatteredpixeldungeon.levels.Level;
import com.shatteredpixel.shatteredpixeldungeon.messages.Messages;
import com.shatteredpixel.shatteredpixeldungeon.plants.Plant;
import com.shatteredpixel.shatteredpixeldungeon.scenes.GameScene;
import com.shatteredpixel.shatteredpixeldungeon.sprites.ItemSpriteSheet;
import com.shatteredpixel.shatteredpixeldungeon.utils.GLog;
import com.watabou.noosa.audio.Sample;
import com.watabou.utils.PathFinder;
import com.watabou.utils.Random;
import java.util.ArrayList;

public class Spade
extends Shovel {
    public static final String AC_DIG = "DIG";

    public Spade() {
        this.defaultAction = AC_DIG;
        this.image = ItemSpriteSheet.SPADE;
        this.hitSound = "sounds/hit_slash.mp3";
        this.hitSoundPitch = 1.3f;
        this.tier = 5;
        this.unique = true;
        this.bones = false;
    }

    @Override
    public void Dig() {
        int flowers;
        curUser.spend(1.0f);
        curUser.busy();
        Sample.INSTANCE.play("sounds/trample.mp3", 2.0f, 1.1f);
        Spade.curUser.sprite.operate(Spade.curUser.pos);
        GLog.i(Messages.get(this, "dig", new Object[0]), new Object[0]);
        int n = flowers = Random.Int(2) < Dungeon.hero.pointsInTalent(Talent.FLOWER_BED) ? 1 : 0;
        if (Dungeon.hero.subClass == HeroSubClass.RESEARCHER) {
            ArrayList<Integer> positions = new ArrayList<Integer>();
            for (int i : PathFinder.NEIGHBOURS25) {
                positions.add(i);
            }
            Random.shuffle(positions);
            Object object = positions.iterator();
            while (object.hasNext()) {
                int i = (Integer)object.next();
                int c = Dungeon.level.map[Dungeon.hero.pos + i];
                if (c != 1 && c != 20 && c != 9 && c != 2 && c != 29 && c != 30) continue;
                if (flowers > 0) {
                    Dungeon.level.plant((Plant.Seed)Generator.randomUsingDefaults(Generator.Category.SEED), Dungeon.hero.pos);
                    --flowers;
                } else if (Random.Int(8) < 1 + Dungeon.hero.pointsInTalent(Talent.ALIVE_GRASS)) {
                    Level.set(Dungeon.hero.pos + i, 15);
                } else {
                    Level.set(Dungeon.hero.pos + i, 30);
                }
                Char enemy = Actor.findChar(Dungeon.hero.pos + i);
                if (enemy instanceof Mob && Dungeon.hero.hasTalent(Talent.ROOT)) {
                    Buff.affect(enemy, Roots.class, 1 + Dungeon.hero.pointsInTalent(Talent.ROOT));
                }
                GameScene.updateMap(Dungeon.hero.pos + i);
                CellEmitter.get(Dungeon.hero.pos + i).burst(LeafParticle.LEVEL_SPECIFIC, 4);
            }
        } else {
            ArrayList<Integer> positions = new ArrayList<Integer>();
            for (int i : PathFinder.NEIGHBOURS9) {
                positions.add(i);
            }
            Random.shuffle(positions);
            Object object = positions.iterator();
            while (object.hasNext()) {
                int i = (Integer)object.next();
                int c = Dungeon.level.map[Dungeon.hero.pos + i];
                if (c != 1 && c != 20 && c != 9 && c != 2) continue;
                if (flowers > 0) {
                    Dungeon.level.plant((Plant.Seed)Generator.randomUsingDefaults(Generator.Category.SEED), Dungeon.hero.pos + i);
                    --flowers;
                } else {
                    Level.set(Dungeon.hero.pos + i, 30);
                }
                Char enemy = Actor.findChar(Dungeon.hero.pos + i);
                if (enemy instanceof Mob && Dungeon.hero.hasTalent(Talent.ROOT)) {
                    Buff.affect(enemy, Roots.class, 1 + Dungeon.hero.pointsInTalent(Talent.ROOT));
                }
                GameScene.updateMap(Dungeon.hero.pos + i);
                CellEmitter.get(Dungeon.hero.pos + i).burst(LeafParticle.LEVEL_SPECIFIC, 4);
            }
        }
        if (Random.Int(10) < Dungeon.hero.pointsInTalent(Talent.DETECTOR)) {
            Dungeon.level.drop((Item)Lucky.genLoot(), (int)Dungeon.hero.pos).sprite.drop();
            Lucky.showFlare(Dungeon.hero.sprite);
        }
        Buff.affect(Dungeon.hero, ShovelDigCoolDown.class, Math.max(20 - 2 * this.buffedLvl(), 5));
        if (Dungeon.hero.hasTalent(Talent.PLANT_SHIELD)) {
            Buff.affect(Dungeon.hero, Barrier.class).setShield(2 + 3 * Dungeon.hero.pointsInTalent(Talent.PLANT_SHIELD));
        }
    }
}

