/*
 * Decompiled with CFR 0.152.
 */
package com.shatteredpixel.shatteredpixeldungeon.items.weapon.melee;

import com.shatteredpixel.shatteredpixeldungeon.actors.Char;
import com.shatteredpixel.shatteredpixeldungeon.actors.buffs.Buff;
import com.shatteredpixel.shatteredpixeldungeon.actors.buffs.FlavourBuff;
import com.shatteredpixel.shatteredpixeldungeon.actors.hero.Hero;
import com.shatteredpixel.shatteredpixeldungeon.items.weapon.melee.MeleeWeapon;
import com.shatteredpixel.shatteredpixeldungeon.sprites.ItemSpriteSheet;

public class TrueRunicBlade
extends MeleeWeapon {
    public TrueRunicBlade() {
        this.image = ItemSpriteSheet.TRUE_RUNIC_BLADE;
        this.hitSound = "sounds/hit_slash.mp3";
        this.hitSoundPitch = 1.0f;
        this.tier = 5;
    }

    @Override
    public int min(int lvl) {
        return 1;
    }

    @Override
    public int max(int lvl) {
        return 3 + lvl;
    }

    @Override
    protected float baseDelay(Char owner) {
        float delay = this.augment.delayFactor(this.DLY);
        if (owner instanceof Hero) {
            int encumbrance = this.STRReq() - ((Hero)owner).STR();
            delay = encumbrance > 0 ? (float)((double)delay * Math.pow(1.2, encumbrance)) : 1.0f / (19.0f - (float)this.STRReq());
        }
        return delay;
    }

    @Override
    protected int baseChargeUse(Hero hero, Char target) {
        return 2;
    }

    @Override
    protected void duelistAbility(Hero hero, Integer target) {
        this.beforeAbilityUsed(hero, null);
        Buff.prolong(hero, EnchantEmpower.class, 5.0f);
        hero.sprite.operate(hero.pos);
        hero.next();
        this.afterAbilityUsed(hero);
    }

    public static class EnchantEmpower
    extends FlavourBuff {
        public EnchantEmpower() {
            this.announced = true;
            this.type = Buff.buffType.POSITIVE;
        }

        @Override
        public int icon() {
            return 63;
        }

        @Override
        public float iconFadePercent() {
            return Math.max(0.0f, (6.0f - this.visualcooldown()) / 6.0f);
        }
    }
}

