/*
 * Decompiled with CFR 0.152.
 */
package com.shatteredpixel.shatteredpixeldungeon.items.weapon.melee;

import com.shatteredpixel.shatteredpixeldungeon.actors.Char;
import com.shatteredpixel.shatteredpixeldungeon.actors.buffs.Amok;
import com.shatteredpixel.shatteredpixeldungeon.actors.buffs.Blindness;
import com.shatteredpixel.shatteredpixeldungeon.actors.buffs.Buff;
import com.shatteredpixel.shatteredpixeldungeon.actors.buffs.Cripple;
import com.shatteredpixel.shatteredpixeldungeon.actors.buffs.Doom;
import com.shatteredpixel.shatteredpixeldungeon.actors.buffs.FlavourBuff;
import com.shatteredpixel.shatteredpixeldungeon.actors.buffs.Hex;
import com.shatteredpixel.shatteredpixeldungeon.actors.buffs.Paralysis;
import com.shatteredpixel.shatteredpixeldungeon.actors.buffs.Slow;
import com.shatteredpixel.shatteredpixeldungeon.actors.buffs.Terror;
import com.shatteredpixel.shatteredpixeldungeon.actors.buffs.Vulnerable;
import com.shatteredpixel.shatteredpixeldungeon.actors.buffs.Weakness;
import com.shatteredpixel.shatteredpixeldungeon.actors.hero.Hero;
import com.shatteredpixel.shatteredpixeldungeon.effects.Speck;
import com.shatteredpixel.shatteredpixeldungeon.effects.SpellSprite;
import com.shatteredpixel.shatteredpixeldungeon.items.ArcaneResin;
import com.shatteredpixel.shatteredpixeldungeon.items.Recipe;
import com.shatteredpixel.shatteredpixeldungeon.items.wands.WandOfCorruption;
import com.shatteredpixel.shatteredpixeldungeon.items.weapon.melee.Bible;
import com.shatteredpixel.shatteredpixeldungeon.items.weapon.melee.MeleeWeapon;
import com.shatteredpixel.shatteredpixeldungeon.sprites.HeroSprite;
import com.shatteredpixel.shatteredpixeldungeon.sprites.ItemSpriteSheet;
import com.watabou.noosa.audio.Sample;
import com.watabou.utils.Random;

public class UnholyBible
extends MeleeWeapon {
    public UnholyBible() {
        this.image = ItemSpriteSheet.UNHOLY_BIBLE;
        this.hitSound = "sounds/hit.mp3";
        this.hitSoundPitch = 1.1f;
        this.tier = 4;
        this.alchemy = true;
    }

    @Override
    public int proc(Char attacker, Char defender, int damage) {
        switch (Random.Int(15)) {
            default: {
                Buff.affect(defender, Weakness.class, 3.0f);
                break;
            }
            case 2: 
            case 3: {
                Buff.affect(defender, Vulnerable.class, 3.0f);
                break;
            }
            case 4: {
                Buff.affect(defender, Cripple.class, 3.0f);
                break;
            }
            case 5: {
                Buff.affect(defender, Blindness.class, 3.0f);
                break;
            }
            case 6: {
                Buff.affect(defender, Terror.class, 3.0f);
                break;
            }
            case 7: 
            case 8: 
            case 9: {
                Buff.affect(defender, Amok.class, 3.0f);
                break;
            }
            case 10: 
            case 11: {
                Buff.affect(defender, Slow.class, 3.0f);
                break;
            }
            case 12: 
            case 13: {
                Buff.affect(defender, Hex.class, 3.0f);
                break;
            }
            case 14: {
                Buff.affect(defender, Paralysis.class, 3.0f);
            }
        }
        if (Random.Int(100) <= Math.min(this.buffedLvl(), 9)) {
            Buff.affect(defender, Doom.class);
        }
        return damage;
    }

    @Override
    public int max(int lvl) {
        return 3 * this.tier + lvl * (this.tier - 1);
    }

    @Override
    protected int baseChargeUse(Hero hero, Char target) {
        return 2;
    }

    @Override
    protected void duelistAbility(Hero hero, Integer target) {
        UnholyBible.angelAbility(hero, 5, this);
    }

    public static void angelAbility(Hero hero, int duration, MeleeWeapon wep) {
        wep.beforeAbilityUsed(hero, null);
        Buff.prolong(hero, Demon.class, duration);
        hero.next();
        ((HeroSprite)hero.sprite).read();
        SpellSprite.show(hero, 3);
        hero.sprite.centerEmitter().start(Speck.factory(5), 0.3f, 3);
        Sample.INSTANCE.play("sounds/challenge.mp3");
        Sample.INSTANCE.play("sounds/read.mp3");
        wep.afterAbilityUsed(hero);
    }

    public static class Demon
    extends FlavourBuff {
        public Demon() {
            this.announced = true;
            this.type = Buff.buffType.POSITIVE;
        }

        @Override
        public int icon() {
            return 155;
        }

        @Override
        public float iconFadePercent() {
            return Math.max(0.0f, (6.0f - this.visualcooldown()) / 6.0f);
        }
    }

    public static class Recipe
    extends Recipe.SimpleRecipe {
        public Recipe() {
            this.inputs = new Class[]{Bible.class, WandOfCorruption.class, ArcaneResin.class};
            this.inQuantity = new int[]{1, 1, 2};
            this.cost = 10;
            this.output = UnholyBible.class;
            this.outQuantity = 1;
        }
    }
}

