/*
 * Decompiled with CFR 0.152.
 */
package com.shatteredpixel.shatteredpixeldungeon.items.weapon.melee.spellbook;

import com.shatteredpixel.shatteredpixeldungeon.Dungeon;
import com.shatteredpixel.shatteredpixeldungeon.actors.Actor;
import com.shatteredpixel.shatteredpixeldungeon.actors.Char;
import com.shatteredpixel.shatteredpixeldungeon.actors.buffs.AllyBuff;
import com.shatteredpixel.shatteredpixeldungeon.actors.buffs.Amok;
import com.shatteredpixel.shatteredpixeldungeon.actors.buffs.Blindness;
import com.shatteredpixel.shatteredpixeldungeon.actors.buffs.Buff;
import com.shatteredpixel.shatteredpixeldungeon.actors.buffs.Corruption;
import com.shatteredpixel.shatteredpixeldungeon.actors.buffs.Cripple;
import com.shatteredpixel.shatteredpixeldungeon.actors.buffs.Doom;
import com.shatteredpixel.shatteredpixeldungeon.actors.buffs.Hex;
import com.shatteredpixel.shatteredpixeldungeon.actors.buffs.Paralysis;
import com.shatteredpixel.shatteredpixeldungeon.actors.buffs.Slow;
import com.shatteredpixel.shatteredpixeldungeon.actors.buffs.SpellBookCoolDown;
import com.shatteredpixel.shatteredpixeldungeon.actors.buffs.Terror;
import com.shatteredpixel.shatteredpixeldungeon.actors.buffs.Vulnerable;
import com.shatteredpixel.shatteredpixeldungeon.actors.buffs.Weakness;
import com.shatteredpixel.shatteredpixeldungeon.actors.hero.Hero;
import com.shatteredpixel.shatteredpixeldungeon.actors.mobs.Mob;
import com.shatteredpixel.shatteredpixeldungeon.effects.particles.ShadowParticle;
import com.shatteredpixel.shatteredpixeldungeon.items.Recipe;
import com.shatteredpixel.shatteredpixeldungeon.items.wands.WandOfCorruption;
import com.shatteredpixel.shatteredpixeldungeon.items.weapon.SpiritBow;
import com.shatteredpixel.shatteredpixeldungeon.items.weapon.melee.spellbook.SpellBook;
import com.shatteredpixel.shatteredpixeldungeon.items.weapon.melee.spellbook.SpellBook_Empty;
import com.shatteredpixel.shatteredpixeldungeon.messages.Messages;
import com.shatteredpixel.shatteredpixeldungeon.scenes.CellSelector;
import com.shatteredpixel.shatteredpixeldungeon.scenes.GameScene;
import com.shatteredpixel.shatteredpixeldungeon.sprites.ItemSpriteSheet;
import com.shatteredpixel.shatteredpixeldungeon.utils.GLog;
import com.watabou.noosa.audio.Sample;
import com.watabou.utils.Random;

public class SpellBook_Corruption
extends SpellBook {
    private CellSelector.Listener spell;

    public SpellBook_Corruption() {
        this.image = ItemSpriteSheet.CORRUPTION_SPELLBOOK;
        this.hitSound = "sounds/hit.mp3";
        this.hitSoundPitch = 1.1f;
        this.tier = 3;
        this.spell = new CellSelector.Listener(){

            @Override
            public void onSelect(Integer target) {
                if (target != null) {
                    Char ch = Actor.findChar(target);
                    if (ch != null) {
                        if (ch != Dungeon.hero) {
                            switch (Random.Int(15)) {
                                default: {
                                    Buff.affect(ch, Weakness.class, 3.0f + (float)SpellBook_Corruption.this.buffedLvl());
                                    break;
                                }
                                case 2: 
                                case 3: {
                                    Buff.affect(ch, Vulnerable.class, 3.0f + (float)SpellBook_Corruption.this.buffedLvl());
                                    break;
                                }
                                case 4: {
                                    Buff.affect(ch, Cripple.class, 3.0f + (float)SpellBook_Corruption.this.buffedLvl());
                                    break;
                                }
                                case 5: {
                                    Buff.affect(ch, Blindness.class, 3.0f + (float)SpellBook_Corruption.this.buffedLvl());
                                    break;
                                }
                                case 6: {
                                    Buff.affect(ch, Terror.class, 3.0f + (float)SpellBook_Corruption.this.buffedLvl());
                                    break;
                                }
                                case 7: 
                                case 8: 
                                case 9: {
                                    Buff.affect(ch, Amok.class, 3.0f + (float)SpellBook_Corruption.this.buffedLvl());
                                    break;
                                }
                                case 10: 
                                case 11: {
                                    Buff.affect(ch, Slow.class, 3.0f + (float)SpellBook_Corruption.this.buffedLvl());
                                    break;
                                }
                                case 12: 
                                case 13: {
                                    Buff.affect(ch, Hex.class, 3.0f + (float)SpellBook_Corruption.this.buffedLvl());
                                    break;
                                }
                                case 14: {
                                    Buff.affect(ch, Paralysis.class, 3.0f + (float)SpellBook_Corruption.this.buffedLvl());
                                }
                            }
                            if (Random.Int(100) <= Math.min(Dungeon.hero.belongings.weapon.buffedLvl(), 9)) {
                                Buff.affect(ch, Doom.class);
                            }
                            ch.sprite.emitter().start(ShadowParticle.UP, 0.05f, 10);
                            Sample.INSTANCE.play("sounds/burning.mp3");
                        } else {
                            GLog.p(Messages.get(SpellBook_Corruption.this, "cannot_hero", new Object[0]), new Object[0]);
                        }
                    } else {
                        GLog.p(Messages.get(SpellBook_Corruption.this, "cannot_cast", new Object[0]), new Object[0]);
                    }
                    Dungeon.hero.sprite.emitter().start(ShadowParticle.UP, 0.05f, 10);
                    if (SpellBook.needAnimation) {
                        SpellBook_Corruption.this.readAnimation();
                    }
                }
            }

            @Override
            public String prompt() {
                return Messages.get(SpiritBow.class, "prompt", new Object[0]);
            }
        };
    }

    @Override
    public int proc(Char attacker, Char defender, int damage) {
        int procBonus = 0;
        if (defender.buff(Weakness.class) != null) {
            ++procBonus;
        }
        if (defender.buff(Vulnerable.class) != null) {
            ++procBonus;
        }
        if (defender.buff(Cripple.class) != null) {
            ++procBonus;
        }
        if (defender.buff(Blindness.class) != null) {
            ++procBonus;
        }
        if (defender.buff(Terror.class) != null) {
            ++procBonus;
        }
        if (defender.buff(Amok.class) != null) {
            procBonus += 2;
        }
        if (defender.buff(Slow.class) != null) {
            procBonus += 2;
        }
        if (defender.buff(Hex.class) != null) {
            procBonus += 2;
        }
        if (defender.buff(Paralysis.class) != null) {
            procBonus += 2;
        }
        float procChance = defender.buff(Doom.class) != null ? 1.0f : ((float)this.buffedLvl() + 5.0f + (float)procBonus) / ((float)this.buffedLvl() + 25.0f);
        if (damage >= defender.HP && Random.Float() < procChance && !defender.isImmune(Corruption.class) && defender.buff(Corruption.class) == null && defender instanceof Mob && defender.isAlive()) {
            Mob mob = (Mob)defender;
            Corruption.corruptionHeal(mob);
            AllyBuff.affectAndLoot(mob, Dungeon.hero, Corruption.class);
            damage = 0;
        }
        return super.proc(attacker, defender, damage);
    }

    @Override
    public void execute(Hero hero, String action) {
        super.execute(hero, action);
        if (action.equals("READ")) {
            if (hero.buff(SpellBookCoolDown.class) != null) {
                return;
            }
            if (!this.isIdentified()) {
                return;
            }
            this.readEffect(hero, true);
        }
    }

    @Override
    public void readEffect(Hero hero, boolean busy) {
        this.usesTargeting = true;
        curUser = hero;
        curItem = this;
        needAnimation = busy;
        GameScene.selectCell(this.spell);
    }

    public static class Recipe
    extends Recipe.SimpleRecipe {
        public Recipe() {
            this.inputs = new Class[]{SpellBook_Empty.class, WandOfCorruption.class};
            this.inQuantity = new int[]{1, 1};
            this.cost = 10;
            this.output = SpellBook_Corruption.class;
            this.outQuantity = 1;
        }
    }
}

