/*
 * Decompiled with CFR 0.152.
 */
package com.shatteredpixel.shatteredpixeldungeon.items.weapon.melee.spellbook;

import com.shatteredpixel.shatteredpixeldungeon.Dungeon;
import com.shatteredpixel.shatteredpixeldungeon.actors.Char;
import com.shatteredpixel.shatteredpixeldungeon.actors.blobs.Blob;
import com.shatteredpixel.shatteredpixeldungeon.actors.blobs.Electricity;
import com.shatteredpixel.shatteredpixeldungeon.actors.buffs.BlobImmunity;
import com.shatteredpixel.shatteredpixeldungeon.actors.buffs.Buff;
import com.shatteredpixel.shatteredpixeldungeon.actors.buffs.SpellBookCoolDown;
import com.shatteredpixel.shatteredpixeldungeon.actors.hero.Hero;
import com.shatteredpixel.shatteredpixeldungeon.effects.Lightning;
import com.shatteredpixel.shatteredpixeldungeon.items.Recipe;
import com.shatteredpixel.shatteredpixeldungeon.items.wands.WandOfLightning;
import com.shatteredpixel.shatteredpixeldungeon.items.weapon.SpiritBow;
import com.shatteredpixel.shatteredpixeldungeon.items.weapon.enchantments.Shocking;
import com.shatteredpixel.shatteredpixeldungeon.items.weapon.melee.spellbook.SpellBook;
import com.shatteredpixel.shatteredpixeldungeon.items.weapon.melee.spellbook.SpellBook_Empty;
import com.shatteredpixel.shatteredpixeldungeon.messages.Messages;
import com.shatteredpixel.shatteredpixeldungeon.scenes.CellSelector;
import com.shatteredpixel.shatteredpixeldungeon.scenes.GameScene;
import com.shatteredpixel.shatteredpixeldungeon.sprites.ItemSpriteSheet;
import com.shatteredpixel.shatteredpixeldungeon.utils.GLog;
import com.watabou.noosa.audio.Sample;
import com.watabou.utils.PathFinder;
import com.watabou.utils.Random;
import java.util.ArrayList;

public class SpellBook_Lightning
extends SpellBook {
    private CellSelector.Listener spell;

    public SpellBook_Lightning() {
        this.image = ItemSpriteSheet.LIGHTNING_SPELLBOOK;
        this.hitSound = "sounds/hit.mp3";
        this.hitSoundPitch = 1.1f;
        this.tier = 3;
        this.spell = new CellSelector.Listener(){

            @Override
            public void onSelect(Integer cell) {
                if (cell != null) {
                    if (SpellBook_Lightning.this.buffedLvl() >= 10) {
                        boolean infov = false;
                        for (int n : PathFinder.NEIGHBOURS9) {
                            int c = cell + n;
                            if (Dungeon.level.map[c] == 4 || !Dungeon.level.heroFOV[c]) continue;
                            if (Dungeon.level.pit[c]) {
                                GameScene.add(Blob.seed(c, 2, Electricity.class));
                            } else {
                                GameScene.add(Blob.seed(c, 5 + SpellBook_Lightning.this.buffedLvl(), Electricity.class));
                            }
                            infov = true;
                        }
                        if (!infov) {
                            GLog.w(Messages.get(SpellBook_Lightning.this, "cannot_cast", new Object[0]), new Object[0]);
                        }
                    } else if (Dungeon.level.map[cell] != 4 && Dungeon.level.heroFOV[cell]) {
                        if (Dungeon.level.pit[cell]) {
                            GameScene.add(Blob.seed(cell, 2, Electricity.class));
                        } else {
                            GameScene.add(Blob.seed(cell, 5 + SpellBook_Lightning.this.buffedLvl(), Electricity.class));
                        }
                    } else {
                        GLog.w(Messages.get(SpellBook_Lightning.this, "cannot_cast", new Object[0]), new Object[0]);
                    }
                    Sample.INSTANCE.play("sounds/lightning.mp3");
                }
            }

            @Override
            public String prompt() {
                return Messages.get(SpiritBow.class, "prompt", new Object[0]);
            }
        };
    }

    @Override
    public int proc(Char attacker, Char defender, int damage) {
        ArrayList<Lightning.Arc> arcs = new ArrayList<Lightning.Arc>();
        ArrayList<Char> affected = new ArrayList<Char>();
        float procChance = ((float)this.buffedLvl() + 1.0f) / ((float)this.buffedLvl() + 4.0f);
        if (Random.Float() < procChance) {
            affected.clear();
            arcs.clear();
            Shocking.arc(Dungeon.hero, defender, 2, affected, arcs);
            affected.remove(defender);
            for (Char ch : affected) {
                if (ch.alignment == Dungeon.hero.alignment) continue;
                ch.damage(Math.round((float)damage * 0.4f), this);
            }
            Dungeon.hero.sprite.parent.addToFront(new Lightning(arcs, null));
            Sample.INSTANCE.play("sounds/lightning.mp3");
        }
        return super.proc(attacker, defender, damage);
    }

    @Override
    public void execute(Hero hero, String action) {
        super.execute(hero, action);
        if (action.equals("READ")) {
            if (hero.buff(SpellBookCoolDown.class) != null) {
                return;
            }
            if (!this.isIdentified()) {
                return;
            }
            this.readEffect(hero, true);
        }
    }

    @Override
    public void readEffect(Hero hero, boolean busy) {
        needAnimation = busy;
        int[] pathFinder = this.buffedLvl() >= 10 ? PathFinder.NEIGHBOURS25 : PathFinder.NEIGHBOURS9;
        for (int i : pathFinder) {
            int c = hero.pos + i;
            if (Dungeon.level.map[c] == 4 || !Dungeon.level.heroFOV[c]) continue;
            if (Dungeon.level.pit[c]) {
                GameScene.add(Blob.seed(c, 1, Electricity.class));
                continue;
            }
            GameScene.add(Blob.seed(c, 5 + this.buffedLvl(), Electricity.class));
        }
        Buff.affect(hero, BlobImmunity.class, 10 + 2 * this.buffedLvl());
        Sample.INSTANCE.play("sounds/chargeup.mp3");
        if (needAnimation) {
            this.readAnimation();
        }
    }

    public static class Recipe
    extends Recipe.SimpleRecipe {
        public Recipe() {
            this.inputs = new Class[]{SpellBook_Empty.class, WandOfLightning.class};
            this.inQuantity = new int[]{1, 1};
            this.cost = 10;
            this.output = SpellBook_Lightning.class;
            this.outQuantity = 1;
        }
    }
}

